/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import java.io.IOException;
import java.util.List;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogWriter;

public abstract class AbstractChronicleAppender
extends ContextAwareBase
implements Appender<ILoggingEvent> {
    private final FilterAttachableImpl<ILoggingEvent> filterAttachable = new FilterAttachableImpl();
    private String name = null;
    private boolean started = false;
    private String path = null;
    private String wireType = null;
    protected ChronicleLogWriter writer = null;

    protected AbstractChronicleAppender() {
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getWireType() {
        return this.wireType;
    }

    public void setWireType(String wireType) {
        this.wireType = wireType;
    }

    protected abstract ChronicleLogWriter createWriter() throws IOException;

    protected abstract void doAppend(ILoggingEvent var1, ChronicleLogWriter var2);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void addFilter(Filter<ILoggingEvent> newFilter) {
        this.filterAttachable.addFilter(newFilter);
    }

    public void clearAllFilters() {
        this.filterAttachable.clearAllFilters();
    }

    public List<Filter<ILoggingEvent>> getCopyOfAttachedFiltersList() {
        return this.filterAttachable.getCopyOfAttachedFiltersList();
    }

    public FilterReply getFilterChainDecision(ILoggingEvent event) {
        return this.filterAttachable.getFilterChainDecision((Object)event);
    }

    public void start() {
        if (this.getPath() == null) {
            this.addError("Appender " + this.getName() + " has configuration errors and is not started!");
        } else {
            try {
                this.writer = this.createWriter();
                this.started = true;
            }
            catch (IOException e) {
                this.writer = null;
                this.addError("Appender " + this.getName() + " " + e.getMessage());
            }
        }
    }

    public void stop() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                this.addError("Appender " + this.getName() + " " + e.getMessage());
            }
        }
        this.started = false;
    }

    public void doAppend(ILoggingEvent event) {
        if (this.getFilterChainDecision(event) != FilterReply.DENY) {
            this.doAppend(event, this.writer);
        }
    }

    public static ChronicleLogLevel toChronicleLogLevel(Level level) {
        switch (level.levelInt) {
            case 10000: {
                return ChronicleLogLevel.DEBUG;
            }
            case 5000: {
                return ChronicleLogLevel.TRACE;
            }
            case 20000: {
                return ChronicleLogLevel.INFO;
            }
            case 30000: {
                return ChronicleLogLevel.WARN;
            }
            case 40000: {
                return ChronicleLogLevel.ERROR;
            }
        }
        throw new IllegalArgumentException(level.levelInt + " not a valid level value");
    }
}

