/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public enum GenericReflection {


    public static Set<Type> getMethodReturnTypes(Type type) {
        LinkedHashSet<Type> types = new LinkedHashSet<Type>();
        if (type instanceof Class || type instanceof ParameterizedType) {
            for (Method method : GenericReflection.erase(type).getMethods()) {
                types.add(GenericReflection.getReturnType(method, type));
            }
            return types;
        }
        throw new UnsupportedOperationException();
    }

    public static Type getReturnType(Method method, Type type) {
        Type genericReturnType = method.getGenericReturnType();
        return GenericReflection.findType(method, type, genericReturnType);
    }

    @Nullable
    private static Type findType(Method method, Type type, Type genericReturnType) {
        if (genericReturnType instanceof Class) {
            return genericReturnType;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        Optional<Type> extendsType = GenericReflection.getGenericClassesSuperclassesAndInterfaces(type).filter(t -> declaringClass.equals(GenericReflection.erase(t))).findFirst();
        TypeVariable<Class<?>>[] typeParameters = declaringClass.getTypeParameters();
        if (extendsType.isPresent() && extendsType.get() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)extendsType.get();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (!typeParameters[i].equals(genericReturnType)) continue;
                return actualTypeArguments[i];
            }
        }
        return genericReturnType;
    }

    public static Type[] getParameterTypes(Method method, Type type) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object typeI = GenericReflection.findType(method, type, parameterTypes[i]);
            if (typeI instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)typeI;
                Type[] bounds = typeVariable.getBounds();
                typeI = bounds.length > 0 ? bounds[0] : Object.class;
            }
            parameterTypes[i] = typeI;
        }
        return parameterTypes;
    }

    static Stream<Type> getGenericClassesSuperclassesAndInterfaces(Type forClass) {
        HashSet<Type> result = new HashSet<Type>();
        GenericReflection.getGenericClassesSuperclassesAndInterfaces(forClass, result);
        return result.stream();
    }

    private static void getGenericClassesSuperclassesAndInterfaces(Type forClass, Set<Type> collectedTypes) {
        if (forClass instanceof ParameterizedType) {
            collectedTypes.add(forClass);
            GenericReflection.getGenericClassesSuperclassesAndInterfaces(((ParameterizedType)forClass).getRawType(), collectedTypes);
            return;
        }
        if (!(forClass instanceof Class)) {
            throw new UnsupportedOperationException();
        }
        Class forClass2 = (Class)forClass;
        for (Type genericInterface : forClass2.getGenericInterfaces()) {
            GenericReflection.getGenericClassesSuperclassesAndInterfaces(genericInterface, collectedTypes);
        }
        Type superclass = forClass2.getGenericSuperclass();
        if (superclass != null) {
            GenericReflection.getGenericClassesSuperclassesAndInterfaces(superclass, collectedTypes);
        }
    }

    public static Class<?> erase(Type type) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return GenericReflection.erase(tv.getBounds()[0]);
        }
        if (type instanceof ParameterizedType) {
            return GenericReflection.erase(((ParameterizedType)type).getRawType());
        }
        return (Class)type;
    }
}

