/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.shutdown;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class Hooklet
implements Comparable<Hooklet> {
    public abstract void onShutdown();

    public abstract int priority();

    protected Object identity() {
        return this.getClass();
    }

    public static Hooklet of(final int priority, final Runnable hook) {
        Objects.requireNonNull(hook);
        return new Hooklet(){

            @Override
            public void onShutdown() {
                hook.run();
            }

            @Override
            public int priority() {
                return priority;
            }

            @Override
            protected Object identity() {
                return hook.getClass();
            }
        };
    }

    @Override
    public int compareTo(@NotNull Hooklet other) {
        int delta = this.priority() - other.priority();
        if (delta == 0) {
            return this.identity().hashCode() - other.identity().hashCode();
        }
        return delta;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Hooklet)) {
            return false;
        }
        Hooklet that = (Hooklet)obj;
        return this.priority() == that.priority() && this.identity().equals(that.identity());
    }

    public int hashCode() {
        return Objects.hash(this.priority(), this.identity());
    }

    public String toString() {
        return "Hooklet{ priority: " + this.priority() + ", identity: " + this.identity() + " }";
    }
}

