/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.openhft.chronicle.core.io.LimitedInputStream;

public final class Wget {
    private final ConnectionProvider connectionProvider;
    private final CharsetDetector charsetDetector;
    private final long maxResponseBytes;
    private static final int MAX_URL_LENGTH = 2048;

    private Wget(ConnectionProvider cp, CharsetDetector cd, long maxBytes) {
        this.connectionProvider = cp;
        this.charsetDetector = cd;
        this.maxResponseBytes = maxBytes;
    }

    public static void url(String url, StringBuilder sb) throws IOException {
        if (url.length() > 2048) {
            throw new IllegalArgumentException("URL too long (" + url.length() + ")");
        }
        new Builder().build().fetch(url, sb);
    }

    public void fetch(String url, Appendable out) throws IOException {
        Objects.requireNonNull(out, "out");
        URL u = new URL(url);
        String scheme = u.getProtocol();
        if (!"http".equals(scheme) && !"https".equals(scheme)) {
            throw new MalformedURLException("Only http/https allowed, not " + scheme);
        }
        try (InputStream raw = this.connectionProvider.open(u);
             LimitedInputStream limited = new LimitedInputStream(raw, this.maxResponseBytes);){
            int ch;
            Charset cs = this.charsetDetector.detect(raw, null);
            if (cs == null) {
                cs = StandardCharsets.UTF_8;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)limited, cs));
            while ((ch = ((Reader)reader).read()) != -1) {
                out.append((char)ch);
            }
        }
    }

    public static final class Builder {
        private static final ConnectionProvider DEFAULT_PROVIDER = URL::openStream;
        private ConnectionProvider connectionProvider = DEFAULT_PROVIDER;
        private CharsetDetector charsetDetector = (in, ct) -> StandardCharsets.UTF_8;
        private int connectTimeoutMs = 10000;
        private int readTimeoutMs = 10000;
        private long maxResponseBytes = 0xA00000L;

        public Builder connectionProvider(ConnectionProvider p) {
            this.connectionProvider = Objects.requireNonNull(p);
            return this;
        }

        public Builder charsetDetector(CharsetDetector d) {
            this.charsetDetector = Objects.requireNonNull(d);
            return this;
        }

        public Builder connectTimeoutMs(int v) {
            this.connectTimeoutMs = v;
            return this;
        }

        public Builder readTimeoutMs(int v) {
            this.readTimeoutMs = v;
            return this;
        }

        public Builder maxResponseBytes(long v) {
            if (v < 0L) {
                throw new IllegalArgumentException("maxResponseBytes must be >= 0");
            }
            this.maxResponseBytes = v;
            return this;
        }

        public Wget build() {
            ConnectionProvider cp = this.connectionProvider;
            if (cp == DEFAULT_PROVIDER) {
                int ct = this.connectTimeoutMs;
                int rt = this.readTimeoutMs;
                cp = url -> {
                    URLConnection conn = url.openConnection();
                    conn.setConnectTimeout(ct);
                    conn.setReadTimeout(rt);
                    if (conn instanceof HttpURLConnection) {
                        ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
                    }
                    return conn.getInputStream();
                };
            }
            return new Wget(cp, this.charsetDetector, this.maxResponseBytes);
        }
    }

    @FunctionalInterface
    public static interface CharsetDetector {
        public Charset detect(InputStream var1, String var2);
    }

    @FunctionalInterface
    public static interface ConnectionProvider {
        public InputStream open(URL var1) throws IOException;
    }
}

