/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class LimitedInputStream
extends FilterInputStream {
    private long remainingBytes;

    LimitedInputStream(InputStream in, long maxBytes) {
        super(Objects.requireNonNull(in, "in"));
        if (maxBytes < 0L) {
            throw new IllegalArgumentException("maxBytes must be >= 0");
        }
        this.remainingBytes = maxBytes;
    }

    @Override
    public int read() throws IOException {
        if (this.remainingBytes == 0L) {
            int b = super.read();
            return b == -1 ? -1 : LimitedInputStream.throwExceeded();
        }
        int b = super.read();
        if (b != -1) {
            --this.remainingBytes;
        }
        return b;
    }

    @Override
    public int read(byte @NotNull [] buf, int off, int len) throws IOException {
        Objects.requireNonNull(buf, "buffer");
        if (off < 0 || len < 0 || len > buf.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.remainingBytes == 0L) {
            int n = super.read(buf, off, 1);
            return n == -1 ? -1 : LimitedInputStream.throwExceeded();
        }
        int allowed = (int)Math.min((long)len, this.remainingBytes);
        int n = super.read(buf, off, allowed);
        if (n != -1) {
            this.remainingBytes -= (long)n;
        }
        return n;
    }

    private static int throwExceeded() throws IOException {
        throw new IOException("Size limit exceeded");
    }
}

