/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.openhft.chronicle.core.internal.ClassUtil;
import org.jetbrains.annotations.NotNull;

public final class CompilerUtils {
    private static final Method DEFINE_CLASS_METHOD;

    private CompilerUtils() {
    }

    public static Class<?> defineClass(@NotNull ClassLoader classLoader, @NotNull String className, byte @NotNull [] bytes) {
        try {
            return (Class)DEFINE_CLASS_METHOD.invoke((Object)classLoader, className, bytes, 0, bytes.length);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e.getCause());
        }
    }

    static {
        try {
            DEFINE_CLASS_METHOD = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            ClassUtil.setAccessible(DEFINE_CLASS_METHOD);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

