/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.internal.CloseableUtils;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.SingleThreadedChecked;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;

public abstract class AbstractCloseable
implements ReferenceOwner,
ManagedCloseable,
SingleThreadedChecked {
    protected static final boolean DISABLE_DISCARD_WARNING = Jvm.getBoolean("disable.discard.warning", true);
    protected static final long WARN_NS = (long)(Jvm.getDouble("closeable.warn.secs", 0.02) * 1.0E9);
    private static final long CLOSED_OFFSET;
    private static final int STATE_NOT_CLOSED = 0;
    private static final int STATE_CLOSING = -1;
    private static final int STATE_CLOSED = 1;
    private final transient StackTrace createdHere;
    @UsedViaReflection
    private final transient Finalizer finalizer = DISABLE_DISCARD_WARNING ? null : new Finalizer();
    protected volatile transient StackTrace closedHere;
    private volatile transient int closed = 0;
    private volatile transient Thread usedByThread;
    private volatile transient StackTrace usedByThreadHere;
    private transient boolean singleThreadedCheckDisabled;
    private int referenceId;

    protected AbstractCloseable() {
        this.createdHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass().getName() + " created here") : null;
        CloseableUtils.add(this);
    }

    public static void enableCloseableTracing() {
        CloseableUtils.enableCloseableTracing();
    }

    public static void disableCloseableTracing() {
        CloseableUtils.disableCloseableTracing();
    }

    public static void gcAndWaitForCloseablesToClose() {
        CloseableUtils.gcAndWaitForCloseablesToClose();
    }

    public static boolean waitForCloseablesToClose(long millis) {
        return CloseableUtils.waitForCloseablesToClose(millis);
    }

    public static void assertCloseablesClosed() {
        CloseableUtils.assertCloseablesClosed();
    }

    public static void unmonitor(Closeable closeable) {
        CloseableUtils.unmonitor(closeable);
    }

    @Override
    public int referenceId() {
        if (this.referenceId == 0) {
            this.referenceId = IOTools.counter(this.getClass()).incrementAndGet();
        }
        return this.referenceId;
    }

    @Override
    public StackTrace createdHere() {
        return this.createdHere;
    }

    @Override
    public final void close() {
        this.assertCloseable();
        if (!UnsafeMemory.INSTANCE.compareAndSwapInt(this, CLOSED_OFFSET, 0, -1)) {
            if (this.shouldWaitForClosed() && this.isInUserThread()) {
                this.waitForClosed();
            }
            return;
        }
        StackTrace stackTrace = this.closedHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass().getName() + " closed here") : null;
        if (BackgroundResourceReleaser.BG_RELEASER && this.shouldPerformCloseInBackground()) {
            BackgroundResourceReleaser.release(this);
            return;
        }
        long start = System.nanoTime();
        this.callPerformClose();
        long time = System.nanoTime() - start;
        if (time >= WARN_NS && !BackgroundResourceReleaser.isOnBackgroundResourceReleaserThread()) {
            Jvm.perf().on(this.getClass(), "Took " + time / 1000000L + " ms to performClose");
        }
    }

    protected void assertCloseable() {
    }

    protected boolean isInUserThread() {
        return Thread.currentThread().getName().indexOf(126) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForClosed() {
        boolean interrupted = false;
        try {
            long start = System.currentTimeMillis();
            while (this.closed != 1) {
                if (System.currentTimeMillis() > start + 2500L) {
                    Jvm.warn().on(this.getClass(), "Aborting close()ing object " + this.referenceId + " after " + (double)(System.currentTimeMillis() - start) / 1000.0 + " secs", (Throwable)new StackTrace("waiting here", this.closedHere));
                    break;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void throwExceptionIfClosed() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        if (this.isClosed()) {
            this.throwClosed();
        }
        this.threadSafetyCheck(true);
    }

    private void throwClosed() throws ClosedIllegalStateException {
        throw new ClosedIllegalStateException(this.getClass().getName() + " closed for " + Thread.currentThread().getName(), this.closedHere);
    }

    public void throwExceptionIfClosedInSetter() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        if (this.isClosed()) {
            this.throwClosed();
        }
        this.threadSafetyCheck(false);
    }

    @Override
    public void warnAndCloseIfNotClosed() {
        if (!this.isClosing()) {
            if (Jvm.isResourceTracing() && !DISABLE_DISCARD_WARNING) {
                ExceptionHandler warn = Jvm.getBoolean("warnAndCloseIfNotClosed") ? Jvm.warn() : Slf4jExceptionHandler.WARN;
                warn.on(this.getClass(), "Discarded without closing", (Throwable)new IllegalStateException(this.createdHere));
            }
            this.close();
        }
    }

    protected abstract void performClose();

    void callPerformClose() {
        try {
            this.performClose();
        }
        catch (Throwable t) {
            Jvm.warn().on(this.getClass(), "Error occurred in close method", t);
        }
        finally {
            this.closed = 1;
        }
    }

    @Override
    public boolean isClosing() {
        return this.closed != 0;
    }

    @Override
    public boolean isClosed() {
        return this.closed == 1;
    }

    protected boolean shouldPerformCloseInBackground() {
        return false;
    }

    protected boolean shouldWaitForClosed() {
        return false;
    }

    protected void threadSafetyCheck(boolean isUsed) throws ThreadingIllegalStateException {
        if (DISABLE_SINGLE_THREADED_CHECK || this.singleThreadedCheckDisabled) {
            return;
        }
        this.threadSafetyCheck0(isUsed);
    }

    private void threadSafetyCheck0(boolean isUsed) throws ThreadingIllegalStateException {
        if (this.usedByThread == null && !isUsed) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        if (this.usedByThread == null) {
            this.usedByThread = currentThread;
            if (Jvm.isResourceTracing()) {
                this.usedByThreadHere = new StackTrace(this.getClass().getName() + " used here");
            }
        } else if (this.usedByThread != currentThread) {
            if (this.usedByThread.isAlive()) {
                throw new ThreadingIllegalStateException(this.getClass().getName() + " component which is not thread safe used by " + this.usedByThread + " and " + currentThread, this.usedByThreadHere);
            }
            this.usedByThread = currentThread;
        }
    }

    @Override
    public void singleThreadedCheckReset() {
        this.usedByThread = null;
        this.usedByThreadHere = null;
    }

    public String toString() {
        return this.referenceName();
    }

    protected boolean singleThreadedCheckDisabled() {
        return this.singleThreadedCheckDisabled;
    }

    @Override
    public void singleThreadedCheckDisabled(boolean singleThreadedCheckDisabled) {
        this.singleThreadedCheckDisabled = singleThreadedCheckDisabled;
        if (singleThreadedCheckDisabled) {
            this.singleThreadedCheckReset();
        }
    }

    static {
        if (Jvm.isResourceTracing()) {
            AbstractCloseable.enableCloseableTracing();
        }
        CLOSED_OFFSET = UnsafeMemory.unsafeObjectFieldOffset(Jvm.getField(AbstractCloseable.class, "closed"));
    }

    class Finalizer {
        Finalizer() {
        }

        protected void finalize() throws Throwable {
            AbstractCloseable.this.warnAndCloseIfNotClosed();
            super.finalize();
        }
    }
}

