/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;
import org.jetbrains.annotations.NotNull;

public class ThreadDump {
    public static final String IGNORE_THREAD_IF_IN_NAME = "~";
    static final Map<Thread, StackTrace> THREAD_STACK_TRACE_MAP = new WeakIdentityHashMap<Thread, StackTrace>();
    @NotNull
    final transient Set<Thread> threads;
    final Set<String> ignored = new HashSet<String>();

    public ThreadDump() {
        this.threads = new HashSet<Thread>(Arrays.asList(this.getAllThreadsInGroup()));
        this.ignored.add("Time-limited test");
        this.ignored.add("Attach Listener");
        this.ignored.add("process reaper");
        this.ignored.add("junit-jupiter-timeout-watcher");
    }

    public static void add(Thread t, StackTrace stackTrace) {
        if (Jvm.isResourceTracing()) {
            THREAD_STACK_TRACE_MAP.put(t, stackTrace);
        }
    }

    public static StackTrace createdHereFor(Thread thread) {
        return THREAD_STACK_TRACE_MAP.get(thread);
    }

    private static boolean startsWith(String str, String ... strs) {
        for (String s : strs) {
            if (!str.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public void ignore(String threadName) {
        this.ignored.add(threadName);
    }

    public void assertNoNewThreads() {
        this.assertNoNewThreads(0, TimeUnit.NANOSECONDS);
    }

    public void assertNoNewThreads(int delay, @NotNull TimeUnit delayUnit) {
        int last = 7;
        long delayMillis = (delayUnit.toMillis(delay) + (long)last - 1L) / (long)last;
        for (int i = 1; i <= last; ++i) {
            Thread.yield();
            Thread[] group = this.getAllThreadsInGroup();
            ArrayList<Thread> extra = i == last ? new ArrayList<Thread>() : null;
            boolean ok = true;
            for (Thread t : group) {
                if (t == null || !t.isAlive() || this.threads.contains(t) || !this.isExtra(t.getName())) continue;
                ok = false;
                if (i != last) break;
                extra.add(t);
            }
            if (ok) {
                return;
            }
            if (i == last) {
                if (extra.isEmpty()) break;
                AssertionError assertionError = new AssertionError((Object)("Threads still running " + extra));
                for (Thread thread : extra) {
                    this.addThreadErrorDetails(assertionError, thread);
                }
                throw assertionError;
            }
            Jvm.pause(delayMillis + (1L << i));
        }
    }

    private Thread[] getAllThreadsInGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        int threadCountEstimate = threadGroup.activeCount();
        Thread[] threads = new Thread[threadCountEstimate + 8];
        threadGroup.enumerate(threads);
        return threads;
    }

    private boolean isExtra(String name) {
        if (name.contains(IGNORE_THREAD_IF_IN_NAME)) {
            return false;
        }
        if (this.ignored.contains(name)) {
            return false;
        }
        if (ThreadDump.startsWith(name, "RMI ", "VM JFR ", "JFR ", "JMX ", "ForkJoinPool.commonPool-worker-", "JVMCI")) {
            return false;
        }
        return !name.startsWith("HttpClient-") || !name.endsWith("-SelectorManager");
    }

    private void addThreadErrorDetails(AssertionError assertionError, Thread thread) {
        StackTrace stackTrace0 = ThreadDump.createdHereFor(thread);
        StackTrace st = new StackTrace(thread.toString(), stackTrace0);
        StackTraceElement[] stackTrace = thread.getStackTrace();
        st.setStackTrace(stackTrace);
        ((Throwable)((Object)assertionError)).addSuppressed(st);
    }
}

