/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;
import org.jetbrains.annotations.Nullable;

public final class CloseableUtils {
    private static final AtomicReference<Set<Closeable>> CLOSEABLES = new AtomicReference();

    private CloseableUtils() {
    }

    public static void add(Closeable closeable) {
        Set<Closeable> set = CLOSEABLES.get();
        if (set != null) {
            set.add(closeable);
        }
    }

    public static void enableCloseableTracing() {
        CLOSEABLES.set(Collections.synchronizedSet(Collections.newSetFromMap(new WeakIdentityHashMap())));
    }

    public static void disableCloseableTracing() {
        CLOSEABLES.set(null);
    }

    public static void gcAndWaitForCloseablesToClose() {
        CleaningThread.performCleanup(Thread.currentThread());
        final LinkedBlockingQueue q = new LinkedBlockingQueue();
        new Object(){

            protected void finalize() throws Throwable {
                super.finalize();
                q.add("finalized");
            }
        };
        System.gc();
        AbstractCloseable.waitForCloseablesToClose(1000L);
        try {
            if (q.poll(5L, TimeUnit.SECONDS) == null) {
                throw new AssertionError((Object)"Timed out waiting for the Finalizer");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForCloseablesToClose(long millis) {
        Set<Closeable> traceSet = CLOSEABLES.get();
        if (traceSet == null) {
            return true;
        }
        if (Thread.interrupted()) {
            System.err.println("Interrupted in waitForCloseablesToClose!");
        }
        long end = System.currentTimeMillis() + millis;
        BackgroundResourceReleaser.releasePendingResources();
        block5: do {
            CleaningThreadLocal.cleanupNonCleaningThreads();
            Set<Closeable> set = traceSet;
            synchronized (set) {
                for (Closeable key : traceSet) {
                    try {
                        if (key instanceof AbstractCloseable) {
                            ((AbstractCloseable)key).singleThreadedCheckDisabled(true);
                        }
                        if (!(key instanceof ReferenceCountedTracer)) continue;
                        ((ReferenceCountedTracer)((Object)key)).throwExceptionIfNotReleased();
                    }
                    catch (IllegalStateException e) {
                        Jvm.pause(1L);
                        continue block5;
                    }
                }
            }
            Jvm.pause(1L);
            return true;
        } while (System.currentTimeMillis() < end);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertCloseablesClosed() {
        Set<Closeable> traceSet = CLOSEABLES.get();
        if (traceSet == null) {
            Jvm.warn().on(AbstractCloseable.class, "closable tracing disabled");
            return;
        }
        if (Thread.interrupted()) {
            System.err.println("Interrupted in assertCloseablesClosed!");
        }
        BackgroundResourceReleaser.releasePendingResources();
        AssertionError openFiles = new AssertionError((Object)"Closeables still open");
        Set<Closeable> set = traceSet;
        synchronized (set) {
            Set<Closeable> traceSet2 = Collections.newSetFromMap(new IdentityHashMap());
            if (CloseableUtils.waitForTraceSet(traceSet, traceSet2)) {
                return;
            }
            CloseableUtils.captureTheUnclosed(openFiles, traceSet2);
        }
        if (((Throwable)((Object)openFiles)).getSuppressed().length > 0) {
            throw openFiles;
        }
    }

    private static boolean waitForTraceSet(Set<Closeable> traceSet, Set<Closeable> traceSet2) {
        traceSet.removeIf(o -> o == null || o.isClosing());
        Set<Closeable> nested = Collections.newSetFromMap(new IdentityHashMap());
        for (Closeable key : traceSet) {
            CloseableUtils.addNested(nested, key, 1);
        }
        traceSet2.addAll(traceSet);
        traceSet2.removeAll(nested);
        for (int i = 0; i < 250; ++i) {
            if (traceSet2.stream().allMatch(QueryCloseable::isClosing)) {
                return true;
            }
            Jvm.pause(1L);
        }
        return false;
    }

    private static void captureTheUnclosed(AssertionError openFiles, Set<Closeable> traceSet2) {
        for (Closeable key : traceSet2) {
            Throwable t = null;
            try {
                if (key instanceof ReferenceCountedTracer) {
                    ((ReferenceCountedTracer)((Object)key)).throwExceptionIfNotReleased();
                }
                if (key instanceof ManagedCloseable) {
                    t = ((ManagedCloseable)key).createdHere();
                }
            }
            catch (IllegalStateException e) {
                t = e;
            }
            IllegalStateException exception = new IllegalStateException("Not closed " + CloseableUtils.asString(key), t);
            if (key.isClosed()) continue;
            ((Throwable)((Object)openFiles)).addSuppressed(exception);
            key.close();
        }
    }

    private static void addNested(Set<Closeable> nested, Closeable key, int depth) {
        if (key.isClosing()) {
            return;
        }
        HashSet<Field> fields = new HashSet<Field>();
        Class<?> keyClass = key.getClass();
        CloseableUtils.getCloseableFields(keyClass, fields);
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                Closeable o = (Closeable)field.get(key);
                if (o == null || !nested.add(o) || depth <= 1) continue;
                CloseableUtils.addNested(nested, o, depth - 1);
            }
            catch (IllegalAccessException e) {
                Jvm.warn().on(keyClass, e);
            }
        }
    }

    private static void getCloseableFields(Class<?> keyClass, Set<Field> fields) {
        if (keyClass == null || keyClass == Object.class) {
            return;
        }
        for (Field field : keyClass.getDeclaredFields()) {
            if (!Closeable.class.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        CloseableUtils.getCloseableFields(keyClass.getSuperclass(), fields);
    }

    public static void unmonitor(Closeable closeable) {
        Set<Closeable> set = CLOSEABLES.get();
        if (set != null) {
            set.remove(closeable);
        }
    }

    public static void closeQuietly(Object ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Object o : closeables) {
            CloseableUtils.closeQuietly(o);
        }
    }

    static void closeQuietly(@Nullable Object o) {
        if (o instanceof Collection) {
            Collection coll = (Collection)o;
            if (coll.isEmpty()) {
                return;
            }
            ArrayList list = new ArrayList(coll);
            list.forEach(Closeable::closeQuietly);
        } else if (o instanceof Object[]) {
            for (Object o2 : (Object[])o) {
                CloseableUtils.closeQuietly(o2);
            }
        } else if (o instanceof ServerSocketChannel) {
            try {
                ((ServerSocketChannel)o).close();
            }
            catch (IOException e) {
                if (!"No such file or directory".equals(e.getMessage())) {
                    CloseableUtils.logErrorOnClose(e);
                }
            }
            catch (Throwable e) {
                CloseableUtils.logErrorOnClose(e);
            }
        } else if (o instanceof AutoCloseable) {
            try {
                ((AutoCloseable)o).close();
            }
            catch (Throwable e) {
                CloseableUtils.logErrorOnClose(e);
            }
        } else if (o instanceof Reference) {
            CloseableUtils.closeQuietly(((Reference)o).get());
        } else if (o instanceof HttpURLConnection) {
            HttpURLConnection connection = (HttpURLConnection)o;
            connection.disconnect();
        }
    }

    static void logErrorOnClose(Throwable e) {
        Jvm.warn().on(Closeable.class, "Error occurred closing resources", e);
    }

    public static String asString(Object id) {
        String s;
        if (id == ReferenceOwner.INIT) {
            return "INIT";
        }
        String string = s = id instanceof ReferenceOwner ? ((ReferenceOwner)id).referenceName() : id.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(id));
        if (id instanceof ReferenceCounted) {
            s = s + " refCount=" + ((ReferenceCounted)id).refCount();
        }
        try {
            if (id instanceof QueryCloseable) {
                s = s + " closed=" + ((QueryCloseable)id).isClosed();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return s;
    }
}

