/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PerformanceTuning {
    static final File TIMESTAMP = new File(OS.TMP, ".tuning." + OS.getUserName());

    private PerformanceTuning() {
    }

    public static void reportIssues() {
        List<String> issues = PerformanceTuning.issues();
        if (!issues.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("OS configuration is non-optimal for high performance:").append("\n");
            issues.forEach(issue -> msg.append((String)issue).append("\n"));
            msg.append("If you would like assistance, please contact sales@chroncle.software.");
            Jvm.warn().on(PerformanceTuning.class, msg.toString());
        }
    }

    @NotNull
    public static List<String> issues() {
        if (!OS.isLinux()) {
            return Collections.emptyList();
        }
        long lastModified = TIMESTAMP.lastModified();
        long age = System.currentTimeMillis() - lastModified;
        if (age < TimeUnit.MINUTES.toMillis(30L)) {
            return Collections.emptyList();
        }
        try {
            Jvm.debug().on(PerformanceTuning.class, lastModified == 0L ? "No " + TIMESTAMP + " file" : "Tuning Timestamp " + (double)age / 1000.0 + " seconds.");
            FileOutputStream fos = new FileOutputStream(TIMESTAMP);
            Throwable throwable = null;
            if (fos != null) {
                if (throwable != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    fos.close();
                }
            }
        }
        catch (IOException ioe) {
            Jvm.debug().on(PerformanceTuning.class, ioe);
        }
        LinkedList<String> issues = new LinkedList<String>();
        issues.add(PerformanceTuning.checkScalingGovernors());
        Set<String> kernelCmdLineParams = PerformanceTuning.kernelCommandLineParameters();
        if (!kernelCmdLineParams.isEmpty()) {
            issues.addAll(Arrays.asList(PerformanceTuning.checkCStates(kernelCmdLineParams), PerformanceTuning.checkSpectreMitigation(kernelCmdLineParams), PerformanceTuning.checkSoftlockup(kernelCmdLineParams), PerformanceTuning.checkAudit(kernelCmdLineParams), PerformanceTuning.checkPageTableIsolation(kernelCmdLineParams), PerformanceTuning.checkMCE(kernelCmdLineParams)));
        }
        return issues.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static String checkScalingGovernors() {
        return PerformanceTuning.checkScalingGovernors(Paths.get("/sys/devices/system/cpu/", new String[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static String checkScalingGovernors(Path sysDevicesSystemCpu) {
        try (Stream<Path> pathsToCpus = Files.list(sysDevicesSystemCpu);){
            List cpusWithSlowGovernors = pathsToCpus.filter(pathToCpu -> pathToCpu.getFileName().toString().startsWith("cpu")).filter(pathToCpu -> !pathToCpu.toString().endsWith("idle")).filter(pathToCpu -> {
                Path pathToGovernor = pathToCpu.resolve("cpufreq/scaling_governor");
                try {
                    String scalingGovernor = PerformanceTuning.readFirstLine(pathToGovernor);
                    if (scalingGovernor == null) {
                        throw new IllegalStateException("Failed to read 'scaling_governor' value for " + pathToCpu.getFileName());
                    }
                    return !"performance".equals(scalingGovernor);
                }
                catch (IOException e) {
                    Jvm.rethrow(e);
                    return false;
                }
            }).map(Path::getFileName).map(Path::toString).sorted().collect(Collectors.toList());
            if (cpusWithSlowGovernors.isEmpty()) {
                String string2 = null;
                return string2;
            }
            String string = cpusWithSlowGovernors.stream().collect(Collectors.joining(", ", "Following CPUs have non-performant scaling governor setting: ", "."));
            return string;
        }
        catch (IOException e) {
            Jvm.debug().on(PerformanceTuning.class, "Unable to read " + sysDevicesSystemCpu + "/cpu*/cpufreq/scaling_governor", e);
            return null;
        }
    }

    @Nullable
    static String checkSpectreMitigation(Set<String> kernelCmdLineParams) {
        if (!(kernelCmdLineParams.contains("nospectre_v2") || kernelCmdLineParams.contains("spectre_v2=off") || kernelCmdLineParams.contains("mitigations=off"))) {
            return "Spectre variant 2 mitigation is enabled";
        }
        return null;
    }

    @Nullable
    static String checkCStates(Set<String> kernelCmdLineParams) {
        if (!kernelCmdLineParams.containsAll(Arrays.asList("processor.max_cstate=1", "intel_idle.max_cstate=0", "idle=poll"))) {
            return "C-States are enabled";
        }
        return null;
    }

    @Nullable
    static String checkMCE(Set<String> kernelCmdLineParams) {
        if (!kernelCmdLineParams.contains("mce=ignore_ce")) {
            return "Machine Check Exception configuration is non-optimal";
        }
        return null;
    }

    @Nullable
    static String checkSoftlockup(Set<String> kernelCmdLineParams) {
        if (!kernelCmdLineParams.contains("nosoftlockup")) {
            return "Soft-lockup detector is enabled";
        }
        return null;
    }

    @Nullable
    static String checkAudit(Set<String> kernelCmdLineParams) {
        if (!kernelCmdLineParams.contains("audit=0") && !kernelCmdLineParams.contains("audit=off")) {
            return "Audit sub-system is enabled";
        }
        return null;
    }

    @Nullable
    static String checkPageTableIsolation(Set<String> kernelCmdLineParams) {
        if (!kernelCmdLineParams.contains("nopti") && !kernelCmdLineParams.contains("pti=off")) {
            return "Page Table Isolation is enabled";
        }
        return null;
    }

    @NotNull
    static Set<String> kernelCommandLineParameters() {
        return PerformanceTuning.kernelCommandLineParameters(Paths.get("/proc/cmdline", new String[0]));
    }

    @NotNull
    static Set<String> kernelCommandLineParameters(Path procCmdlinePath) {
        try {
            String procCmdline = PerformanceTuning.readFirstLine(procCmdlinePath);
            if (procCmdline != null) {
                return PerformanceTuning.parseKernelCommandLineParameters(procCmdline);
            }
        }
        catch (IOException e) {
            Jvm.debug().on(PerformanceTuning.class, "Failed to read " + procCmdlinePath, e);
        }
        return Collections.emptySet();
    }

    @NotNull
    static Set<String> parseKernelCommandLineParameters(String procCmdline) {
        return new HashSet<String>(Arrays.asList(procCmdline.split(" ")));
    }

    static String readFirstLine(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String string = reader.readLine();
            return string;
        }
    }
}

