/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public enum GenericReflection {


    public static Set<Type> getMethodReturnTypes(Type type) {
        LinkedHashSet<Type> types = new LinkedHashSet<Type>();
        if (type instanceof Class || type instanceof ParameterizedType) {
            for (Method method : GenericReflection.erase(type).getMethods()) {
                types.add(GenericReflection.getReturnType(method, type));
            }
            return types;
        }
        throw new UnsupportedOperationException();
    }

    public static Type getReturnType(Method method, Type type) {
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof Class) {
            return genericReturnType;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        Optional<Type> extendsType = Stream.of(Stream.of(GenericReflection.getGenericSuperclass(type)), Stream.of(GenericReflection.getGenericInterfaces(type))).flatMap(s -> s).filter(t -> declaringClass.equals(GenericReflection.erase(t))).findFirst();
        TypeVariable<Class<?>>[] typeParameters = declaringClass.getTypeParameters();
        if (extendsType.isPresent() && extendsType.get() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)extendsType.get();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (!typeParameters[i].equals(genericReturnType)) continue;
                return actualTypeArguments[i];
            }
        }
        return method.getGenericReturnType();
    }

    static Type[] getGenericInterfaces(Type forClass) {
        if (forClass instanceof Class) {
            return ((Class)forClass).getGenericInterfaces();
        }
        if (forClass instanceof ParameterizedType) {
            return new Type[]{forClass};
        }
        throw new UnsupportedOperationException();
    }

    static Type getGenericSuperclass(Type forClass) {
        if (forClass instanceof Class) {
            return ((Class)forClass).getGenericSuperclass();
        }
        if (forClass instanceof ParameterizedType) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public static Class<?> erase(Type type) {
        return type instanceof ParameterizedType ? GenericReflection.erase(((ParameterizedType)type).getRawType()) : (Class<?>)type;
    }
}

