/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.DualReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.TracingReferenceCounted;
import net.openhft.chronicle.core.io.VanillaReferenceCounted;
import org.jetbrains.annotations.NotNull;

public interface ReferenceCountedTracer
extends ReferenceCounted {
    @NotNull
    public static ReferenceCountedTracer onReleased(Runnable onRelease, String uniqueId, Class type) {
        return Jvm.isResourceTracing() ? new DualReferenceCounted(new TracingReferenceCounted(onRelease, uniqueId, type), new VanillaReferenceCounted(() -> {}, type)) : new VanillaReferenceCounted(onRelease, type);
    }

    default public void throwExceptionIfReleased() throws ClosedIllegalStateException {
        if (this.refCount() <= 0) {
            throw new ClosedIllegalStateException("Released");
        }
    }

    public void warnAndReleaseIfNotReleased() throws ClosedIllegalStateException;

    public void throwExceptionIfNotReleased() throws IllegalStateException;

    public StackTrace createdHere();
}

