/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.announcer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.announcer.Announcer;
import net.openhft.chronicle.core.pom.PomProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum InternalAnnouncer {

    private static final Logger LOGGER = LoggerFactory.getLogger(Announcer.class);
    private static final boolean DISABLE_ANNOUNCEMENT = Optional.ofNullable(System.getProperty("chronicle.announcer.disable")).filter("true"::equals).isPresent();
    private static final Consumer<String> LINE_PRINTER = DISABLE_ANNOUNCEMENT ? s -> {} : arg_0 -> ((Logger)LOGGER).info(arg_0);
    private static final AtomicBoolean JVM_ANNOUNCED = new AtomicBoolean();
    private static final Map<String, Set<String>> ANNOUNCED_GROUP_IDS = new ConcurrentHashMap<String, Set<String>>();

    public static void announce(@NotNull String groupId, @NotNull String artifactId, @NotNull Map<String, String> properties) {
        if (JVM_ANNOUNCED.compareAndSet(false, true)) {
            InternalAnnouncer.announceJvm();
        }
        if (InternalAnnouncer.alwaysAnnounce(properties)) {
            InternalAnnouncer.announceArtifact(groupId, artifactId, properties);
        } else {
            Set announcedArtifacts = ANNOUNCED_GROUP_IDS.computeIfAbsent(groupId, unused -> Collections.newSetFromMap(new ConcurrentHashMap()));
            if (announcedArtifacts.add(artifactId)) {
                InternalAnnouncer.announceArtifact(groupId, artifactId, properties);
            }
        }
    }

    private static void announceJvm() {
        LINE_PRINTER.accept(String.format("Running under %s %s with %d processors reported.", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"), Runtime.getRuntime().availableProcessors()));
    }

    private static void announceArtifact(@NotNull String groupId, @NotNull String artifactId, @NotNull Map<String, String> properties) {
        LinkedHashMap<String, String> propertiesCopy = new LinkedHashMap<String, String>(properties);
        String logo = (String)propertiesCopy.remove("logo");
        if (logo != null) {
            LINE_PRINTER.accept(logo);
        }
        String version = PomProperties.version(groupId, artifactId);
        String artifactInfo = String.format("Process id: %d :: %s (%s)", Jvm.getProcessId(), InternalAnnouncer.pretty(artifactId), version);
        LINE_PRINTER.accept(artifactInfo);
        int indent = propertiesCopy.keySet().stream().mapToInt(String::length).max().orElse(0);
        String formatString = "%-" + indent + "s: %s";
        propertiesCopy.entrySet().stream().map(e -> String.format(formatString, e.getKey(), e.getValue())).forEach(LINE_PRINTER);
    }

    private static String pretty(@NotNull String artifactId) {
        StringBuilder sb = new StringBuilder();
        boolean makeUpperCase = true;
        for (char c : artifactId.toCharArray()) {
            if (makeUpperCase) {
                sb.append(Character.toUpperCase(c));
                makeUpperCase = false;
                continue;
            }
            if ('-' == c) {
                makeUpperCase = true;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean alwaysAnnounce(@NotNull Map<String, String> properties) {
        if (properties.isEmpty()) {
            return false;
        }
        if (properties.size() == 1) {
            return properties.containsKey("logo");
        }
        return true;
    }
}

