/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.io.Closeable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.threads.VanillaEventHandler;
import org.jetbrains.annotations.NotNull;

public class Timer {
    @NotNull
    private final EventLoop eventLoop;

    public Timer(@NotNull EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public void scheduleAtFixedRate(@NotNull VanillaEventHandler eventHandler, long initialDelayMs, long periodMs) {
        this.eventLoop.addHandler(new ScheduledEventHandler(eventHandler, initialDelayMs, periodMs));
    }

    public void schedule(@NotNull Runnable eventHandler, long initialDelayMs) {
        this.eventLoop.addHandler(new ScheduledEventHandler(() -> {
            eventHandler.run();
            throw new InvalidEventHandlerException("just runs once");
        }, initialDelayMs, 0L));
    }

    private static class ScheduledEventHandler
    implements EventHandler,
    Closeable {
        @NotNull
        private final VanillaEventHandler eventHandler;
        private final long initialDelayMs;
        private final long periodMs;
        private volatile transient boolean closed;
        private boolean isFirstTime = true;
        private long lastTimeRan = System.currentTimeMillis();

        private ScheduledEventHandler(@NotNull VanillaEventHandler eventHandler, long initialDelayMs, long periodMs) {
            this.initialDelayMs = initialDelayMs;
            this.periodMs = periodMs;
            this.eventHandler = eventHandler;
        }

        @Override
        public boolean action() throws InvalidEventHandlerException {
            if (this.closed) {
                throw InvalidEventHandlerException.reusable();
            }
            long currentTime = System.currentTimeMillis();
            if (this.lastTimeRan + this.waitTimeMs() > currentTime) {
                return false;
            }
            this.isFirstTime = false;
            this.lastTimeRan = currentTime;
            try {
                return this.eventHandler.action();
            }
            catch (RuntimeException e) {
                Jvm.warn().on(this.getClass(), "Unexpected runtime exception", e);
                return false;
            }
        }

        private long waitTimeMs() {
            if (!this.isFirstTime) {
                return this.periodMs;
            }
            return this.initialDelayMs;
        }

        @Override
        @NotNull
        public HandlerPriority priority() {
            return HandlerPriority.TIMER;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        public String toString() {
            return "ScheduledEventHandler<" + this.eventHandler + '>';
        }
    }
}

