/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.cleaner.impl.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.cleaner.spi.ByteBufferCleanerService;
import sun.nio.ch.DirectBuffer;

public final class ReflectionBasedByteBufferCleanerService
implements ByteBufferCleanerService {
    private static final String JDK8_CLEANER_CLASS_NAME = "sun.misc.Cleaner";
    private static final String JDK9_CLEANER_CLASS_NAME = "jdk.internal.ref.Cleaner";
    private static final MethodHandle cleanerMethod;
    private static final MethodHandle cleanMethod;

    @Override
    public void clean(ByteBuffer buffer) {
        try {
            Object cleaner = cleanerMethod.invoke((DirectBuffer)((Object)buffer));
            cleanMethod.invoke(cleaner);
        }
        catch (Throwable throwable) {
            Jvm.rethrow(throwable);
        }
    }

    @Override
    public int impact() {
        return 1;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String cleanerClassname = Jvm.isJava9Plus() ? JDK9_CLEANER_CLASS_NAME : JDK8_CLEANER_CLASS_NAME;
        try {
            Class<?> cleanerClass = Class.forName(cleanerClassname);
            cleanerMethod = lookup.findVirtual(DirectBuffer.class, "cleaner", MethodType.methodType(cleanerClass));
            cleanMethod = lookup.findVirtual(cleanerClass, "clean", MethodType.methodType(Void.TYPE));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

