/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;

public class DualReferenceCounted
implements ReferenceCountedTracer {
    private final ReferenceCountedTracer a;
    private final ReferenceCountedTracer b;

    public DualReferenceCounted(ReferenceCountedTracer a, ReferenceCountedTracer b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public void warnAndReleaseIfNotReleased() {
        this.a.warnAndReleaseIfNotReleased();
    }

    @Override
    public void throwExceptionIfNotReleased() {
        this.a.throwExceptionIfNotReleased();
    }

    @Override
    public StackTrace createdHere() {
        return this.a.createdHere();
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) {
        return this.a.reservedBy(owner);
    }

    @Override
    public synchronized void reserve(ReferenceOwner id) throws IllegalStateException {
        this.a.reserve(id);
        this.b.reserve(id);
        if (this.a.refCount() != this.b.refCount()) {
            throw new AssertionError((Object)(this.a.refCount() + " != " + this.b.refCount()));
        }
    }

    @Override
    public synchronized boolean tryReserve(ReferenceOwner id) throws IllegalStateException {
        boolean aa = this.a.tryReserve(id);
        boolean bb = this.b.tryReserve(id);
        assert (aa == bb);
        if (this.a.refCount() != this.b.refCount()) {
            throw new AssertionError((Object)(this.a.refCount() + " != " + this.b.refCount()));
        }
        return aa;
    }

    @Override
    public synchronized void release(ReferenceOwner id) throws IllegalStateException {
        this.a.release(id);
        this.b.release(id);
        if (this.a.refCount() != this.b.refCount()) {
            throw new AssertionError((Object)(this.a.refCount() + " != " + this.b.refCount()));
        }
    }

    @Override
    public synchronized void releaseLast(ReferenceOwner id) throws IllegalStateException {
        this.a.releaseLast(id);
        this.b.releaseLast(id);
        if (this.a.refCount() != this.b.refCount()) {
            throw new AssertionError((Object)(this.a.refCount() + " != " + this.b.refCount()));
        }
    }

    @Override
    public synchronized int refCount() {
        if (this.a.refCount() != this.b.refCount()) {
            throw new AssertionError((Object)(this.a.refCount() + " != " + this.b.refCount()));
        }
        return this.a.refCount();
    }

    @Override
    public void throwExceptionIfReleased() throws IllegalStateException {
        this.a.throwExceptionIfReleased();
    }

    @Override
    public synchronized void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.a.reserveTransfer(from, to);
        this.b.reserveTransfer(from, to);
        if (this.a.refCount() != this.b.refCount()) {
            throw new AssertionError((Object)(this.a.refCount() + " != " + this.b.refCount()));
        }
    }

    @Override
    public int referenceId() {
        return this.a.referenceId();
    }

    @Override
    public String referenceName() {
        return this.a.referenceName();
    }
}

