/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.nio.BufferOverflowException;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;

public enum UnsafeText {

    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final String MIN_VALUE_STR = "-9223372036854775808";

    public static long appendFixed(long address, long num) {
        long div;
        if (num < 0L) {
            if (num > Long.MIN_VALUE) {
                UnsafeMemory.UNSAFE.putByte(address++, (byte)45);
                num = -num;
            } else {
                return UnsafeText.appendText(address, MIN_VALUE_STR);
            }
        }
        long start = address;
        do {
            div = num / 10L;
            long mod = num % 10L;
            UnsafeMemory.UNSAFE.putByte(address++, (byte)(48L + mod));
        } while ((num = div) > 0L);
        UnsafeText.reverseTheOrder(address, start);
        return address;
    }

    protected static void reverseTheOrder(long address, long start) {
        int end = (int)(address - start) - 1;
        for (int i = 0; i < end; ++i, --end) {
            long a1 = start + (long)i;
            long a2 = start + (long)end;
            byte b1 = UnsafeMemory.UNSAFE.getByte(a1);
            byte b2 = UnsafeMemory.UNSAFE.getByte(a2);
            UnsafeMemory.UNSAFE.putByte(a2, b1);
            UnsafeMemory.UNSAFE.putByte(a1, b2);
        }
    }

    public static long appendFixed(long address, double num, int digits) {
        long tens = Maths.tens(digits);
        double mag = num * (double)tens;
        if (Math.abs(mag) < 9.007199254740992E15) {
            long num2 = Math.round(mag);
            return UnsafeText.appendBase10d(address, num2, digits);
        }
        return UnsafeText.appendDouble(address, num);
    }

    public static long appendBase10d(long address, long num, int decimal) {
        long div;
        if (num < 0L) {
            if (num > Long.MIN_VALUE) {
                UnsafeMemory.UNSAFE.putByte(address++, (byte)45);
                num = -num;
            } else {
                throw new AssertionError();
            }
        }
        long start = address;
        do {
            div = num / 10L;
            long mod = num % 10L;
            UnsafeMemory.UNSAFE.putByte(address++, (byte)(48L + mod));
            if (--decimal != 0) continue;
            UnsafeMemory.UNSAFE.putByte(address++, (byte)46);
        } while ((num = div) > 0L || decimal >= 0);
        UnsafeText.reverseTheOrder(address, start);
        return address;
    }

    public static long appendDouble(long address, double d) throws BufferOverflowException, IllegalArgumentException {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            UnsafeMemory.UNSAFE.putByte(address++, (byte)45);
        }
        if (exp == 0 && mantissa == 0L) {
            UnsafeMemory.UNSAFE.putByte(address, (byte)48);
            UnsafeMemory.UNSAFE.putShort(address + 1L, (short)12334);
            return address += 3L;
        }
        if (exp == 2047) {
            return UnsafeText.appendText(address, mantissa == 0L ? "Infinity" : "NaN");
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                return UnsafeText.appendIntegerAndFraction(address, d, sign, mantissa, shift);
            }
            return UnsafeText.appendFraction(address, d, sign, mantissa, shift);
        }
        return UnsafeText.appendLargeNumber(address, mantissa, shift);
    }

    protected static long appendLargeNumber(long address, long mantissa, int shift) {
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        address = UnsafeText.appendFixed(address, val2);
        for (int i = 0; i < digits; ++i) {
            UnsafeMemory.UNSAFE.putByte(address++, (byte)48);
        }
        return address;
    }

    protected static long appendFraction(long address, double d, int sign, long mantissa, int shift) {
        UnsafeMemory.UNSAFE.putShort(address, (short)11824);
        address += 2L;
        mantissa <<= 6;
        mantissa += 32L;
        int precision = shift + 6;
        long value = 0L;
        int decimalPlaces = 0;
        for (long error = 32L; mantissa > error; error *= 5L) {
            while (mantissa > 0x1999999999999999L) {
                mantissa >>>= 1;
                error = error + 1L >>> 1;
                --precision;
            }
            mantissa *= 5L;
            if (--precision >= 64) {
                ++decimalPlaces;
                UnsafeMemory.UNSAFE.putByte(address++, (byte)48);
                continue;
            }
            long num = mantissa >>> precision;
            value = value * 10L + num;
            char c = (char)(48L + num);
            UnsafeMemory.UNSAFE.putByte(address++, (byte)c);
            mantissa -= num << precision;
            double parsedValue = UnsafeText.asDouble(value, 0, sign != 0, ++decimalPlaces);
            if (parsedValue != d) continue;
            break;
        }
        return address;
    }

    protected static long appendIntegerAndFraction(long address, double d, int sign, long mantissa, int shift) {
        long intValue = mantissa >> shift;
        address = UnsafeText.appendFixed(address, intValue);
        if ((mantissa -= intValue << shift) > 0L) {
            long num;
            UnsafeMemory.UNSAFE.putByte(address++, (byte)46);
            mantissa <<= 1;
            ++mantissa;
            int precision = shift + 1;
            long value = intValue;
            int decimalPlaces = 0;
            for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                num = (mantissa *= 5L) >> --precision;
                value = value * 10L + num;
                UnsafeMemory.UNSAFE.putByte(address++, (byte)(48L + num));
                double parsedValue = UnsafeText.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
        } else {
            UnsafeMemory.UNSAFE.putShort(address, (short)12334);
            address += 2L;
        }
        return address;
    }

    private static long appendText(long address, String s) {
        for (int i = 0; i < s.length(); ++i) {
            UnsafeMemory.UNSAFE.putByte(address++, (byte)s.charAt(i));
        }
        return address;
    }

    private static double asDouble(long value, int exp, boolean negative, int deci) {
        double d;
        int leading = 11;
        if (value >= 0x20000000000000L) {
            leading = Long.numberOfLeadingZeros(value) - 1;
        } else if (value >= 0x2000000000000L) {
            leading = 10;
        }
        int scale2 = 0;
        if (leading > 0) {
            scale2 = leading;
            value <<= scale2;
        }
        if (deci > 29) {
            d = (double)value / Math.pow(5.0, -deci);
        } else if (deci > 0) {
            long fives = Maths.fives(deci);
            long whole = value / fives;
            long rem = value % fives;
            d = (double)whole + (double)rem / (double)fives;
        } else if (deci < -29) {
            d = (double)value * Math.pow(5.0, -deci);
        } else if (deci < 0) {
            double fives = Maths.fives(-deci);
            d = (double)value * fives;
        } else {
            d = value;
        }
        double scalb = Math.scalb(d, exp - deci - scale2);
        return negative ? -scalb : scalb;
    }
}

