/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.core.util.ThrowingSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ObjectUtils {

    public static final Object[] NO_OBJECTS = new Object[0];
    static final Map<Class, Class> primMap = new LinkedHashMap<Class, Class>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Character.TYPE, Character.class);
            this.put(Short.TYPE, Short.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Float.TYPE, Float.class);
            this.put(Long.TYPE, Long.class);
            this.put(Double.TYPE, Double.class);
            this.put(Void.TYPE, Void.class);
        }
    };
    static final Map<Class, Object> DEFAULT_MAP = new HashMap<Class, Object>();
    static final ClassLocal<ThrowingFunction<String, Object, Exception>> PARSER_CL = ClassLocal.withInitial(new ConversionFunction());
    static final ClassLocal<Map<String, Enum>> CASE_IGNORE_LOOKUP = ClassLocal.withInitial(ObjectUtils::caseIgnoreLookup);
    static final ClassValue<Method> READ_RESOLVE = ClassLocal.withInitial(c -> {
        try {
            Method m = c.getDeclaredMethod("readResolve", new Class[0]);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException expected) {
            return null;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    });
    private static final Map<Class, Immutability> immutabilityMap = new ConcurrentHashMap<Class, Immutability>();
    private static final ClassLocal<Supplier> SUPPLIER_CLASS_LOCAL = ClassLocal.withInitial(c -> {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isPrimitive()) {
            throw new IllegalArgumentException("primitive: " + c.getName());
        }
        if (c.isInterface()) {
            throw new IllegalArgumentException("interface: " + c.getName());
        }
        if (Modifier.isAbstract(c.getModifiers())) {
            throw new IllegalArgumentException("abstract class: " + c.getName());
        }
        if (c.isEnum()) {
            throw new IllegalArgumentException("enum class: " + c.getName());
        }
        try {
            Constructor constructor = c.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return ThrowingSupplier.asSupplier(() -> constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            return () -> {
                try {
                    return OS.memory().allocateInstance(c);
                }
                catch (InstantiationException e1) {
                    throw Jvm.rethrow(e1);
                }
            };
        }
    });

    public static void immutabile(Class clazz, boolean isImmutable) {
        immutabilityMap.put(clazz, isImmutable ? Immutability.YES : Immutability.NO);
    }

    public static Immutability isImmutable(@NotNull Class clazz) {
        Immutability immutability = immutabilityMap.get(clazz);
        if (immutability == null) {
            return Comparable.class.isAssignableFrom(clazz) ? Immutability.MAYBE : Immutability.NO;
        }
        return immutability;
    }

    @NotNull
    public static boolean isTrue(CharSequence s) {
        return StringUtils.equalsCaseIgnore(s, "true") || StringUtils.equalsCaseIgnore(s, "y") || StringUtils.equalsCaseIgnore(s, "yes");
    }

    public static Class primToWrapper(Class eClass) {
        Class clazz0 = primMap.get(eClass);
        if (clazz0 != null) {
            eClass = clazz0;
        }
        return eClass;
    }

    @Nullable
    public static <E> E convertTo(@Nullable Class<E> eClass, @Nullable Object o) throws ClassCastException, IllegalArgumentException {
        return (E)(eClass == null || o == null || eClass.isInstance(o) ? o : ObjectUtils.convertTo0(eClass, o));
    }

    @NotNull
    private static Map<String, Enum> caseIgnoreLookup(@NotNull Class c) {
        TreeMap<String, Enum> map = new TreeMap<String, Enum>(String.CASE_INSENSITIVE_ORDER);
        for (Object o : c.getEnumConstants()) {
            Enum e = (Enum)o;
            map.put(e.name().toUpperCase(), e);
        }
        return map;
    }

    @NotNull
    public static <E extends Enum<E>> E valueOfIgnoreCase(@NotNull Class<E> eClass, @NotNull String name) {
        Map map = (Map)CASE_IGNORE_LOOKUP.get(eClass);
        if (name.startsWith("{") && name.endsWith("}")) {
            return ObjectUtils.getSingletonForEnum(eClass);
        }
        Enum anEnum = (Enum)map.get(name);
        return (E)(anEnum == null ? Enum.valueOf(eClass, name) : anEnum);
    }

    public static <E extends Enum<E>> E getSingletonForEnum(Class<E> eClass) {
        Enum[] enumConstants = (Enum[])eClass.getEnumConstants();
        if (enumConstants.length == 0) {
            throw new IllegalStateException("Cannot convert marshallable to " + eClass + " as it doesn't have any instances");
        }
        if (enumConstants.length > 1) {
            Jvm.warn().on(ObjectUtils.class, eClass + " has multiple INSTANCEs, picking the first one");
        }
        return (E)enumConstants[0];
    }

    static <E> E convertTo0(Class<E> eClass, @Nullable Object o) throws ClassCastException, IllegalArgumentException {
        if ((eClass = ObjectUtils.primToWrapper(eClass)).isInstance(o) || o == null) {
            return (E)o;
        }
        if (eClass == Void.class) {
            return null;
        }
        if (eClass == String.class) {
            return (E)o.toString();
        }
        if (Enum.class.isAssignableFrom(eClass)) {
            return ObjectUtils.valueOfIgnoreCase(eClass, o.toString());
        }
        if (o instanceof CharSequence) {
            CharSequence cs = (CharSequence)o;
            if (Character.class.equals((Object)eClass)) {
                if (cs.length() > 0) {
                    return (E)Character.valueOf(cs.charAt(0));
                }
                return null;
            }
            String s = cs.toString();
            if (eClass == String.class) {
                return (E)s;
            }
            try {
                return (E)((ThrowingFunction)PARSER_CL.get(eClass)).apply(s);
            }
            catch (Exception e) {
                throw ObjectUtils.asCCE(e);
            }
        }
        if (Number.class.isAssignableFrom(eClass)) {
            return (E)ObjectUtils.convertToNumber(eClass, o);
        }
        if (ReadResolvable.class.isAssignableFrom(eClass)) {
            return (E)o;
        }
        if (Object[].class.isAssignableFrom(eClass)) {
            return ObjectUtils.convertToArray(eClass, o);
        }
        if (Set.class.isAssignableFrom(eClass)) {
            return (E)new LinkedHashSet((Collection)o);
        }
        if (Character.class == eClass) {
            String s = o.toString();
            if (s.length() == 1) {
                return (E)Character.valueOf(s.charAt(0));
            }
            if (s.isEmpty()) {
                return (E)Character.valueOf('\u0000');
            }
        }
        if (CharSequence.class.isAssignableFrom(eClass)) {
            try {
                return (E)((ThrowingFunction)PARSER_CL.get(eClass)).apply(o.toString());
            }
            catch (Exception e) {
                throw ObjectUtils.asCCE(e);
            }
        }
        throw new ClassCastException("Unable to convert " + o.getClass() + " " + o + " to " + eClass);
    }

    @NotNull
    public static ClassCastException asCCE(Exception e) {
        ClassCastException cce = new ClassCastException();
        cce.initCause(e);
        return cce;
    }

    @NotNull
    private static <E> E convertToArray(@NotNull Class<E> eClass, Object o) throws IllegalArgumentException {
        int len = ObjectUtils.sizeOf(o);
        Object array = Array.newInstance(eClass.getComponentType(), len);
        Iterator iter = ObjectUtils.iteratorFor(o);
        Class elementType = ObjectUtils.elementType(eClass);
        for (int i = 0; i < len; ++i) {
            E value = ObjectUtils.convertTo(elementType, iter.next());
            Array.set(array, i, value);
        }
        return (E)array;
    }

    private static <E> Class elementType(@NotNull Class<E> eClass) {
        if (Object[].class.isAssignableFrom(eClass)) {
            return eClass.getComponentType();
        }
        return Object.class;
    }

    private static Iterator iteratorFor(Object o) {
        if (o instanceof Iterable) {
            return ((Iterable)o).iterator();
        }
        if (o instanceof Object[]) {
            return Arrays.asList((Object[])o).iterator();
        }
        throw new UnsupportedOperationException();
    }

    private static int sizeOf(Object o) throws IllegalArgumentException {
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        throw new UnsupportedOperationException();
    }

    private static Number convertToNumber(Class eClass, Object o) throws NumberFormatException {
        if (o instanceof Number) {
            Number n = (Number)o;
            if (eClass == Double.class) {
                return n.doubleValue();
            }
            if (eClass == Long.class) {
                return n.longValue();
            }
            if (eClass == Integer.class) {
                return n.intValue();
            }
            if (eClass == Float.class) {
                return Float.valueOf(n.floatValue());
            }
            if (eClass == Short.class) {
                return n.shortValue();
            }
            if (eClass == Byte.class) {
                return n.byteValue();
            }
            if (eClass == BigDecimal.class) {
                return n instanceof Long ? BigDecimal.valueOf(n.longValue()) : BigDecimal.valueOf(n.doubleValue());
            }
            if (eClass == BigInteger.class) {
                return new BigInteger(o.toString());
            }
        } else {
            String s = o.toString();
            if (eClass == Double.class) {
                return Double.parseDouble(s);
            }
            if (eClass == Long.class) {
                return Long.parseLong(s);
            }
            if (eClass == Integer.class) {
                return Integer.parseInt(s);
            }
            if (eClass == Float.class) {
                return Float.valueOf(Float.parseFloat(s));
            }
            if (eClass == Short.class) {
                return Short.parseShort(s);
            }
            if (eClass == Byte.class) {
                return Byte.parseByte(s);
            }
            if (eClass == BigDecimal.class) {
                return new BigDecimal(s);
            }
            if (eClass == BigInteger.class) {
                return new BigInteger(s);
            }
        }
        throw new UnsupportedOperationException("Cannot convert " + o.getClass() + " to " + eClass);
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> clazz) {
        Supplier cons = (Supplier)SUPPLIER_CLASS_LOCAL.get(clazz);
        return cons.get();
    }

    public static <T> T[] addAll(@NotNull T first, T ... additional) {
        Object[] interfaces;
        if (additional.length == 0) {
            interfaces = (Object[])Array.newInstance(first.getClass(), 1);
            interfaces[0] = first;
        } else {
            ArrayList<T> objs = new ArrayList<T>();
            objs.add(first);
            Collections.addAll(objs, additional);
            interfaces = objs.toArray((Object[])Array.newInstance(first.getClass(), objs.size()));
        }
        return interfaces;
    }

    public static boolean matchingClass(Class base, Class toMatch) {
        return base == toMatch || Enum.class.isAssignableFrom(toMatch) && base.equals(toMatch.getEnclosingClass());
    }

    @NotNull
    public static <T> T printAll(@NotNull Class<T> tClass, Class ... additional) {
        return ObjectUtils.onMethodCall((method, args) -> {
            String argsStr = args == null ? "()" : Arrays.toString(args);
            System.out.println(method.getName() + " " + argsStr);
            return ObjectUtils.defaultValue(method.getReturnType());
        }, tClass, additional);
    }

    public static Object defaultValue(Class<?> type) {
        return DEFAULT_MAP.get(type);
    }

    @NotNull
    public static <T> T onMethodCall(final @NotNull BiFunction<Method, Object[], Object> biFunction, @NotNull Class<T> tClass, Class ... additional) {
        Class[] interfaces = ObjectUtils.addAll(tClass, additional);
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                return biFunction.apply(method, args);
            }
        });
    }

    @NotNull
    public static Class getTypeFor(@NotNull Class clazz, @NotNull Class interfaceClass) {
        return ObjectUtils.getTypeFor(clazz, interfaceClass, 0);
    }

    @NotNull
    public static Class getTypeFor(@NotNull Class clazz, @NotNull Class interfaceClass, int index) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType ptype;
            if (!(type instanceof ParameterizedType) || !interfaceClass.isAssignableFrom((Class)(ptype = (ParameterizedType)type).getRawType())) continue;
            Type type0 = ptype.getActualTypeArguments()[index];
            if (type0 instanceof Class) {
                return (Class)type0;
            }
            throw new IllegalArgumentException("The match super interface for " + clazz + " was not a concrete class, was " + ptype);
        }
        throw new IllegalArgumentException("No matching super interface for " + clazz + " which was a " + interfaceClass);
    }

    public static boolean isConcreteClass(@NotNull Class tClass) {
        return (tClass.getModifiers() & 0x600) == 0;
    }

    public static Object readResolve(@NotNull Object o) {
        Method readResove = READ_RESOLVE.get(o.getClass());
        if (readResove == null) {
            return o;
        }
        try {
            return readResove.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw Jvm.rethrow(e);
        }
        catch (InvocationTargetException e) {
            throw Jvm.rethrow(e.getCause());
        }
    }

    static {
        DEFAULT_MAP.put(Boolean.TYPE, false);
        DEFAULT_MAP.put(Byte.TYPE, (byte)0);
        DEFAULT_MAP.put(Short.TYPE, (short)0);
        DEFAULT_MAP.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULT_MAP.put(Integer.TYPE, 0);
        DEFAULT_MAP.put(Long.TYPE, 0L);
        DEFAULT_MAP.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_MAP.put(Double.TYPE, 0.0);
    }

    private static class ConversionFunction
    implements Function<Class<?>, ThrowingFunction<String, Object, Exception>> {
        private ConversionFunction() {
        }

        @Override
        public ThrowingFunction<String, Object, Exception> apply(@NotNull Class<?> c) {
            if (c == Class.class) {
                return ClassAliasPool.CLASS_ALIASES::forName;
            }
            if (c == Boolean.class) {
                return ObjectUtils::isTrue;
            }
            try {
                Method valueOf = c.getDeclaredMethod("valueOf", String.class);
                valueOf.setAccessible(true);
                return s -> valueOf.invoke(null, s);
            }
            catch (NoSuchMethodException valueOf) {
                try {
                    Method valueOf2 = c.getDeclaredMethod("parse", CharSequence.class);
                    valueOf2.setAccessible(true);
                    return s -> valueOf2.invoke(null, s);
                }
                catch (NoSuchMethodException valueOf2) {
                    try {
                        Method valueOf3 = c.getDeclaredMethod("fromString", String.class);
                        valueOf3.setAccessible(true);
                        return s -> valueOf3.invoke(null, s);
                    }
                    catch (NoSuchMethodException valueOf3) {
                        try {
                            Constructor<?> constructor = c.getDeclaredConstructor(String.class);
                            constructor.setAccessible(true);
                            return s -> constructor.newInstance(s);
                        }
                        catch (Exception e) {
                            throw ObjectUtils.asCCE(e);
                        }
                    }
                }
            }
        }
    }

    public static enum Immutability {
        YES,
        NO,
        MAYBE;

    }
}

