/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloseablesManager
implements java.io.Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)CloseablesManager.class.getName());
    private final List<java.io.Closeable> closeables = new ArrayList<java.io.Closeable>();

    public synchronized void add(java.io.Closeable closeable) {
        if (closeable == null) {
            throw new NullPointerException();
        }
        if (!this.closeables.contains(closeable)) {
            this.closeables.add(closeable);
        }
    }

    public synchronized void close(java.io.Closeable closeable) throws IOException {
        this.closeables.remove(closeable);
        closeable.close();
    }

    public synchronized void closeQuietly(java.io.Closeable closeable) {
        try {
            this.close(closeable);
        }
        catch (IOException e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        IOException ex = null;
        for (int i = this.closeables.size() - 1; i >= 0; --i) {
            java.io.Closeable closeable = this.closeables.get(i);
            try {
                closeable.close();
                continue;
            }
            catch (NullPointerException e) {
                Jvm.warn().on(this.getClass(), e);
                continue;
            }
            catch (IOException e) {
                Jvm.warn().on(this.getClass(), e);
                ex = e;
            }
        }
        this.closeables.clear();
        if (ex != null) {
            throw ex;
        }
    }

    public synchronized void closeQuietly() {
        Closeable.closeQuietly(this);
    }

    public synchronized boolean isEmpty() {
        return this.closeables.isEmpty();
    }
}

