/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.openhft.chronicle.core.util.ReadResolvable;

public enum ObjectUtils {


    public static <E> E convertTo(Class<E> eClass, Object o) throws ClassCastException {
        if (eClass.isInstance(o) || o == null) {
            return (E)o;
        }
        if (Enum.class.isAssignableFrom(eClass)) {
            return Enum.valueOf(eClass, o.toString());
        }
        if (o instanceof String) {
            try {
                Method valueOf = eClass.getDeclaredMethod("valueOf", String.class);
                valueOf.setAccessible(true);
                return (E)valueOf.invoke(null, o);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                ClassCastException cce = new ClassCastException();
                cce.initCause(e);
                throw cce;
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<E> constructor = eClass.getDeclaredConstructor(String.class);
                    constructor.setAccessible(true);
                    return constructor.newInstance(o);
                }
                catch (Exception e2) {
                    ClassCastException cce = new ClassCastException();
                    cce.initCause(e2);
                    throw cce;
                }
            }
        }
        if (Number.class.isAssignableFrom(eClass)) {
            return (E)ObjectUtils.convertToNumber(eClass, o);
        }
        if (ReadResolvable.class.isAssignableFrom(eClass)) {
            return (E)o;
        }
        if (Object[].class.isAssignableFrom(eClass)) {
            return ObjectUtils.convertToArray(eClass, o);
        }
        throw new ClassCastException("Unable to convert " + o.getClass() + " " + o + " to " + eClass);
    }

    private static <E> E convertToArray(Class<E> eClass, Object o) {
        int len = ObjectUtils.sizeOf(o);
        Object array = Array.newInstance(eClass, len);
        Iterator iter = ObjectUtils.iteratorFor(o);
        Class elementType = ObjectUtils.elementType(eClass);
        for (int i = 0; i < len; ++i) {
            Array.set(array, i, ObjectUtils.convertTo(elementType, iter.next()));
        }
        return (E)array;
    }

    private static <E> Class elementType(Class<E> eClass) {
        if (Object[].class.isAssignableFrom(eClass)) {
            return eClass.getComponentType();
        }
        return Object.class;
    }

    private static Iterator iteratorFor(Object o) {
        if (o instanceof Iterable) {
            return ((Iterable)o).iterator();
        }
        if (o instanceof Object[]) {
            return Arrays.asList((Object[])o).iterator();
        }
        throw new UnsupportedOperationException();
    }

    private static int sizeOf(Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        throw new UnsupportedOperationException();
    }

    private static Number convertToNumber(Class eClass, Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            if (eClass == Double.class) {
                return n.doubleValue();
            }
            if (eClass == Long.class) {
                return n.longValue();
            }
            if (eClass == Integer.class) {
                return n.intValue();
            }
            if (eClass == Float.class) {
                return Float.valueOf(n.floatValue());
            }
            if (eClass == Short.class) {
                return n.shortValue();
            }
            if (eClass == Byte.class) {
                return n.byteValue();
            }
            if (eClass == BigDecimal.class) {
                return n instanceof Long ? BigDecimal.valueOf(n.longValue()) : BigDecimal.valueOf(n.doubleValue());
            }
            if (eClass == BigInteger.class) {
                return new BigInteger(o.toString());
            }
        } else {
            String s = o.toString();
            if (eClass == Double.class) {
                return Double.parseDouble(s);
            }
            if (eClass == Long.class) {
                return Long.parseLong(s);
            }
            if (eClass == Integer.class) {
                return Integer.parseInt(s);
            }
            if (eClass == Float.class) {
                return Float.valueOf(Float.parseFloat(s));
            }
            if (eClass == Short.class) {
                return Short.parseShort(s);
            }
            if (eClass == Byte.class) {
                return Byte.parseByte(s);
            }
            if (eClass == BigDecimal.class) {
                return new BigDecimal(s);
            }
            if (eClass == BigInteger.class) {
                return new BigInteger(s);
            }
        }
        throw new UnsupportedOperationException("Cannot convert " + o.getClass() + " to " + eClass);
    }
}

