/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.channels.FileLock;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.Monitorable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractReference
extends AbstractCloseable
implements Byteable,
Closeable {
    @Nullable
    protected BytesStore bytesStore;
    protected long offset;

    protected AbstractReference() {
        this.singleThreadedCheckDisabled(true);
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        bytes.readInt(offset);
        BytesStore<?, ?> bytesStore = bytes.bytesStore();
        this.acceptNewBytesStore(bytesStore);
        this.offset = offset;
    }

    @Override
    @Nullable
    public BytesStore<?, ?> bytesStore() {
        return this.bytesStore;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    protected void acceptNewBytesStore(@NotNull BytesStore<?, ?> bytes) throws IllegalStateException {
        if (this.bytesStore != null) {
            this.bytesStore.release((ReferenceOwner)this);
        }
        this.bytesStore = bytes.bytesStore();
        this.bytesStore.reserve((ReferenceOwner)this);
    }

    protected void performClose() {
        if (this.bytesStore == null) {
            return;
        }
        BytesStore bytes0 = this.bytesStore;
        this.bytesStore = null;
        try {
            bytes0.release((ReferenceOwner)this);
        }
        catch (ClosedIllegalStateException e) {
            Jvm.debug().on(AbstractReference.class, "release after close", (Throwable)e);
        }
    }

    @Override
    public long address() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytesStore().addressForRead(this.offset);
    }

    @Override
    public FileLock lock(boolean shared) throws IOException {
        if (this.bytesStore() instanceof MappedBytesStore) {
            MappedBytesStore mbs = (MappedBytesStore)this.bytesStore();
            return mbs.lock(this.offset, this.maxSize(), shared);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(boolean shared) throws IOException {
        if (this.bytesStore() instanceof MappedBytesStore) {
            MappedBytesStore mbs = (MappedBytesStore)this.bytesStore();
            return mbs.tryLock(this.offset, this.maxSize(), shared);
        }
        throw new UnsupportedOperationException();
    }

    public void unmonitor() {
        super.unmonitor();
        Monitorable.unmonitor((Object)this.bytesStore);
    }
}

