/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.ByteableIntArrayValues;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.values.IntValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryIntArrayReference
extends AbstractReference
implements ByteableIntArrayValues,
BytesMarshallable {
    public static final int SHIFT = 2;
    private static final long CAPACITY = 0L;
    private static final long USED = 8L;
    private static final long VALUES = 16L;
    private static final int MAX_TO_STRING = 1024;
    @Nullable
    private static Set<WeakReference<BinaryIntArrayReference>> binaryIntArrayReferences = null;
    private long length;

    public BinaryIntArrayReference() {
        this(0L);
    }

    public BinaryIntArrayReference(long defaultCapacity) {
        this.length = (defaultCapacity << 2) + 16L;
    }

    public static void startCollecting() {
        binaryIntArrayReferences = Collections.newSetFromMap(new IdentityHashMap());
    }

    public static void forceAllToNotCompleteState() throws IllegalStateException, BufferOverflowException {
        if (binaryIntArrayReferences == null) {
            return;
        }
        for (WeakReference<BinaryIntArrayReference> x : binaryIntArrayReferences) {
            @Nullable BinaryIntArrayReference binaryLongReference = (BinaryIntArrayReference)x.get();
            if (binaryLongReference == null) continue;
            binaryLongReference.setValueAt(0L, Integer.MIN_VALUE);
        }
        binaryIntArrayReferences = null;
    }

    public static void write(@NotNull Bytes<?> bytes, @NonNegative long capacity) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        long start = bytes.writePosition();
        bytes.zeroOut(start, start + (capacity << 2));
        bytes.writeSkip(capacity << 2);
    }

    public static void lazyWrite(@NotNull Bytes<?> bytes, @NonNegative long capacity) throws BufferOverflowException, IllegalStateException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        bytes.writeSkip(capacity << 2);
    }

    public static long peakLength(@NotNull BytesStore<?, ?> bytes, @NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        long capacity = bytes.readLong(offset + 0L);
        assert (capacity > 0L) : "capacity too small " + capacity;
        return (capacity << 2) + 16L;
    }

    @Override
    protected void acceptNewBytesStore(@NotNull BytesStore<?, ?> bytes) throws IllegalStateException {
        if (this.bytesStore != null) {
            this.bytesStore.release((ReferenceOwner)this);
        }
        this.bytesStore = bytes;
        this.bytesStore.reserve((ReferenceOwner)this);
    }

    public long getCapacity() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this.length - 16L >>> 2;
    }

    public long getUsed() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytesStore.readVolatileInt(this.offset + 8L);
    }

    public void setMaxUsed(long usedAtLeast) throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosedInSetter();
        this.bytesStore.writeMaxLong(this.offset + 8L, usedAtLeast);
    }

    public int getValueAt(@NonNegative long index) throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytesStore.readInt(16L + this.offset + (index << 2));
    }

    public void setValueAt(@NonNegative long index, int value) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        this.bytesStore.writeInt(16L + this.offset + (index << 2), value);
    }

    public int getVolatileValueAt(@NonNegative long index) throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytesStore.readVolatileInt(16L + this.offset + (index << 2));
    }

    public void bindValueAt(@NonNegative long index, @NotNull IntValue value) throws IllegalStateException, BufferOverflowException, IllegalArgumentException {
        this.throwExceptionIfClosed();
        ((BinaryIntReference)value).bytesStore(this.bytesStore, 16L + this.offset + (index << 2), 8L);
    }

    public void setOrderedValueAt(@NonNegative long index, int value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        this.bytesStore.writeOrderedInt(16L + this.offset + (index << 2), value);
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalArgumentException, IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosed();
        long peakLength = BinaryIntArrayReference.peakLength(bytes, offset);
        if (length != peakLength) {
            throw new IllegalArgumentException(length + " != " + peakLength);
        }
        if (bytes instanceof HexDumpBytes) {
            offset &= 0xFFFFFFFFL;
        }
        assert ((offset & 7L) == 0L) : "offset=" + offset;
        super.bytesStore(bytes, offset + 7L & 0xFFFFFFFFFFFFFFF8L, length);
        this.length = length;
    }

    @Override
    public void readMarshallable(BytesIn<?> bytes) throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosedInSetter();
        long position = bytes.readPosition();
        long capacity = bytes.readLong();
        long used = bytes.readLong();
        if (capacity < 0L || capacity > bytes.readRemaining() >> 2) {
            throw new IORuntimeException("Corrupt used capacity");
        }
        if (used < 0L || used > capacity) {
            throw new IORuntimeException("Corrupt used value");
        }
        bytes.readSkip(capacity << 2);
        long len = bytes.readPosition() - position;
        this.bytesStore((Bytes)bytes, position, len);
    }

    @Override
    public void writeMarshallable(BytesOut<?> bytes) throws IllegalStateException, BufferOverflowException {
        BytesStore<?, ?> bytesStore;
        boolean retainsComments = bytes.retainedHexDumpDescription();
        if (retainsComments) {
            bytes.writeHexDumpDescription("BinaryIntArrayReference");
        }
        if ((bytesStore = this.bytesStore()) == null) {
            long capacity = this.getCapacity();
            if (retainsComments) {
                bytes.writeHexDumpDescription("capacity");
            }
            bytes.writeLong(capacity);
            if (retainsComments) {
                bytes.writeHexDumpDescription("used");
            }
            bytes.writeLong(0L);
            if (retainsComments) {
                bytes.writeHexDumpDescription("values");
            }
            bytes.writeSkip(capacity << 2);
        } else {
            bytes.write(bytesStore, this.offset, this.length);
        }
    }

    public boolean isNull() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this.bytesStore == null;
    }

    public void reset() throws IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        this.bytesStore = null;
        this.offset = 0L;
        this.length = 0L;
    }

    @Override
    @Nullable
    public BytesStore<?, ?> bytesStore() {
        return this.bytesStore;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return this.length;
    }

    @NotNull
    public String toString() {
        if (this.bytesStore == null) {
            return "not set";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("used: ");
        try {
            long used = this.getUsed();
            sb.append(used);
            sb.append(", value: ");
            this.appendContents(sb, used);
            return sb.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private void appendContents(@NotNull StringBuilder sb, long used) {
        String sep = "";
        try {
            int i;
            int max = (int)Math.min(used, Math.min(this.getCapacity(), 1024L));
            for (i = 0; i < max; ++i) {
                long valueAt = this.getValueAt(i);
                sb.append(sep).append(valueAt);
                sep = ", ";
            }
            if ((long)i < this.getCapacity()) {
                sb.append(" ...");
            }
        }
        catch (BufferUnderflowException e) {
            sb.append(" ").append(e);
        }
    }

    @Override
    public long sizeInBytes(@NonNegative long capacity) throws IllegalStateException {
        this.throwExceptionIfClosed();
        return (capacity << 2) + 16L;
    }

    @Override
    public ByteableIntArrayValues capacity(long arrayLength) throws IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        BytesStore<?, ?> bytesStore = this.bytesStore();
        long len = this.sizeInBytes(arrayLength);
        if (bytesStore == null) {
            this.length = len;
        } else assert (this.length == len);
        return this;
    }

    public boolean compareAndSet(@NonNegative long index, int expected, int value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (value == Integer.MIN_VALUE && binaryIntArrayReferences != null) {
            binaryIntArrayReferences.add(new WeakReference<BinaryIntArrayReference>(this));
        }
        return this.bytesStore.compareAndSwapInt(16L + this.offset + (index << 2), expected, value);
    }
}

