/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.domestic;

import java.io.File;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import net.openhft.chronicle.bytes.internal.CanonicalPathUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;
import org.jetbrains.annotations.Nullable;

public final class ReentrantFileLock
extends FileLock {
    private static final ThreadLocal<HashMap<String, ReentrantFileLock>> heldLocks = CleaningThreadLocal.withCleanup(HashMap::new, h -> Closeable.closeQuietly(h.values()));
    private final String canonicalPath;
    private final FileLock delegate;
    private final long owningThreadId;
    private int counter;

    public ReentrantFileLock(String canonicalPath, FileLock fileLock) {
        super(fileLock.channel(), fileLock.position(), fileLock.size(), fileLock.isShared());
        long id;
        this.canonicalPath = canonicalPath;
        this.delegate = fileLock;
        this.owningThreadId = id = Jvm.currentThreadId();
        this.counter = 1;
    }

    @Override
    public Channel acquiredBy() {
        this.checkThreadAccess();
        return this.delegate.acquiredBy();
    }

    @Override
    public boolean isValid() {
        this.checkThreadAccess();
        return this.delegate.isValid();
    }

    @Override
    public void release() throws IOException {
        this.checkThreadAccess();
        if (--this.counter == 0) {
            try {
                this.delegate.release();
            }
            finally {
                heldLocks.get().remove(this.canonicalPath);
            }
        }
    }

    private ReentrantFileLock incrementCounter() {
        this.checkThreadAccess();
        ++this.counter;
        return this;
    }

    @Nullable
    public static ReentrantFileLock tryLock(File file, FileChannel fileChannel) throws IOException {
        String canonicalPath = CanonicalPathUtil.of(file);
        ReentrantFileLock reentrantFileLock = heldLocks.get().get(canonicalPath);
        if (reentrantFileLock != null) {
            return reentrantFileLock.incrementCounter();
        }
        FileLock lock = fileChannel.tryLock();
        if (lock != null) {
            ReentrantFileLock refl = new ReentrantFileLock(canonicalPath, lock);
            heldLocks.get().put(canonicalPath, refl);
            return refl;
        }
        return null;
    }

    public static ReentrantFileLock lock(File file, FileChannel fileChannel) throws IOException {
        String canonicalPath = CanonicalPathUtil.of(file);
        ReentrantFileLock reentrantFileLock = heldLocks.get().get(canonicalPath);
        if (reentrantFileLock != null) {
            return reentrantFileLock.incrementCounter();
        }
        FileLock lock = fileChannel.lock();
        ReentrantFileLock refl = new ReentrantFileLock(canonicalPath, lock);
        heldLocks.get().put(canonicalPath, refl);
        return refl;
    }

    public static boolean isHeldByCurrentThread(File file) {
        return heldLocks.get().containsKey(CanonicalPathUtil.of(file));
    }

    private void checkThreadAccess() {
        long currentThreadId = Jvm.currentThreadId();
        if (currentThreadId != this.owningThreadId) {
            Jvm.error().on(ReentrantFileLock.class, "You're accessing a ReentrantFileLock created by thread " + this.owningThreadId + " on thread " + currentThreadId + " this can have unexpected results, don't do it.");
        }
    }
}

