/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.render;

import net.openhft.chronicle.bytes.render.DecimalAppender;
import net.openhft.chronicle.bytes.render.Decimaliser;

public class MaximumPrecision
implements Decimaliser {
    private final int precision;

    public MaximumPrecision(int precision) {
        if (precision < 0 || precision > 18) {
            throw new IllegalArgumentException("Precision must be between 0 and 18, inclusive.");
        }
        this.precision = precision;
    }

    @Override
    public boolean toDecimal(double value, DecimalAppender decimalAppender) {
        boolean isNegative = Double.doubleToLongBits(value) < 0L;
        double absValue = Math.abs(value);
        if (!(absValue <= 1.0E18)) {
            return false;
        }
        long factor = 1L;
        for (int exponent = 0; exponent <= this.precision; ++exponent) {
            long mantissa = Math.round(absValue * (double)factor);
            if ((double)mantissa / (double)factor == absValue) {
                decimalAppender.append(isNegative, mantissa, exponent);
                return true;
            }
            if (mantissa >= 0xCCCCCCCCCCCCCCCL || exponent == this.precision) {
                while (exponent > 0 && mantissa % 10L == 0L) {
                    mantissa /= 10L;
                    --exponent;
                }
                decimalAppender.append(isNegative, mantissa, exponent);
                return true;
            }
            factor *= 10L;
        }
        return false;
    }

    @Override
    public boolean toDecimal(float value, DecimalAppender decimalAppender) {
        boolean isNegative = Double.doubleToLongBits(value) < 0L;
        float absValue = Math.abs(value);
        if (!((double)absValue < 1.0E18)) {
            return false;
        }
        long factor = 1L;
        for (int exponent = 0; exponent <= this.precision; ++exponent) {
            long mantissa = Math.round((double)absValue * (double)factor);
            if ((float)((double)mantissa / (double)factor) == absValue) {
                decimalAppender.append(isNegative, mantissa, exponent);
                return true;
            }
            if (mantissa >= 0xCCCCCCCCCCCCCCCL || exponent == this.precision) {
                while (exponent > 0 && mantissa % 10L == 0L) {
                    mantissa /= 10L;
                    --exponent;
                }
                decimalAppender.append(isNegative, mantissa, exponent);
                return true;
            }
            factor *= 10L;
        }
        return false;
    }
}

