/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.render;

import net.openhft.chronicle.bytes.render.DecimalAppender;
import net.openhft.chronicle.bytes.render.Decimaliser;

public class SimpleDecimaliser
implements Decimaliser {
    public static final int LARGEST_EXPONENT_IN_LONG = 18;
    public static final Decimaliser SIMPLE = new SimpleDecimaliser();

    @Override
    public boolean toDecimal(double value, DecimalAppender decimalAppender) {
        boolean isNegative = Double.doubleToLongBits(value) < 0L;
        double absValue = Math.abs(value);
        long factor = 1L;
        for (int exponent = 0; exponent <= 18; ++exponent) {
            long mantissa = Math.round(absValue * (double)factor);
            if ((double)mantissa / (double)factor == absValue) {
                decimalAppender.append(isNegative, mantissa, exponent);
                return true;
            }
            factor *= 10L;
        }
        return false;
    }

    @Override
    public boolean toDecimal(float value, DecimalAppender decimalAppender) {
        boolean sign = Float.floatToRawIntBits(value) < 0;
        float absValue = Math.abs(value);
        long factor = 1L;
        for (int exponent = 0; exponent <= 18; ++exponent) {
            long mantissa = Math.round((double)absValue * (double)factor);
            if ((float)mantissa / (float)factor == absValue) {
                decimalAppender.append(sign, mantissa, exponent);
                return true;
            }
            factor *= 10L;
        }
        return false;
    }
}

