/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesPrepender;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.HasUncheckedRandomDataInput;
import net.openhft.chronicle.bytes.internal.HeapBytesStore;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.internal.UncheckedRandomDataInput;
import net.openhft.chronicle.bytes.pool.BytesPool;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.bytes.util.StringInternerBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.UnsafeText;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.EnumInterner;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.util.ByteBuffers;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BytesInternal
extends Enum<BytesInternal> {
    public static final ThreadLocal<ByteBuffer> BYTE_BUFFER_TL;
    public static final ThreadLocal<ByteBuffer> BYTE_BUFFER2_TL;
    public static final StringInternerBytes SI;
    static final char[] HEXADECIMAL;
    private static final String INFINITY = "Infinity";
    private static final String NAN = "NaN";
    private static final String MALFORMED_INPUT_PARTIAL_CHARACTER_AT_END = "malformed input: partial character at end";
    private static final String MALFORMED_INPUT_AROUND_BYTE = "malformed input around byte ";
    private static final String WAS = " was ";
    private static final String CAN_T_PARSE_FLEXIBLE_LONG_WITHOUT_PRECISION_LOSS = "Can't parse flexible long without precision loss: ";
    private static final byte[] MIN_VALUE_TEXT;
    private static final StringBuilderPool SBP;
    private static final BytesPool BP;
    private static final byte[] INFINITY_BYTES;
    private static final byte[] NAN_BYTES;
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;
    private static final ThreadLocal<DateCache> dateCacheTL;
    private static final int MAX_STRING_LEN;
    private static final int NEG_ONE;
    private static final MethodHandle VECTORIZED_MISMATCH_METHOD_HANDLE;
    private static final /* synthetic */ BytesInternal[] $VALUES;

    public static BytesInternal[] values() {
        return (BytesInternal[])$VALUES.clone();
    }

    public static BytesInternal valueOf(String name) {
        return Enum.valueOf(BytesInternal.class, name);
    }

    public static boolean contentEqual(@Nullable BytesStore a, @Nullable BytesStore b) throws IllegalStateException {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            ReferenceCountedUtil.throwExceptionIfReleased(a);
            return false;
        }
        ReferenceCountedUtil.throwExceptionIfReleased(a);
        ReferenceCountedUtil.throwExceptionIfReleased(b);
        long readRemaining = a.readRemaining();
        if (readRemaining != b.readRemaining()) {
            return false;
        }
        if (VECTORIZED_MISMATCH_METHOD_HANDLE != null && b.realReadRemaining() == a.realReadRemaining() && a.realReadRemaining() < Integer.MAX_VALUE && a.realReadRemaining() > 7L && !(a instanceof HexDumpBytes) && !(b instanceof HexDumpBytes)) {
            try {
                Boolean vectorizedResult = BytesInternal.java11ContentEqualUsingVectorizedMismatch(a, b);
                if (vectorizedResult != null) {
                    return vectorizedResult;
                }
            }
            catch (UnsupportedOperationException e) {
                Jvm.warn().on(BytesInternal.class, (Throwable)e);
            }
        }
        return readRemaining <= Integer.MAX_VALUE ? BytesInternal.contentEqualInt(a, b) : BytesInternal.contentEqualsLong(a, b);
    }

    private static Boolean java11ContentEqualUsingVectorizedMismatch(@NotNull BytesStore left, @NotNull BytesStore right) {
        try {
            long rightOffset;
            Object rightObject;
            long leftOffset;
            Object leftObject;
            if (left.isDirectMemory()) {
                leftObject = null;
                leftOffset = left.addressForRead(left.readPosition());
            } else {
                BytesStore bytesStore = left.bytesStore();
                if (!(bytesStore instanceof HeapBytesStore)) {
                    return null;
                }
                HeapBytesStore heapBytesStore = (HeapBytesStore)bytesStore;
                leftObject = heapBytesStore.realUnderlyingObject();
                leftOffset = heapBytesStore.dataOffset();
            }
            if (right.isDirectMemory()) {
                rightObject = null;
                rightOffset = right.addressForRead(right.readPosition());
            } else {
                BytesStore bytesStore = right.bytesStore();
                if (!(bytesStore instanceof HeapBytesStore)) {
                    return null;
                }
                HeapBytesStore heapBytesStore = (HeapBytesStore)bytesStore;
                rightObject = heapBytesStore.realUnderlyingObject();
                rightOffset = heapBytesStore.dataOffset();
            }
            int length = (int)left.realReadRemaining();
            int invoke = VECTORIZED_MISMATCH_METHOD_HANDLE.invoke(leftObject, leftOffset, rightObject, rightOffset, length, 0);
            if (invoke >= 0) {
                return Boolean.FALSE;
            }
            for (int remaining = length - (invoke ^ 0xFFFFFFFF); remaining < length; ++remaining) {
                if (left.readByte(left.readPosition() + (long)remaining) == right.readByte(right.readPosition() + (long)remaining)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Throwable e) {
            Jvm.warn().on(BytesInternal.class, e);
            return null;
        }
    }

    static <U extends BytesStore<?, ?> & HasUncheckedRandomDataInput> boolean contentEqualInt(@NotNull BytesStore<?, ?> a, @NotNull BytesStore<?, ?> b) throws IllegalStateException {
        int aLength = (int)a.realReadRemaining();
        int bLength = (int)b.realReadRemaining();
        if (a instanceof HasUncheckedRandomDataInput && b instanceof HasUncheckedRandomDataInput) {
            if (aLength < bLength) {
                return BytesInternal.contentEqualIntUnchecked(b, a, bLength, aLength);
            }
            return BytesInternal.contentEqualIntUnchecked(a, b, aLength, bLength);
        }
        if (aLength < bLength) {
            return BytesInternal.contentEqualInt(b, a, bLength, aLength);
        }
        return BytesInternal.contentEqualInt(a, b, aLength, bLength);
    }

    static boolean contentEqualInt(@NotNull BytesStore<?, ?> a, @NotNull BytesStore<?, ?> b, @NonNegative int aLength, @NonNegative int bLength) throws IllegalStateException {
        int i;
        long aPos = a.readPosition();
        long bPos = b.readPosition();
        for (i = 0; i < bLength - 7; i += 8) {
            if (a.readLong(aPos + (long)i) == b.readLong(bPos + (long)i)) continue;
            return false;
        }
        while (i < bLength) {
            if (a.readByte(aPos + (long)i) != b.readByte(bPos + (long)i)) {
                return false;
            }
            ++i;
        }
        while (i < aLength - 7) {
            if (a.readLong(aPos + (long)i) != 0L) {
                return false;
            }
            i += 8;
        }
        while (i < aLength) {
            if (a.readByte(aPos + (long)i) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static <U extends BytesStore<?, ?> & HasUncheckedRandomDataInput> boolean contentEqualIntUnchecked(@NotNull U a, @NotNull U b, @NonNegative int aLength, @NonNegative int bLength) throws IllegalStateException {
        int i;
        UncheckedRandomDataInput ua = ((HasUncheckedRandomDataInput)a).acquireUncheckedInput();
        UncheckedRandomDataInput ub = ((HasUncheckedRandomDataInput)b).acquireUncheckedInput();
        long aPos = a.readPosition();
        long bPos = b.readPosition();
        for (i = 0; i < bLength - 7; i += 8) {
            if (ua.readLong(aPos + (long)i) == ub.readLong(bPos + (long)i)) continue;
            return false;
        }
        while (i < bLength) {
            if (ua.readByte(aPos + (long)i) != ub.readByte(bPos + (long)i)) {
                return false;
            }
            ++i;
        }
        while (i < aLength - 7) {
            if (ua.readLong(aPos + (long)i) != 0L) {
                return false;
            }
            i += 8;
        }
        while (i < aLength) {
            if (ua.readByte(aPos + (long)i) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static <U extends BytesStore<?, ?> & HasUncheckedRandomDataInput> boolean contentEqualsLong(@NotNull BytesStore a, @NotNull BytesStore b) {
        long aLength = a.realReadRemaining();
        long bLength = b.realReadRemaining();
        if (a instanceof HasUncheckedRandomDataInput && b instanceof HasUncheckedRandomDataInput) {
            if (a.realCapacity() < b.realCapacity()) {
                return BytesInternal.contentEqualsLongUnchecked(b, a, bLength, aLength);
            }
            return BytesInternal.contentEqualsLongUnchecked(a, b, aLength, bLength);
        }
        if (a.realCapacity() < b.realCapacity()) {
            return BytesInternal.contentEqualsLong(b, a, bLength, aLength);
        }
        return BytesInternal.contentEqualsLong(a, b, aLength, bLength);
    }

    private static boolean contentEqualsLong(@NotNull BytesStore a, @NotNull BytesStore b, @NonNegative long aLength, @NonNegative long bLength) {
        long i;
        long aPos = a.readPosition();
        long bPos = b.readPosition();
        for (i = 0L; i < bLength - 7L; i += 8L) {
            if (a.readLong(aPos + i) == b.readLong(bPos + i)) continue;
            return false;
        }
        while (i < bLength) {
            if (a.readByte(aPos + i) != b.readByte(bPos + i)) {
                return false;
            }
            ++i;
        }
        while (i < aLength - 7L) {
            if (a.readLong(aPos + i) != 0L) {
                return false;
            }
            i += 8L;
        }
        while (i < aLength) {
            if (a.readByte(aPos + i) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static <U extends BytesStore<?, ?> & HasUncheckedRandomDataInput> boolean contentEqualsLongUnchecked(@NotNull U a, @NotNull U b, @NonNegative long aLength, @NonNegative long bLength) {
        long i;
        UncheckedRandomDataInput ua = ((HasUncheckedRandomDataInput)a).acquireUncheckedInput();
        UncheckedRandomDataInput ub = ((HasUncheckedRandomDataInput)b).acquireUncheckedInput();
        long aPos = a.readPosition();
        long bPos = b.readPosition();
        for (i = 0L; i < bLength - 7L; i += 8L) {
            if (ua.readLong(aPos + i) == ub.readLong(bPos + i)) continue;
            return false;
        }
        while (i < bLength) {
            if (ua.readByte(aPos + i) != ub.readByte(bPos + i)) {
                return false;
            }
            ++i;
        }
        while (i < aLength - 7L) {
            if (ua.readLong(aPos + i) != 0L) {
                return false;
            }
            i += 8L;
        }
        while (i < aLength) {
            if (ua.readByte(aPos + i) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWith(@NotNull BytesStore a, @NotNull BytesStore b) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(a);
        ReferenceCountedUtil.throwExceptionIfReleased(b);
        long bRealReadRemaining = b.realReadRemaining();
        if (a.realReadRemaining() < bRealReadRemaining) {
            return false;
        }
        return BytesInternal.startsWith(a, b, a.readPosition(), b.readPosition(), bRealReadRemaining);
    }

    public static <U extends BytesStore & HasUncheckedRandomDataInput> boolean startsWithUnchecked(@NotNull U a, @NotNull BytesStore b) {
        ReferenceCountedUtil.throwExceptionIfReleased(a);
        ReferenceCountedUtil.throwExceptionIfReleased(b);
        long bRealReadRemaining = b.realReadRemaining();
        if (a.realReadRemaining() < bRealReadRemaining) {
            return false;
        }
        if (b instanceof HasUncheckedRandomDataInput) {
            return BytesInternal.startsWithUnchecked(((HasUncheckedRandomDataInput)a).acquireUncheckedInput(), ((HasUncheckedRandomDataInput)((Object)b)).acquireUncheckedInput(), a.readPosition(), b.readPosition(), bRealReadRemaining);
        }
        return BytesInternal.startsWith(a, b, a.readPosition(), b.readPosition(), bRealReadRemaining);
    }

    private static boolean startsWithUnchecked(@NotNull UncheckedRandomDataInput ua, @NotNull UncheckedRandomDataInput ub, @NonNegative long aPos, @NonNegative long bPos, @NonNegative long length) {
        int i = 0;
        while ((long)i < length - 7L) {
            if (ua.readLong(aPos + (long)i) != ub.readLong(bPos + (long)i)) {
                return false;
            }
            i += 8;
        }
        if ((long)i < length - 3L) {
            if (ua.readInt(aPos + (long)i) != ub.readInt(bPos + (long)i)) {
                return false;
            }
            i += 4;
        }
        if ((long)i < length - 1L) {
            if (ua.readShort(aPos + (long)i) != ub.readShort(bPos + (long)i)) {
                return false;
            }
            i += 2;
        }
        if ((long)i < length) {
            return ua.readByte(aPos + (long)i) == ub.readByte(bPos + (long)i);
        }
        return true;
    }

    private static boolean startsWith(@NotNull BytesStore a, @NotNull BytesStore b, @NonNegative long aPos, @NonNegative long bPos, @NonNegative long length) {
        int i = 0;
        while ((long)i < length - 7L) {
            if (a.readLong(aPos + (long)i) != b.readLong(bPos + (long)i)) {
                return false;
            }
            i += 8;
        }
        if ((long)i < length - 3L) {
            if (a.readInt(aPos + (long)i) != b.readInt(bPos + (long)i)) {
                return false;
            }
            i += 4;
        }
        if ((long)i < length - 1L) {
            if (a.readShort(aPos + (long)i) != b.readShort(bPos + (long)i)) {
                return false;
            }
            i += 2;
        }
        if ((long)i < length) {
            return a.readByte(aPos + (long)i) == b.readByte(bPos + (long)i);
        }
        return true;
    }

    public static void parseUtf8(@NotNull StreamingDataInput bytes, Appendable appendable, boolean utf, @NonNegative int length) throws UTFDataFormatRuntimeException, BufferUnderflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        if (appendable instanceof StringBuilder && bytes.isDirectMemory() && length < 0x100000 && utf) {
            BytesInternal.parseUtf8_SB1((Bytes)bytes, (StringBuilder)appendable, utf, length);
        } else {
            BytesInternal.parseUtf81(bytes, appendable, utf, length);
        }
    }

    public static void parseUtf8(@NotNull RandomDataInput input, @NonNegative long offset, Appendable appendable, boolean utf, @NonNegative int length) throws UTFDataFormatRuntimeException, BufferUnderflowException, IllegalStateException {
        assert (utf);
        ReferenceCountedUtil.throwExceptionIfReleased(input);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        if (appendable instanceof StringBuilder) {
            if (input instanceof NativeBytesStore) {
                BytesInternal.parseUtf8_SB1((NativeBytesStore)input, offset, (StringBuilder)appendable, length);
                return;
            }
            if (input instanceof Bytes && ((Bytes)input).bytesStore() instanceof NativeBytesStore) {
                @Nullable NativeBytesStore bs = (NativeBytesStore)((Bytes)input).bytesStore();
                BytesInternal.parseUtf8_SB1(bs, offset, (StringBuilder)appendable, length);
                return;
            }
        }
        BytesInternal.parseUtf81(input, offset, appendable, length);
    }

    public static boolean compareUtf8(@NotNull RandomDataInput input, @NonNegative long offset, @Nullable CharSequence other) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        long utfLen;
        ReferenceCountedUtil.throwExceptionIfReleased(input);
        if (other != null) {
            ReferenceCountedUtil.throwExceptionIfReleased(other);
        }
        if ((utfLen = (long)input.readByte(offset++)) < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)input.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return other == null;
        }
        return other != null && BytesInternal.compareUtf8(input, offset, utfLen, other);
    }

    private static boolean compareUtf8(@NotNull RandomDataInput input, @NonNegative long offset, @NonNegative long utfLen, @NotNull CharSequence other) throws UTFDataFormatRuntimeException, BufferUnderflowException, IndexOutOfBoundsException, IllegalStateException {
        byte c;
        int i;
        ReferenceCountedUtil.throwExceptionIfReleased(input);
        ReferenceCountedUtil.throwExceptionIfReleased(other);
        if (offset + utfLen > input.realCapacity()) {
            throw new BufferUnderflowException();
        }
        for (i = 0; (long)i < utfLen && i < other.length() && (c = input.readByte(offset + (long)i)) >= 0; ++i) {
            if ((char)c == other.charAt(i)) continue;
            return false;
        }
        if ((long)i < utfLen && i < other.length()) {
            return BytesInternal.compareUtf82(input, offset + (long)i, i, utfLen, other);
        }
        return utfLen == (long)other.length();
    }

    private static boolean compareUtf82(@NotNull RandomDataInput input, @NonNegative long offset, int charI, @NonNegative long utfLen, @NotNull CharSequence other) throws UTFDataFormatRuntimeException, BufferUnderflowException, IndexOutOfBoundsException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(input);
        ReferenceCountedUtil.throwExceptionIfReleased(other);
        long limit = offset + utfLen;
        while (offset < limit && charI < other.length()) {
            int c = input.readUnsignedByte(offset++);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if ((char)c == other.charAt(charI)) break;
                    return false;
                }
                case 12: 
                case 13: {
                    int char2;
                    if (offset == limit) {
                        throw new UTFDataFormatRuntimeException(MALFORMED_INPUT_PARTIAL_CHARACTER_AT_END);
                    }
                    if (((char2 = input.readUnsignedByte(offset++)) & 0xC0) != 128) {
                        throw BytesInternal.newUTFDataFormatRuntimeException(offset - limit + utfLen, "was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if ((char)c2 == other.charAt(charI)) break;
                    return false;
                }
                case 14: {
                    if (offset + 2L > limit) {
                        throw new UTFDataFormatRuntimeException(MALFORMED_INPUT_PARTIAL_CHARACTER_AT_END);
                    }
                    int char2 = input.readUnsignedByte(offset++);
                    int char3 = input.readUnsignedByte(offset++);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException(MALFORMED_INPUT_AROUND_BYTE + (offset - limit + utfLen - 1L) + WAS + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if ((char)c3 == other.charAt(charI)) break;
                    return false;
                }
                default: {
                    throw BytesInternal.newUTFDataFormatRuntimeException(offset - limit + utfLen, "");
                }
            }
            ++charI;
        }
        return offset == limit && charI == other.length();
    }

    public static void parse8bit(@NonNegative long offset, @NotNull RandomDataInput bytesStore, Appendable appendable, @NonNegative int utflen) throws BufferUnderflowException, IOException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytesStore);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        if (bytesStore instanceof NativeBytesStore && appendable instanceof StringBuilder) {
            BytesInternal.parse8bit_SB1(offset, (NativeBytesStore)bytesStore, (StringBuilder)appendable, utflen);
        } else {
            BytesInternal.parse8bit1(offset, bytesStore, appendable, utflen);
        }
    }

    public static void parseUtf81(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, boolean utf, @NonNegative int length) throws UTFDataFormatRuntimeException, BufferUnderflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        try {
            int count;
            assert (bytes.readRemaining() >= (long)length);
            for (count = 0; count < length; ++count) {
                int c = bytes.readUnsignedByte();
                if (c >= 128) {
                    bytes.readSkip(-1L);
                    break;
                }
                if (c < 0) break;
                appendable.append((char)c);
            }
            if (length > count) {
                BytesInternal.parseUtf82(bytes, appendable, utf, length, count);
            }
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public static void parseUtf81(@NotNull RandomDataInput input, @NonNegative long offset, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(input);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        try {
            assert (input.realCapacity() >= offset + (long)utflen);
            long limit = offset + (long)utflen;
            while (offset < limit) {
                int c;
                if ((c = input.readUnsignedByte(offset++)) >= 128) {
                    --offset;
                    break;
                }
                if (c < 0) break;
                appendable.append((char)c);
            }
            if (limit > offset) {
                BytesInternal.parseUtf82(input, offset, limit, appendable, utflen);
            }
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public static void parse8bit1(@NotNull StreamingDataInput bytes, @NotNull StringBuilder sb, @NonNegative int utflen) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        assert (bytes.readRemaining() >= (long)utflen);
        sb.ensureCapacity(utflen);
        if (Jvm.isJava9Plus()) {
            byte[] sbBytes = StringUtils.extractBytes((StringBuilder)sb);
            for (int count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                sbBytes[count] = (byte)c;
            }
        } else {
            char[] chars = StringUtils.extractChars((StringBuilder)sb);
            for (int count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                chars[count] = (char)c;
            }
        }
        StringUtils.setLength((StringBuilder)sb, (int)utflen);
    }

    public static void parse8bit1(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NonNegative int utflen) throws IllegalStateException, IOException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        assert (bytes.readRemaining() >= (long)utflen);
        for (int count = 0; count < utflen; ++count) {
            int c = bytes.readUnsignedByte();
            appendable.append((char)c);
        }
    }

    public static void parse8bit1(@NonNegative long offset, @NotNull RandomDataInput bytes, @NotNull Appendable appendable, @NonNegative int utflen) throws BufferUnderflowException, IllegalStateException, IOException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        if (bytes.realCapacity() < (long)utflen + offset) {
            throw new DecoratedBufferUnderflowException(bytes.realCapacity() + " < " + utflen + " +" + offset);
        }
        for (int count = 0; count < utflen; ++count) {
            int c = bytes.readUnsignedByte(offset + (long)count);
            appendable.append((char)c);
        }
    }

    public static void parseUtf8_SB1(@NotNull Bytes<?> bytes, @NotNull StringBuilder sb, boolean utf, @NonNegative int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        try {
            assert (utf);
            if ((long)utflen > bytes.readRemaining()) {
                @NotNull BufferUnderflowException bue = new BufferUnderflowException();
                bue.initCause(new IllegalStateException("utflen: " + utflen + ", readRemaining: " + bytes.readRemaining()));
                throw bue;
            }
            long readPosition = bytes.readPosition();
            sb.ensureCapacity(utflen);
            int count = BytesInternal.calculateCount(bytes, sb, utflen, readPosition);
            bytes.readSkip(count);
            StringUtils.setCount((StringBuilder)sb, (int)count);
            if (count < utflen) {
                long rp0 = bytes.readPosition();
                BytesInternal.parseUtf82Guarded(bytes, sb, utf, utflen, count, rp0);
            }
        }
        catch (IOException | IllegalStateException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private static void parseUtf82Guarded(@NotNull Bytes<?> bytes, @NotNull StringBuilder sb, boolean utf, @NonNegative int utflen, int count, long rp0) throws IOException {
        try {
            BytesInternal.parseUtf82(bytes, sb, utf, utflen, count);
        }
        catch (UTFDataFormatRuntimeException e) {
            long rp = Math.max(rp0 - 128L, 0L);
            throw new UTFDataFormatRuntimeException(Long.toHexString(rp0) + "\n" + bytes.toHexString(rp, 200L), (Exception)((Object)e));
        }
    }

    private static int calculateCount(@NotNull Bytes<?> bytes, @NotNull StringBuilder sb, @NonNegative int utflen, @NonNegative long readPosition) {
        int count = 0;
        if (Jvm.isJava9Plus()) {
            byte c;
            sb.setLength(utflen);
            while (count < utflen && (c = bytes.readByte(readPosition + (long)count)) >= 0) {
                sb.setCharAt(count++, (char)c);
            }
        } else {
            byte c;
            char[] chars = StringUtils.extractChars((StringBuilder)sb);
            while (count < utflen && (c = bytes.readByte(readPosition + (long)count)) >= 0) {
                chars[count++] = (char)c;
            }
        }
        return count;
    }

    public static void parseUtf8_SB1(@NotNull NativeBytesStore bytes, @NonNegative long offset, @NotNull StringBuilder sb, @NonNegative int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ObjectUtils.requireNonNull((Object)sb);
        try {
            if (offset + (long)utflen > bytes.realCapacity()) {
                throw new BufferUnderflowException();
            }
            long address = bytes.address + bytes.translate(offset);
            Memory memory = bytes.memory;
            sb.ensureCapacity(utflen);
            int count = 0;
            if (Jvm.isJava9Plus()) {
                byte c;
                sb.setLength(utflen);
                while (count < utflen && (c = memory.readByte(address + (long)count)) >= 0) {
                    sb.setCharAt(count++, (char)c);
                }
            } else {
                byte c;
                char[] chars = StringUtils.extractChars((StringBuilder)sb);
                while (count < utflen && (c = memory.readByte(address + (long)count)) >= 0) {
                    chars[count++] = (char)c;
                }
            }
            StringUtils.setCount((StringBuilder)sb, (int)count);
            if (count < utflen) {
                BytesInternal.parseUtf82(bytes, offset + (long)count, offset + (long)utflen, sb, utflen);
            }
            assert (bytes.memory != null);
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public static int parse8bit_SB1(@NonNegative long offset, @NotNull NativeBytesStore nbs, @NotNull StringBuilder sb, @NonNegative int length) {
        ReferenceCountedUtil.throwExceptionIfReleased(nbs);
        ObjectUtils.requireNonNull((Object)sb);
        long address = nbs.address + nbs.translate(offset);
        @Nullable Memory memory = nbs.memory;
        sb.ensureCapacity(length);
        int count = 0;
        if (Jvm.isJava9Plus()) {
            byte coder = StringUtils.getStringCoder((StringBuilder)sb);
            if (coder == 0) {
                byte[] bytes = StringUtils.extractBytes((StringBuilder)sb);
                while (count < length) {
                    byte b = memory.readByte(address + (long)count);
                    bytes[count++] = b;
                }
            } else {
                assert (coder == 1);
                sb.setLength(length);
                while (count < length) {
                    byte b = memory.readByte(address + (long)count);
                    sb.setCharAt(count++, (char)b);
                }
            }
        } else {
            char[] chars = StringUtils.extractChars((StringBuilder)sb);
            while (count < length) {
                int c = memory.readByte(address + (long)count) & 0xFF;
                chars[count++] = (char)c;
            }
        }
        StringUtils.setCount((StringBuilder)sb, (int)count);
        return count;
    }

    static void parseUtf82(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, boolean utf, @NonNegative int length, @NonNegative int count) throws IOException, UTFDataFormatRuntimeException, IllegalStateException {
        int c;
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        block5: while (count < length && (c = bytes.readUnsignedByte()) >= 0) {
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += utf ? 2 : 1) > length) {
                        throw new UTFDataFormatRuntimeException(MALFORMED_INPUT_PARTIAL_CHARACTER_AT_END);
                    }
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException(MALFORMED_INPUT_AROUND_BYTE + count + WAS + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    if ((count += utf ? 3 : 1) > length) {
                        throw new UTFDataFormatRuntimeException(MALFORMED_INPUT_PARTIAL_CHARACTER_AT_END);
                    }
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw BytesInternal.newUTFDataFormatRuntimeException((long)count - 1L, WAS + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block5;
                }
            }
            throw BytesInternal.newUTFDataFormatRuntimeException(count, "");
        }
    }

    static void parseUtf82(@NotNull RandomDataInput input, @NonNegative long offset, @NonNegative long limit, @NotNull Appendable appendable, @NonNegative int utflen) throws IOException, UTFDataFormatRuntimeException, BufferUnderflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(input);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        block5: while (offset < limit) {
            int c = input.readUnsignedByte(offset++);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2;
                    if (offset == limit) {
                        throw new UTFDataFormatRuntimeException(MALFORMED_INPUT_PARTIAL_CHARACTER_AT_END);
                    }
                    if (((char2 = input.readUnsignedByte(offset++)) & 0xC0) != 128) {
                        throw BytesInternal.newUTFDataFormatRuntimeException(offset - limit + (long)utflen, "was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    if (offset + 2L > limit) {
                        throw new UTFDataFormatRuntimeException(MALFORMED_INPUT_PARTIAL_CHARACTER_AT_END);
                    }
                    int char2 = input.readUnsignedByte(offset++);
                    int char3 = input.readUnsignedByte(offset++);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw BytesInternal.newUTFDataFormatRuntimeException(offset - limit + (long)utflen - 1L, WAS + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block5;
                }
            }
            throw BytesInternal.newUTFDataFormatRuntimeException(offset - limit + (long)utflen, "");
        }
    }

    public static void writeUtf8(@NotNull StreamingDataOutput bytes, @Nullable String str) throws BufferOverflowException, IllegalStateException, IllegalArgumentException, BufferUnderflowException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        if (str == null) {
            BytesInternal.writeStopBitNeg1(bytes);
            return;
        }
        if (Jvm.isJava9Plus()) {
            byte[] strBytes = StringUtils.extractBytes((String)str);
            byte coder = StringUtils.getStringCoder((String)str);
            long utfLength = AppendableUtil.findUtf8Length(strBytes, coder);
            bytes.writeStopBit(utfLength);
            bytes.appendUtf8(strBytes, 0, str.length(), coder);
        } else {
            char[] chars = StringUtils.extractChars((String)str);
            long utfLength = AppendableUtil.findUtf8Length(chars);
            bytes.writeStopBit(utfLength);
            bytes.appendUtf8(chars, 0, chars.length);
        }
    }

    public static void writeUtf8(@NotNull StreamingDataOutput bytes, @Nullable CharSequence str) throws BufferOverflowException, IllegalStateException, BufferUnderflowException, IllegalArgumentException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        if (str instanceof String) {
            BytesInternal.writeUtf8(bytes, (String)str);
            return;
        }
        if (str == null) {
            BytesInternal.writeStopBitNeg1(bytes);
        } else {
            long utfLength = AppendableUtil.findUtf8Length(str);
            bytes.writeStopBit(utfLength);
            BytesInternal.appendUtf8(bytes, str, 0, str.length());
        }
    }

    public static long writeUtf8(@NotNull RandomDataOutput out, @NonNegative long writeOffset, @Nullable CharSequence str) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        ReferenceCountedUtil.throwExceptionIfReleased(out);
        Longs.requireNonNegative((long)writeOffset);
        if (str == null) {
            writeOffset = BytesInternal.writeStopBit(out, writeOffset, -1L);
        } else {
            int strLength = str.length();
            if (strLength < 32) {
                long lenOffset = writeOffset;
                writeOffset = BytesInternal.appendUtf8(out, writeOffset + 1L, str, 0, strLength);
                long utfLength = writeOffset - lenOffset - 1L;
                assert (utfLength <= 127L);
                BytesInternal.writeStopBit(out, lenOffset, utfLength);
            } else {
                long utfLength = AppendableUtil.findUtf8Length(str);
                writeOffset = BytesInternal.writeStopBit(out, writeOffset, utfLength);
                if (utfLength == (long)strLength) {
                    BytesInternal.append8bit(writeOffset, out, str, 0, strLength);
                    writeOffset += utfLength;
                } else {
                    writeOffset = BytesInternal.appendUtf8(out, writeOffset, str, 0, strLength);
                }
            }
        }
        return writeOffset;
    }

    public static long writeUtf8(@NotNull RandomDataOutput out, @NonNegative long offset, @Nullable CharSequence str, @NonNegative int maxUtf8Len) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        Longs.requireNonNegative((long)offset);
        ReferenceCountedUtil.throwExceptionIfReleased(out);
        if (str == null) {
            offset = BytesInternal.writeStopBit(out, offset, -1L);
        } else {
            int strLength = str.length();
            long utfLength = AppendableUtil.findUtf8Length(str);
            if (utfLength > (long)maxUtf8Len) {
                throw new IllegalArgumentException("Attempted to write a char sequence of utf8 size " + utfLength + ": \"" + str + "\", when only " + maxUtf8Len + " allowed");
            }
            offset = BytesInternal.writeStopBit(out, offset, utfLength);
            if (utfLength == (long)strLength) {
                BytesInternal.append8bit(offset, out, str, 0, strLength);
                offset += utfLength;
            } else {
                offset = BytesInternal.appendUtf8(out, offset, str, 0, strLength);
            }
        }
        return offset;
    }

    @NotNull
    public static Bytes<?> asBytes(@NotNull RandomDataOutput bytes, @NonNegative long position, @NonNegative long limit) throws IllegalStateException, BufferOverflowException, BufferUnderflowException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Bytes<?> sbytes = bytes.bytesForWrite();
        sbytes.writeLimit(limit);
        sbytes.readLimit(limit);
        sbytes.readPosition(position);
        return sbytes;
    }

    public static void appendUtf8(@NotNull StreamingDataOutput bytes, @NotNull CharSequence str, @NonNegative int offset, @NonNegative int length) throws IndexOutOfBoundsException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(str);
        try {
            char c;
            int i;
            for (i = 0; i < length && (c = str.charAt(offset + i)) <= '\u007f'; ++i) {
                bytes.rawWriteByte((byte)c);
            }
            BytesInternal.appendUtf82(bytes, str, offset, length, i);
        }
        catch (IllegalStateException | BufferOverflowException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private static void appendUtf82(@NotNull StreamingDataOutput bytes, @NotNull CharSequence str, @NonNegative int offset, @NonNegative int length, @NonNegative int i) throws IndexOutOfBoundsException, BufferOverflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(str);
        while (i < length) {
            char c = str.charAt(offset + i);
            BytesInternal.appendUtf8Char(bytes, c);
            ++i;
        }
    }

    public static long appendUtf8(@NotNull RandomDataOutput out, @NonNegative long outOffset, @NotNull CharSequence str, @NonNegative int strOffset, @NonNegative int length) throws IndexOutOfBoundsException, BufferOverflowException, IllegalStateException {
        char c;
        int i;
        ReferenceCountedUtil.throwExceptionIfReleased(out);
        ReferenceCountedUtil.throwExceptionIfReleased(str);
        for (i = 0; i < length && (c = str.charAt(strOffset + i)) <= '\u007f'; ++i) {
            out.writeByte(outOffset++, (byte)c);
        }
        return BytesInternal.appendUtf82(out, outOffset, str, strOffset, length, i);
    }

    private static long appendUtf82(@NotNull RandomDataOutput out, @NonNegative long outOffset, @NotNull CharSequence str, @NonNegative int strOffset, @NonNegative int length, @NonNegative int i) throws IndexOutOfBoundsException, BufferOverflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(out);
        ReferenceCountedUtil.throwExceptionIfReleased(str);
        while (i < length) {
            char c = str.charAt(strOffset + i);
            outOffset = BytesInternal.appendUtf8Char(out, outOffset, c);
            ++i;
        }
        return outOffset;
    }

    public static void append8bit(@NonNegative long offsetInRDO, RandomDataOutput bytes, @NotNull CharSequence str, @NonNegative int offset, @NonNegative int length) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, IllegalStateException, ArithmeticException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(str);
        if (bytes instanceof VanillaBytes) {
            @NotNull VanillaBytes vb = (VanillaBytes)bytes;
            if (str instanceof RandomDataInput) {
                vb.write(offsetInRDO, (RandomDataInput)((Object)str), (long)offset, (long)length);
                return;
            }
            if (str instanceof String) {
                vb.write(offsetInRDO, str, offset, length);
                return;
            }
        }
        for (int i = 0; i < length; ++i) {
            int c = str.charAt(offset + i);
            if (c > 255) {
                c = 63;
            }
            bytes.writeUnsignedByte(offsetInRDO + (long)i, c);
        }
    }

    public static void appendUtf8Char(@NotNull StreamingDataOutput bytes, int c) throws BufferOverflowException, IllegalStateException {
        if (c <= 127) {
            bytes.rawWriteByte((byte)c);
        } else if (c <= 2047) {
            bytes.rawWriteByte((byte)(0xC0 | c >> 6 & 0x1F));
            bytes.rawWriteByte((byte)(0x80 | c & 0x3F));
        } else if (c <= 65535) {
            bytes.rawWriteByte((byte)(0xE0 | c >> 12 & 0xF));
            bytes.rawWriteByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.rawWriteByte((byte)(0x80 | c & 0x3F));
        } else {
            bytes.rawWriteByte((byte)(0xF0 | c >> 18 & 7));
            bytes.rawWriteByte((byte)(0x80 | c >> 12 & 0x3F));
            bytes.rawWriteByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.rawWriteByte((byte)(0x80 | c & 0x3F));
        }
    }

    public static long appendUtf8Char(@NotNull RandomDataOutput out, @NonNegative long offset, int c) throws BufferOverflowException, IllegalStateException {
        if (c <= 127) {
            out.writeByte(offset++, (byte)c);
        } else if (c <= 2047) {
            out.writeByte(offset++, (byte)(0xC0 | c >> 6 & 0x1F));
            out.writeByte(offset++, (byte)(0x80 | c & 0x3F));
        } else if (c <= 65535) {
            out.writeByte(offset++, (byte)(0xE0 | c >> 12 & 0xF));
            out.writeByte(offset++, (byte)(0x80 | c >> 6 & 0x3F));
            out.writeByte(offset++, (byte)(0x80 | c & 0x3F));
        } else {
            out.writeByte(offset++, (byte)(0xF0 | c >> 18 & 7));
            out.writeByte(offset++, (byte)(0x80 | c >> 12 & 0x3F));
            out.writeByte(offset++, (byte)(0x80 | c >> 6 & 0x3F));
            out.writeByte(offset++, (byte)(0x80 | c & 0x3F));
        }
        return offset;
    }

    public static void writeStopBitNeg1(@NotNull StreamingDataOutput out) {
        out.writeUnsignedShort(NEG_ONE);
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, char n) throws BufferOverflowException, IllegalStateException {
        if ((n & 0xFFFFFF80) == 0) {
            out.rawWriteByte((byte)(n & 0x7F));
            return;
        }
        if ((n & 0xFFFFC000) == 0) {
            out.rawWriteByte((byte)(n & 0x7F | 0x80));
            out.rawWriteByte((byte)(n >> 7));
            return;
        }
        if ((n & 0xFF80) == 65408) {
            out.rawWriteByte((byte)(~n & 0x7F | 0x80));
            out.rawWriteByte((byte)0);
            return;
        }
        BytesInternal.writeStopBit0(out, (long)n);
    }

    public static long writeStopBit(long addr, long n) throws BufferOverflowException, IllegalStateException {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            UnsafeMemory.INSTANCE.writeByte(addr, (byte)n);
            return addr + 1L;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            int lo = (int)(n & 0x7FL | 0x80L);
            int hi = (int)(n >> 7);
            UnsafeMemory.INSTANCE.writeByte(addr, (byte)lo);
            UnsafeMemory.INSTANCE.writeByte(addr + 1L, (byte)hi);
            return addr + 2L;
        }
        return BytesInternal.writeStopBit0(addr, n);
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, long n) throws BufferOverflowException, IllegalStateException {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.rawWriteByte((byte)n);
            return;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            out.rawWriteByte((byte)(n & 0x7FL | 0x80L));
            out.rawWriteByte((byte)(n >> 7));
            return;
        }
        BytesInternal.writeStopBit0(out, n);
    }

    public static long writeStopBit(@NotNull RandomDataOutput out, @NonNegative long offset, long n) throws BufferOverflowException, IllegalStateException {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.writeByte(offset++, (byte)n);
            return offset;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            out.writeByte(offset++, (byte)(n & 0x7FL | 0x80L));
            out.writeByte(offset++, (byte)(n >> 7));
            return offset;
        }
        return BytesInternal.writeStopBit0(out, offset, n);
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, double d) throws BufferOverflowException, IllegalStateException {
        long n = Double.doubleToRawLongBits(d);
        while ((n & 0x1FFFFFFFFFFFFFFL) != 0L) {
            out.rawWriteByte((byte)(n >>> -7 & 0x7FL | 0x80L));
            n <<= 7;
        }
        out.rawWriteByte((byte)(n >>> -7 & 0x7FL));
    }

    public static double readStopBitDouble(@NotNull StreamingDataInput in) throws IllegalStateException {
        byte b;
        long n = 0L;
        int shift = 57;
        do {
            b = in.readByte();
            n |= shift > 0 ? (long)(b & 0x7F) << shift : (long)(b >> -shift);
            shift -= 7;
        } while (b < 0);
        return Double.longBitsToDouble(n);
    }

    public static void writeStopBit0(@NotNull StreamingDataOutput out, long n) throws BufferOverflowException, IllegalStateException {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            out.rawWriteByte((byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            out.rawWriteByte((byte)n);
        } else {
            out.rawWriteByte((byte)(0x80L | n));
            out.rawWriteByte((byte)0);
        }
    }

    static long writeStopBit0(long addr, long n) throws BufferOverflowException, IllegalStateException {
        long n2;
        int i = 0;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            UnsafeMemory.MEMORY.writeByte(addr + (long)i++, (byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            UnsafeMemory.MEMORY.writeByte(addr + (long)i++, (byte)n);
        } else {
            UnsafeMemory.MEMORY.writeByte(addr + (long)i++, (byte)(0x80L | n));
            UnsafeMemory.MEMORY.writeByte(addr + (long)i++, (byte)0);
        }
        return addr + (long)i;
    }

    static long writeStopBit0(@NotNull RandomDataOutput out, @NonNegative long offset, long n) throws BufferOverflowException, IllegalStateException {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            out.writeByte(offset++, (byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            out.writeByte(offset++, (byte)n);
        } else {
            out.writeByte(offset++, (byte)(0x80L | n));
            out.writeByte(offset++, (byte)0);
        }
        return offset;
    }

    public static int stopBitLength0(long n) {
        int len = 0;
        if (n < 0L) {
            len = 1;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n >>>= 7) != 0L) {
            ++len;
        }
        return len + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDebugString(@NotNull RandomDataInput bytes, @NonNegative long maxLength) throws IllegalStateException, ArithmeticException {
        if (bytes.refCount() < 1) {
            return "<released>";
        }
        ReferenceOwner toDebugString = ReferenceOwner.temporary((String)"toDebugString");
        bytes.reserve(toDebugString);
        try {
            int len = Maths.toUInt31((long)(maxLength + 40L));
            @NotNull StringBuilder sb = new StringBuilder(len);
            long readPosition = bytes.readPosition();
            long readLimit = bytes.readLimit();
            if (bytes instanceof HexDumpBytes) {
                readPosition = (int)readPosition;
                readLimit = (int)readLimit;
            }
            sb.append("[").append("pos: ").append(readPosition).append(", rlim: ").append(readLimit).append(", wlim: ").append(BytesInternal.asSize(bytes.writeLimit())).append(", cap: ").append(BytesInternal.asSize(bytes.capacity())).append(" ] ");
            BytesInternal.appendContent(bytes, maxLength, sb, readPosition, readLimit);
            String string = sb.toString();
            return string;
        }
        finally {
            bytes.release(toDebugString);
        }
    }

    private static void appendContent(@NotNull RandomDataInput bytes, @NonNegative long maxLength, @NotNull StringBuilder sb, @NonNegative long readPosition, @NonNegative long readLimit) {
        try {
            long start = Math.max(bytes.start(), readPosition - 64L);
            long end = Math.min(readLimit + 64L, start + maxLength);
            try {
                for (end = Math.min(end, bytes.realCapacity()); end >= start + 16L && end >= readLimit + 16L && bytes.readLong(end - 8L) == 0L; end -= 8L) {
                }
            }
            catch (UnsupportedOperationException | BufferUnderflowException runtimeException) {
                // empty catch block
            }
            BytesInternal.toString(bytes, sb, start, readPosition, readLimit, end);
            if (end < bytes.readLimit()) {
                sb.append("...");
            }
        }
        catch (Exception e) {
            sb.append(' ').append(e);
        }
    }

    @NotNull
    public static Object asSize(@NonNegative long size) {
        return size == 0x7FFFFFFFFFFFFFF0L ? "8EiB" : Long.valueOf(size);
    }

    public static String to8bitString(@NotNull BytesStore bytes) {
        long pos = bytes.readPosition();
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        int len = (int)Math.min(Integer.MAX_VALUE, bytes.readRemaining());
        char[] chars = new char[len];
        if (bytes instanceof VanillaBytes) {
            try {
                ((VanillaBytes)bytes).read8Bit(chars, len);
            }
            catch (IllegalStateException | BufferUnderflowException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                try {
                    chars[i] = (char)bytes.readUnsignedByte(pos + (long)i);
                    continue;
                }
                catch (Exception e) {
                    return new String(chars, 0, len) + ' ' + e;
                }
            }
        }
        return StringUtils.newString((char[])chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String toString(@NotNull RandomDataInput bytes) {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        try {
            long available = bytes.realReadRemaining();
            int size = (int)Math.min(available, (long)MAX_STRING_LEN - 3L);
            @NotNull StringBuilder sb = new StringBuilder(size);
            if (bytes.readRemaining() <= (long)size) {
                BytesInternal.toString(bytes, sb);
                return sb.toString();
            }
            Bytes<?> bytes1 = bytes.bytesForRead();
            try {
                bytes1.readLimit(bytes1.readPosition() + (long)size);
                BytesInternal.toString(bytes1, sb);
                if ((long)size < available) {
                    sb.append("...");
                }
                String string = sb.toString();
                return string;
            }
            finally {
                bytes1.releaseLast();
            }
        }
        catch (IllegalStateException | BufferUnderflowException e) {
            return e.toString();
        }
    }

    private static void toString(@NotNull RandomDataInput bytes, @NotNull Appendable sb, @NonNegative long start, @NonNegative long readPosition, @NonNegative long writePosition, @NonNegative long end) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(sb);
        try {
            boolean showStartEnd;
            long realCapacity;
            if (start < bytes.start()) {
                start = bytes.start();
            }
            if (end > (realCapacity = bytes.realCapacity())) {
                end = realCapacity;
            }
            boolean bl = showStartEnd = bytes instanceof Bytes && writePosition < end;
            if (readPosition >= start && showStartEnd) {
                long last = Math.min(readPosition, end);
                BytesInternal.toString(bytes, sb, start, last);
                sb.append('\u01c1');
            }
            BytesInternal.toString(bytes, sb, Math.max(readPosition, start), Math.min(writePosition, end));
            if (writePosition <= end) {
                if (showStartEnd) {
                    sb.append('\u2021');
                }
                BytesInternal.toString(bytes, sb, writePosition, end);
            }
        }
        catch (Exception e) {
            try {
                sb.append(' ').append(e.toString());
            }
            catch (IOException e1) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void toString(@NotNull RandomDataInput bytes, @NotNull Appendable sb, @NonNegative long start, @NonNegative long last) throws IOException, BufferUnderflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(sb);
        for (long i = start; i < last; ++i) {
            sb.append(bytes.printable(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toString(@NotNull RandomDataInput bytes, @NotNull StringBuilder sb) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ObjectUtils.requireNonNull((Object)sb);
        ReferenceOwner toString = ReferenceOwner.temporary((String)"toString");
        bytes.reserve(toString);
        long start = bytes.readPosition();
        assert (bytes.start() <= start);
        assert (start <= bytes.readLimit());
        int length = Math.toIntExact(bytes.realReadRemaining());
        try {
            for (int i = 0; i < length; ++i) {
                sb.append((char)bytes.readUnsignedByte(start + (long)i));
            }
        }
        catch (BufferUnderflowException e) {
            sb.append(' ').append(e);
        }
        finally {
            bytes.release(toString);
        }
    }

    public static char readStopBitChar(@NotNull StreamingDataInput in) throws IORuntimeException, IllegalStateException {
        byte b = in.rawReadByte();
        if (b >= 0) {
            return (char)b;
        }
        if (b == -128 && in.peekUnsignedByte() == 0) {
            in.readSkip(1L);
            return '\uffff';
        }
        return (char)BytesInternal.readStopBit0(in, b);
    }

    public static long readStopBit(@NotNull StreamingDataInput in) throws IORuntimeException, IllegalStateException {
        byte b = in.rawReadByte();
        if (b >= 0) {
            return b;
        }
        if (b == -128 && in.peekUnsignedByte() == 0) {
            in.readSkip(1L);
            return -1L;
        }
        return BytesInternal.readStopBit0(in, b);
    }

    public static long readStopBit0(@NotNull StreamingDataInput in, long l) throws IORuntimeException, IllegalStateException {
        long b;
        l &= 0x7FL;
        int count = 7;
        while ((b = (long)in.rawReadByte()) < 0L) {
            l |= (b & 0x7FL) << count;
            count += 7;
        }
        if (b != 0L) {
            if (count > 56) {
                throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
            }
            return l | b << count;
        }
        if (count > 63) {
            throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
        }
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void append(@NotNull ByteStringAppender out, long num, int base) throws IllegalArgumentException, BufferOverflowException, IllegalStateException, IndexOutOfBoundsException {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                if (base == 10) {
                    out.write(MIN_VALUE_TEXT);
                } else {
                    out.write(Long.toString(Long.MIN_VALUE, base));
                }
                return;
            }
            out.rawWriteByte((byte)45);
            num = -num;
        }
        if (num == 0L) {
            out.rawWriteByte((byte)48);
        } else {
            switch (base) {
                case 10: {
                    BytesInternal.appendBase10(out, num);
                    break;
                }
                case 16: {
                    BytesInternal.appendBase16(out, num, 1);
                    break;
                }
                default: {
                    out.write(Long.toString(num, base));
                }
            }
        }
    }

    public static void appendBase10(@NotNull ByteStringAppender out, int num) throws BufferOverflowException, IllegalStateException {
        BytesInternal.appendBase10(out, (long)num);
    }

    public static void appendBase10(@NotNull ByteStringAppender out, long num) throws BufferOverflowException, IllegalStateException {
        if (out.canWriteDirect(20L)) {
            long address = out.addressForWrite(out.writePosition());
            long address2 = UnsafeText.appendFixed((long)address, (long)num);
            out.writeSkip(address2 - address);
        } else {
            BytesInternal.appendLong0(out, num);
        }
    }

    public static void appendBase16(@NotNull ByteStringAppender out, long num, int minDigits) throws IllegalArgumentException, BufferOverflowException, IllegalStateException {
        byte[] numberBuffer = out.internalNumberBuffer();
        int len = 0;
        do {
            int digit = (int)(num & 0xFL);
            numberBuffer[len++] = (byte)HEXADECIMAL[digit];
        } while (--minDigits > 0 || (num >>>= 4) > 0L);
        for (int i = len - 1; i >= 0; --i) {
            out.rawWriteByte(numberBuffer[i]);
        }
    }

    public static void appendDecimal(@NotNull ByteStringAppender out, long num, int decimalPlaces) throws BufferOverflowException, IllegalStateException, ArithmeticException, IllegalArgumentException {
        int endIndex;
        if (decimalPlaces == 0) {
            BytesInternal.appendBase10(out, num);
            return;
        }
        byte[] numberBuffer = out.internalNumberBuffer();
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                numberBuffer = MIN_VALUE_TEXT;
                endIndex = MIN_VALUE_TEXT.length;
            } else {
                out.rawWriteByte((byte)45);
                num = -num;
                endIndex = BytesInternal.appendLong1(numberBuffer, num);
            }
        } else {
            endIndex = BytesInternal.appendLong1(numberBuffer, num);
        }
        int digits = numberBuffer.length - endIndex;
        if (decimalPlaces >= digits) {
            out.writeUnsignedByte(48);
            out.writeUnsignedByte(46);
            while (decimalPlaces-- > digits) {
                out.writeUnsignedByte(48);
            }
            out.write(numberBuffer, endIndex, digits);
            return;
        }
        int decimalLength = numberBuffer.length - endIndex - decimalPlaces;
        out.write(numberBuffer, endIndex, decimalLength);
        out.writeUnsignedByte(46);
        out.write(numberBuffer, endIndex + decimalLength, digits - decimalLength);
    }

    public static void prepend(@NotNull BytesPrepender out, long num) throws BufferOverflowException, IllegalStateException {
        boolean neg = false;
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                out.prewrite(MIN_VALUE_TEXT);
                return;
            }
            neg = true;
            num = -num;
        }
        do {
            out.prewriteByte((byte)(num % 10L + 48L));
        } while ((num /= 10L) > 0L);
        if (neg) {
            out.prewriteByte((byte)45);
        }
    }

    public static void append(@NotNull RandomDataOutput out, @NonNegative long offset, long num, int digits) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        boolean negative = num < 0L;
        num = Math.abs(num);
        for (int i = digits - 1; i > 0; --i) {
            out.writeByte(offset + (long)i, (byte)(num % 10L + 48L));
            num /= 10L;
        }
        if (negative) {
            if (num != 0L) {
                BytesInternal.numberTooLarge(digits);
            }
            out.writeByte(offset, (byte)45);
        } else {
            if (num > 9L) {
                BytesInternal.numberTooLarge(digits);
            }
            out.writeByte(offset, (byte)(num % 10L + 48L));
        }
    }

    public static void appendDecimal(@NotNull RandomDataOutput out, long num, @NonNegative long offset, int decimalPlaces, int width) throws IORuntimeException, IllegalArgumentException, BufferOverflowException, ArithmeticException, IllegalStateException {
        int endIndex;
        if (decimalPlaces == 0) {
            BytesInternal.append(out, offset, num, width);
            return;
        }
        byte[] numberBuffer = out.internalNumberBuffer();
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                numberBuffer = MIN_VALUE_TEXT;
                endIndex = MIN_VALUE_TEXT.length;
            } else {
                out.writeByte(offset++, (byte)45);
                num = -num;
                endIndex = BytesInternal.appendLong1(numberBuffer, num);
            }
        } else {
            endIndex = BytesInternal.appendLong1(numberBuffer, num);
        }
        int digits = numberBuffer.length - endIndex;
        if (decimalPlaces >= digits) {
            int numDigitsRequired = 2 + decimalPlaces;
            if (numDigitsRequired > width) {
                throw new IllegalArgumentException("Value do not fit in " + width + " digits");
            }
            out.writeUnsignedByte(offset++, 48);
            out.writeUnsignedByte(offset++, 46);
            while (decimalPlaces-- > digits) {
                out.writeUnsignedByte(offset++, 48);
            }
            out.write(offset, numberBuffer, endIndex, digits);
            return;
        }
        int numDigitsRequired = digits + 1;
        if (numDigitsRequired > width) {
            throw new IllegalArgumentException("Value do not fit in " + width + " digits");
        }
        while (width-- > digits + 1) {
            out.writeUnsignedByte(offset++, 48);
        }
        int decimalLength = numberBuffer.length - endIndex - decimalPlaces;
        out.write(offset, numberBuffer, endIndex, decimalLength);
        offset += (long)decimalLength;
        out.writeUnsignedByte(offset++, 46);
        out.write(offset, numberBuffer, endIndex + decimalLength, digits - decimalLength);
    }

    private static void numberTooLarge(int digits) throws IllegalArgumentException {
        throw new IllegalArgumentException("Number too large for " + digits + "digits");
    }

    private static void appendLong0(@NotNull StreamingDataOutput out, long num) throws BufferOverflowException, IllegalStateException {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                out.write(MIN_VALUE_TEXT);
                return;
            }
            out.rawWriteByte((byte)45);
            num = -num;
        }
        if (num < 10L) {
            out.rawWriteByte((byte)(48L + num));
        } else if (num < 100L) {
            out.writeShort((short)(num / 10L + (num % 10L << 8) + 12336L));
        } else {
            byte[] numberBuffer = out.internalNumberBuffer();
            int endIndex = BytesInternal.appendLong1(numberBuffer, num);
            out.write(numberBuffer, endIndex, numberBuffer.length - endIndex);
        }
    }

    private static int appendLong1(byte[] numberBuffer, long num) {
        numberBuffer[19] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 19;
        }
        numberBuffer[18] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 18;
        }
        numberBuffer[17] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 17;
        }
        numberBuffer[16] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 16;
        }
        numberBuffer[15] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 15;
        }
        numberBuffer[14] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 14;
        }
        numberBuffer[13] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 13;
        }
        numberBuffer[12] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 12;
        }
        numberBuffer[11] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 11;
        }
        numberBuffer[10] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 10;
        }
        numberBuffer[9] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 9;
        }
        numberBuffer[8] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 8;
        }
        numberBuffer[7] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 7;
        }
        numberBuffer[6] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 6;
        }
        numberBuffer[5] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 5;
        }
        numberBuffer[4] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 4;
        }
        numberBuffer[3] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 3;
        }
        numberBuffer[2] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 2;
        }
        numberBuffer[1] = (byte)(num % 10L + 48L);
        return 1;
    }

    public static void append(@NotNull StreamingDataOutput out, double d) throws BufferOverflowException, IllegalStateException {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            out.rawWriteByte((byte)45);
        }
        if (exp == 0 && mantissa == 0L) {
            out.rawWriteByte((byte)48);
            out.rawWriteByte((byte)46);
            out.rawWriteByte((byte)48);
            return;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                out.write(INFINITY_BYTES);
            } else {
                out.write(NAN_BYTES);
            }
            return;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                BytesInternal.appendLong0(out, intValue);
                if ((mantissa -= intValue << shift) > 0L) {
                    long num;
                    out.rawWriteByte((byte)46);
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long value = intValue;
                    int decimalPlaces = 0;
                    for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                        int deci;
                        num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        out.rawWriteByte((byte)(48L + num));
                        double parsedValue = Maths.asDouble((long)value, (int)0, (sign != 0 ? 1 : 0) != 0, (int)(deci = ++decimalPlaces));
                        if (parsedValue != d) continue;
                        break;
                    }
                } else {
                    out.rawWriteByte((byte)46);
                    out.rawWriteByte((byte)48);
                }
                return;
            }
            out.rawWriteByte((byte)48);
            out.rawWriteByte((byte)46);
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long value = 0L;
            int decimalPlaces = 0;
            for (long error = 32L; mantissa > error; error *= 5L) {
                int deci;
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    out.rawWriteByte((byte)48);
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                out.rawWriteByte((byte)c);
                mantissa -= num << precision;
                double parsedValue = Maths.asDouble((long)value, (int)0, (sign != 0 ? 1 : 0) != 0, (int)(deci = ++decimalPlaces));
                if (parsedValue != d) continue;
                break;
            }
            return;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        BytesInternal.appendLong0(out, val2);
        for (int i = 0; i < digits; ++i) {
            out.rawWriteByte((byte)48);
        }
    }

    public static void append(@NotNull ByteStringAppender bytesStringAppender, double d, int decimalPlaces) throws BufferOverflowException, IllegalArgumentException, IllegalStateException, ArithmeticException {
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException();
        }
        if (decimalPlaces < 18) {
            long factor = Maths.tens((int)decimalPlaces);
            double d1 = d;
            boolean neg = d1 < 0.0;
            double df = (d1 = Math.abs(d1)) * (double)factor;
            if (df < 9.223372036854776E18) {
                long ldf = (long)df;
                double residual = df - (double)ldf + Math.ulp(d1) * ((double)factor * 0.983);
                if (residual >= 0.5) {
                    ++ldf;
                }
                if (neg) {
                    ldf = -ldf;
                }
                long round = ldf;
                if (bytesStringAppender.canWriteDirect(20L + (long)decimalPlaces)) {
                    long address = bytesStringAppender.addressForWritePosition();
                    long address2 = UnsafeText.appendBase10d((long)address, (long)round, (int)decimalPlaces);
                    bytesStringAppender.writeSkip(address2 - address);
                } else {
                    bytesStringAppender.appendDecimal(round, decimalPlaces);
                }
                return;
            }
        }
        bytesStringAppender.append(d);
    }

    @Nullable
    public static String readUtf8(@NotNull StreamingDataInput in) throws BufferUnderflowException, IORuntimeException, IllegalStateException, ArithmeticException {
        RandomDataInput rdi;
        ReferenceCountedUtil.throwExceptionIfReleased(in);
        if (in.peekUnsignedByte() == 128 && in instanceof RandomDataInput && (rdi = (RandomDataInput)((Object)in)).peekUnsignedByte(in.readPosition() + 1L) == 0) {
            in.readSkip(2L);
            return null;
        }
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        return in.readUtf8(sb) ? SI.intern(sb) : null;
    }

    @Nullable
    public static String readUtf8(@NotNull RandomDataInput in, @NonNegative long offset, @NonNegative int maxUtf8Len) throws BufferUnderflowException, IllegalArgumentException, IllegalStateException, IORuntimeException {
        ReferenceCountedUtil.throwExceptionIfReleased(in);
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        return in.readUtf8Limited(offset, sb, maxUtf8Len) > 0L ? SI.intern(sb) : null;
    }

    public static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    public static Bytes<?> acquireBytes() {
        return BP.acquireBytes();
    }

    @Nullable
    public static String read8bit(@NotNull StreamingDataInput in) throws BufferUnderflowException, IORuntimeException, ArithmeticException, IllegalStateException {
        RandomDataInput rdi;
        ReferenceCountedUtil.throwExceptionIfReleased(in);
        if (in.peekUnsignedByte() == 128 && in instanceof RandomDataInput && (rdi = (RandomDataInput)((Object)in)).peekUnsignedByte(in.readPosition() + 1L) == 0) {
            in.readSkip(2L);
            return null;
        }
        Bytes<?> bytes = BytesInternal.acquireBytes();
        return in.read8bit(bytes) ? SI.intern(bytes, (int)bytes.readRemaining()) : null;
    }

    @Nullable
    public static String parseUtf8(@NotNull StreamingDataInput bytes, @NotNull StopCharTester tester) throws IllegalStateException, ArithmeticException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ObjectUtils.requireNonNull((Object)tester);
        StringBuilder utfReader = BytesInternal.acquireStringBuilder();
        BytesInternal.parseUtf8(bytes, (Appendable)utfReader, tester);
        return SI.intern(utfReader);
    }

    public static void parseUtf8(@NotNull StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharTester tester) throws BufferUnderflowException, IllegalStateException, ArithmeticException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(builder);
        ObjectUtils.requireNonNull((Object)tester);
        try {
            if (builder instanceof StringBuilder && bytes.isDirectMemory()) {
                @NotNull Bytes vb = (Bytes)bytes;
                @NotNull StringBuilder sb = (StringBuilder)builder;
                sb.setLength(0);
                BytesInternal.readUtf8_SB1(vb, sb, tester);
            } else {
                AppendableUtil.setLength(builder, 0);
                BytesInternal.readUtf81(bytes, builder, tester);
            }
        }
        catch (UTFDataFormatException e) {
            @NotNull UTFDataFormatRuntimeException e2 = new UTFDataFormatRuntimeException("Unable to parse invalid UTF-8 code", e);
            throw e2;
        }
        catch (IOException | IllegalArgumentException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private static void readUtf8_SB1(@NotNull Bytes<?> bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws IOException, IllegalStateException {
        int i;
        @Nullable NativeBytesStore nb = (NativeBytesStore)bytes.bytesStore();
        int len = Math.toIntExact(bytes.realReadRemaining());
        long address = nb.address + nb.translate(bytes.readPosition());
        @Nullable Memory memory = nb.memory;
        if (Jvm.isJava9Plus()) {
            byte c;
            int appendableLength = appendable.capacity();
            for (i = 0; i < len && i < appendableLength && (c = memory.readByte(address + (long)i)) >= 0; ++i) {
                if (tester.isStopChar(c)) {
                    bytes.readSkip((long)i + 1L);
                    StringUtils.setCount((StringBuilder)appendable, (int)i);
                    return;
                }
                appendable.append((char)c);
            }
        } else {
            byte c;
            char[] chars = StringUtils.extractChars((StringBuilder)appendable);
            while (i < len && i < chars.length && (c = memory.readByte(address + (long)i)) >= 0) {
                if (tester.isStopChar(c)) {
                    bytes.readSkip((long)i + 1L);
                    StringUtils.setCount((StringBuilder)appendable, (int)i);
                    return;
                }
                chars[i] = (char)c;
                ++i;
            }
        }
        StringUtils.setCount((StringBuilder)appendable, (int)i);
        bytes.readSkip(i);
        if (i < len) {
            BytesInternal.readUtf8_SB2(bytes, appendable, tester);
        }
    }

    private static void readUtf8_SB2(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws UTFDataFormatException, IllegalStateException {
        block5: while (true) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw BytesInternal.newUTFDataFormatException(-1L, "");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw BytesInternal.newUTFDataFormatException(-1L, "");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block5;
                }
            }
            break;
        }
        throw BytesInternal.newUTFDataFormatException(-1L, "");
    }

    private static UTFDataFormatException newUTFDataFormatException(@NonNegative long offset, String suffix) {
        return new UTFDataFormatException(MALFORMED_INPUT_AROUND_BYTE + offset + " " + suffix);
    }

    private static UTFDataFormatRuntimeException newUTFDataFormatRuntimeException(@NonNegative long offset, String suffix) {
        return new UTFDataFormatRuntimeException(MALFORMED_INPUT_AROUND_BYTE + offset + " " + suffix);
    }

    private static void readUtf81(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException, BufferUnderflowException, ArithmeticException, IllegalStateException {
        int len = Maths.toInt32((long)bytes.readRemaining());
        while (len-- > 0) {
            int c = bytes.rawReadByte() & 0xFF;
            if (c >= 128) {
                bytes.readSkip(-1L);
                break;
            }
            if (tester.isStopChar(c)) {
                return;
            }
            appendable.append((char)c);
        }
        if (len <= 0) {
            return;
        }
        BytesInternal.readUtf82(bytes, appendable, tester);
    }

    private static void readUtf82(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException, IllegalStateException {
        block5: while (true) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException(MALFORMED_INPUT_AROUND_BYTE);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block5;
                }
            }
            break;
        }
        throw new UTFDataFormatException(MALFORMED_INPUT_AROUND_BYTE);
    }

    public static void parseUtf8(@NotNull StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharsTester tester) throws BufferUnderflowException, IORuntimeException, IllegalStateException {
        try {
            AppendableUtil.setLength(builder, 0);
            AppendableUtil.readUtf8AndAppend(bytes, builder, tester);
        }
        catch (IOException | IllegalArgumentException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull StringBuilder builder, @NotNull StopCharsTester tester) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ObjectUtils.requireNonNull((Object)builder);
        ObjectUtils.requireNonNull((Object)tester);
        builder.setLength(0);
        AppendableUtil.read8bitAndAppend(bytes, builder, tester);
    }

    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull Bytes<?> builder, @NotNull StopCharsTester tester) throws BufferUnderflowException, BufferOverflowException, IllegalStateException, ArithmeticException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(builder);
        ObjectUtils.requireNonNull((Object)tester);
        builder.readPosition(0L);
        BytesInternal.read8bitAndAppend(bytes, builder, tester);
    }

    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull StringBuilder builder, @NotNull StopCharTester tester) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ObjectUtils.requireNonNull((Object)tester);
        builder.setLength(0);
        BytesInternal.read8bitAndAppend(bytes, builder, tester);
    }

    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull Bytes<?> builder, @NotNull StopCharTester tester) throws BufferUnderflowException, BufferOverflowException, IllegalStateException, ArithmeticException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(builder);
        ObjectUtils.requireNonNull((Object)tester);
        builder.clear();
        BytesInternal.read8bitAndAppend(bytes, builder, tester);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(appendable);
        ObjectUtils.requireNonNull((Object)tester);
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte())) {
                return;
            }
            appendable.append((char)c);
        } while (bytes.readRemaining() != 0L);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull Bytes<?> bytes2, @NotNull StopCharTester tester) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes2);
        ObjectUtils.requireNonNull((Object)tester);
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte())) {
                return;
            }
            bytes2.writeUnsignedByte(c);
        } while (bytes.readRemaining() != 0L);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull Bytes<?> bytes2, @NotNull StopCharsTester tester) throws BufferUnderflowException, BufferOverflowException, IllegalStateException, ArithmeticException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes2);
        ObjectUtils.requireNonNull((Object)tester);
        int ch = bytes.readUnsignedByte();
        do {
            int next;
            if (tester.isStopChar(ch, next = bytes.readUnsignedByte())) {
                bytes.readSkip(-1L);
                return;
            }
            bytes2.writeUnsignedByte(ch);
            ch = next;
        } while (bytes.readRemaining() > 0L);
        if (tester.isStopChar(ch, -1)) {
            bytes.readSkip(-1L);
            return;
        }
        bytes2.writeUnsignedByte(ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseFlexibleLong(@NotNull StreamingDataInput in) throws BufferUnderflowException, IllegalStateException, IORuntimeException {
        int ch;
        long absValue = 0L;
        int sign = 1;
        int decimalPlaces = Integer.MIN_VALUE;
        boolean digits = false;
        while ((ch = in.rawReadByte() & 0xFF) == 32 && in.readRemaining() > 0L) {
        }
        try {
            switch (ch) {
                case 78: {
                    if (BytesInternal.compareRest(in, "aN")) {
                        throw new IORuntimeException("Expected flexible long, but got: NaN");
                    }
                    in.readSkip(-1L);
                    throw new IORuntimeException("Expected flexible long, but got: N");
                }
                case 73: {
                    if (BytesInternal.compareRest(in, "nfinity")) {
                        throw new IORuntimeException("Expected flexible long, but got: Infinity");
                    }
                    in.readSkip(-1L);
                    throw new IORuntimeException("Expected flexible long, but got: I");
                }
                case 45: {
                    if (BytesInternal.compareRest(in, INFINITY)) {
                        throw new IORuntimeException("Expected flexible long, but got: -Infinity");
                    }
                    sign = -1;
                    ch = in.rawReadByte();
                    break;
                }
                case 43: {
                    if (BytesInternal.compareRest(in, INFINITY)) {
                        throw new IORuntimeException("Expected flexible long, but got: +Infinity");
                    }
                    ch = in.rawReadByte();
                    break;
                }
            }
            int tens = 0;
            IORuntimeException parsingError = null;
            while (true) {
                if (ch >= 48 && ch <= 57) {
                    if (-absValue < -922337203685477580L) {
                        if (ch == 48) {
                            ++tens;
                        } else if (parsingError == null) {
                            parsingError = new IORuntimeException(CAN_T_PARSE_FLEXIBLE_LONG_WITHOUT_PRECISION_LOSS + (long)sign * absValue + " <- " + (char)ch);
                        }
                    } else if (absValue == 0xCCCCCCCCCCCCCCCL) {
                        if (ch <= 55 || sign < 0 && ch == 56) {
                            absValue = absValue * 10L + (long)(ch - 48);
                        } else if (parsingError == null) {
                            parsingError = new IORuntimeException(CAN_T_PARSE_FLEXIBLE_LONG_WITHOUT_PRECISION_LOSS + (long)sign * absValue + " <- " + (char)ch);
                        }
                    } else {
                        absValue = absValue * 10L + (long)(ch - 48);
                    }
                    ++decimalPlaces;
                    digits = true;
                } else if (ch == 46) {
                    decimalPlaces = 0;
                } else {
                    if (ch != 69 && ch != 101) break;
                    tens += (int)BytesInternal.parseLong(in);
                    break;
                }
                if (in.readRemaining() == 0L) break;
                ch = in.rawReadByte();
            }
            if (parsingError != null) {
                throw parsingError;
            }
            if (!digits) {
                long l = 0L;
                return l;
            }
            if (decimalPlaces < 0) {
                decimalPlaces = 0;
            }
            if ((tens -= decimalPlaces) <= 0) {
                absValue *= (long)sign;
                for (int i = 0; i < -tens; ++i) {
                    int truncatingDigit = (int)Math.abs(absValue % 10L);
                    if (truncatingDigit != 0) {
                        throw new IORuntimeException("Can't parse flexible long without precision loss: division of " + absValue + " by 10");
                    }
                    absValue /= 10L;
                }
                long i = absValue;
                return i;
            }
            for (int i = 0; i < tens; ++i) {
                if (-absValue < -922337203685477580L) {
                    throw new IORuntimeException("Can't parse flexible long as it goes beyond the range: multiplication of " + absValue + " by 10");
                }
                absValue *= 10L;
            }
            long l = (long)sign * absValue;
            return l;
        }
        finally {
            ByteStringParser bsp = (ByteStringParser)in;
            bsp.lastDecimalPlaces(decimalPlaces);
            bsp.lastNumberHadDigits(digits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double parseDouble(@NotNull StreamingDataInput in) throws BufferUnderflowException, IllegalStateException {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        boolean digits = false;
        int ch = 32;
        while (in.readRemaining() > 0L && (ch = in.peekUnsignedByte() & 0xFF) == 32) {
            in.readSkip(1L);
        }
        try {
            switch (ch) {
                case 78: {
                    if (BytesInternal.compareRest(in, NAN)) {
                        double d = Double.NaN;
                        return d;
                    }
                    double d = Double.NaN;
                    return d;
                }
                case 73: {
                    if (BytesInternal.compareRest(in, INFINITY)) {
                        double d = Double.POSITIVE_INFINITY;
                        return d;
                    }
                    double d = Double.NaN;
                    return d;
                }
                case 45: {
                    negative = true;
                    in.readSkip(1L);
                    if (!BytesInternal.compareRest(in, INFINITY)) break;
                    double d = Double.NEGATIVE_INFINITY;
                    return d;
                }
                case 43: {
                    in.readSkip(1L);
                    if (!BytesInternal.compareRest(in, INFINITY)) break;
                    double d = Double.POSITIVE_INFINITY;
                    return d;
                }
            }
            int tens = 0;
            while (in.readRemaining() > 0L) {
                ch = in.readUnsignedByte() & 0xFF;
                if (ch >= 48 && ch <= 57) {
                    while (value >= 0xCCCCCCCCCCCCCCCL) {
                        value >>>= 1;
                        ++exp;
                    }
                    value = value * 10L + (long)(ch - 48);
                    ++decimalPlaces;
                    digits = true;
                    continue;
                }
                if (ch == 46) {
                    decimalPlaces = 0;
                    continue;
                }
                if (ch != 69 && ch != 101) break;
                tens = (int)BytesInternal.parseLong(in);
                break;
            }
            if (!digits) {
                double d = -0.0;
                return d;
            }
            if (decimalPlaces < 0) {
                decimalPlaces = 0;
            }
            double d = Maths.asDouble((long)value, (int)exp, (boolean)negative, (int)(decimalPlaces -= tens));
            return d;
        }
        finally {
            ByteStringParser bsp = (ByteStringParser)in;
            bsp.lastDecimalPlaces(decimalPlaces);
            bsp.lastNumberHadDigits(digits);
        }
    }

    static boolean compareRest(@NotNull StreamingDataInput in, @NotNull String s) throws BufferUnderflowException, IllegalStateException {
        if ((long)s.length() > in.readRemaining()) {
            return false;
        }
        long position = in.readPosition();
        for (int i = 0; i < s.length(); ++i) {
            if (in.readUnsignedByte() == s.charAt(i)) continue;
            in.readPosition(position);
            return false;
        }
        int ch = in.readUnsignedByte();
        if (Character.isLetterOrDigit(ch)) {
            in.readPosition(position);
            return false;
        }
        while (Character.isWhitespace(ch) && ch >= 32) {
            ch = in.readUnsignedByte();
        }
        return true;
    }

    public static long parseLong(@NotNull StreamingDataInput in) throws BufferUnderflowException, IllegalStateException {
        long num = 0L;
        boolean negative = false;
        int b = in.peekUnsignedByte();
        while (b >= 0 && b <= 32) {
            in.readSkip(1L);
            b = in.peekUnsignedByte();
        }
        boolean digits = false;
        if (b == 48) {
            in.readSkip(1L);
            b = in.peekUnsignedByte();
            digits = true;
            if (b == 120 || b == 88) {
                in.readSkip(1L);
                return BytesInternal.parseLongHexaDecimal(in);
            }
        }
        while (in.readRemaining() > 0L) {
            b = in.rawReadByte();
            if (b - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                digits = true;
                continue;
            }
            if (b == 45) {
                negative = true;
                continue;
            }
            if (b == 93 || b == 125) {
                in.readSkip(-1L);
                break;
            }
            if (b == 46) {
                BytesInternal.consumeDecimals(in);
                break;
            }
            if (b == 95 || b == 43) continue;
        }
        ((ByteStringParser)in).lastNumberHadDigits(digits);
        return negative ? -num : num;
    }

    private static long parseLongHexaDecimal(@NotNull StreamingDataInput in) throws IllegalStateException, BufferUnderflowException {
        long num = 0L;
        while (in.readRemaining() > 0L) {
            int b = in.readUnsignedByte();
            if (b - -2147483600 <= -2147483639) {
                num = (num << 4) + (long)b - 48L;
                continue;
            }
            if (b - -2147483583 < -2147483642) {
                num = (num << 4) + (long)b - 55L;
                continue;
            }
            if (b - -2147483551 < -2147483642) {
                num = (num << 4) + (long)b - 87L;
                continue;
            }
            if (b == 93 || b == 125) {
                in.readSkip(-1L);
                break;
            }
            if (b == 46) {
                BytesInternal.consumeDecimals(in);
                break;
            }
            if (b == 95) continue;
        }
        return num;
    }

    static void consumeDecimals(@NotNull StreamingDataInput in) throws IllegalStateException {
        int b;
        while (in.readRemaining() > 0L && (b = in.readUnsignedByte()) >= 48 && b <= 57) {
        }
    }

    public static long parseLongDecimal(@NotNull StreamingDataInput in) throws BufferUnderflowException, IllegalStateException {
        long num = 0L;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        boolean digits = false;
        boolean first = true;
        while (in.readRemaining() > 0L) {
            int b = in.readUnsignedByte();
            if (b - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                ++decimalPlaces;
                digits = true;
                first = false;
                continue;
            }
            if (b == 46) {
                decimalPlaces = 0;
                first = false;
                continue;
            }
            if (b == 45) {
                negative = true;
                first = false;
                continue;
            }
            if (b == 93 || b == 125) {
                in.readSkip(-1L);
                break;
            }
            if (b == 95 || b == 43) {
                first = false;
                continue;
            }
            if (first && b <= 32) continue;
            break;
        }
        ByteStringParser bsp = (ByteStringParser)in;
        bsp.lastDecimalPlaces(decimalPlaces);
        bsp.lastNumberHadDigits(digits);
        return negative ? -num : num;
    }

    public static long parseHexLong(@NotNull StreamingDataInput in) throws BufferUnderflowException, IllegalStateException {
        long num = 0L;
        while (in.readRemaining() > 0L) {
            int b = in.readUnsignedByte();
            if (b - -2147483600 <= -2147483639) {
                num = num * 16L + (long)b - 48L;
                continue;
            }
            if (b - -2147483583 <= -2147483642) {
                num = num * 16L + (long)b - 65L + 10L;
                continue;
            }
            if (b - -2147483551 <= -2147483642) {
                num = num * 16L + (long)b - 97L + 10L;
                continue;
            }
            if (b == 93 || b == 125) {
                in.readSkip(-1L);
                break;
            }
            if (b == 95) continue;
        }
        return num;
    }

    public static long parseLong(@NotNull RandomDataInput in, @NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        long num = 0L;
        boolean negative = false;
        while (true) {
            int b;
            if ((b = in.peekUnsignedByte(offset++)) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b == 45) {
                negative = true;
                continue;
            }
            if (b != 95 && b != 43) break;
        }
        return negative ? -num : num;
    }

    public static boolean skipTo(@NotNull ByteStringParser parser, @NotNull StopCharTester tester) throws IllegalStateException {
        while (parser.readRemaining() > 0L) {
            int ch = parser.readUnsignedByte();
            if (!tester.isStopChar(ch)) continue;
            return true;
        }
        return false;
    }

    public static float addAndGetFloat(@NotNull BytesStore<?, ?> in, @NonNegative long offset, float adding) throws BufferUnderflowException, IllegalStateException {
        float value1;
        int value2;
        int value;
        while (!in.compareAndSwapInt(offset, value = in.readVolatileInt(offset), value2 = Float.floatToRawIntBits(value1 = Float.intBitsToFloat(value) + adding))) {
        }
        return value1;
    }

    public static double addAndGetDouble(@NotNull BytesStore<?, ?> in, @NonNegative long offset, double adding) throws BufferUnderflowException, IllegalStateException {
        double value1;
        long value2;
        long value;
        while (!in.compareAndSwapLong(offset, value = in.readVolatileLong(offset), value2 = Double.doubleToRawLongBits(value1 = Double.longBitsToDouble(value) + adding))) {
        }
        return value1;
    }

    public static int addAndGetInt(@NotNull BytesStore<?, ?> in, @NonNegative long offset, int adding) throws BufferUnderflowException, IllegalStateException {
        int value2;
        int value;
        while (!in.compareAndSwapInt(offset, value = in.readVolatileInt(offset), value2 = value + adding)) {
        }
        return value2;
    }

    public static long addAndGetLong(@NotNull BytesStore<?, ?> in, @NonNegative long offset, long adding) throws BufferUnderflowException, IllegalStateException {
        long value2;
        long value;
        while (!in.compareAndSwapLong(offset, value = in.readVolatileLong(offset), value2 = value + adding)) {
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toHexString(@NotNull Bytes<?> bytes, @NonNegative long offset, @NonNegative long maxLength) throws BufferUnderflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        if (maxLength == 0L) {
            return "";
        }
        int width = 16;
        int[] lastLine = new int[width];
        @NotNull String sep = "";
        long position = bytes.readPosition();
        long limit = bytes.readLimit();
        try {
            bytes.readPositionRemaining(offset, maxLength);
            @NotNull StringBuilder builder = new StringBuilder();
            long start = offset / (long)width * (long)width;
            long end = (offset + maxLength + (long)width - 1L) / (long)width * (long)width;
            for (long i = start; i < end; i += (long)width) {
                int ch;
                int j;
                if (i + (long)width < end) {
                    boolean same = true;
                    for (j = 0; j < width && i + (long)j < offset + maxLength; ++j) {
                        ch = bytes.readUnsignedByte(i + (long)j);
                        same &= ch == lastLine[j];
                        lastLine[j] = ch;
                    }
                    if (i > start && same) {
                        sep = "........\n";
                        continue;
                    }
                }
                builder.append(sep);
                sep = "";
                String str = Long.toHexString(i);
                for (j = str.length(); j < 8; ++j) {
                    builder.append('0');
                }
                builder.append(str);
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < offset || i + (long)j >= offset + maxLength) {
                        builder.append("   ");
                        continue;
                    }
                    builder.append(' ');
                    ch = bytes.readUnsignedByte(i + (long)j);
                    builder.append(HEXADECIMAL[ch >> 4]);
                    builder.append(HEXADECIMAL[ch & 0xF]);
                }
                builder.append(' ');
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < offset || i + (long)j >= offset + maxLength) {
                        builder.append(' ');
                        continue;
                    }
                    ch = bytes.readUnsignedByte(i + (long)j);
                    if (ch < 32 || ch > 126) {
                        ch = 183;
                    }
                    builder.append((char)ch);
                }
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            bytes.readLimit(limit);
            bytes.readPosition(position);
        }
    }

    public static void appendTimeMillis(@NotNull ByteStringAppender b, long timeInMS) throws BufferOverflowException, IllegalStateException, IllegalArgumentException {
        int hours = (int)(timeInMS / 3600000L);
        if (hours > 99) {
            b.append(hours);
        } else {
            b.rawWriteByte((byte)(hours / 10 + 48));
            b.rawWriteByte((byte)(hours % 10 + 48));
        }
        b.rawWriteByte((byte)58);
        int minutes = (int)(timeInMS / 60000L % 60L);
        b.rawWriteByte((byte)(minutes / 10 + 48));
        b.rawWriteByte((byte)(minutes % 10 + 48));
        b.rawWriteByte((byte)58);
        int seconds = (int)(timeInMS / 1000L % 60L);
        b.rawWriteByte((byte)(seconds / 10 + 48));
        b.rawWriteByte((byte)(seconds % 10 + 48));
        b.rawWriteByte((byte)46);
        int millis = (int)(timeInMS % 1000L);
        b.rawWriteByte((byte)(millis / 100 + 48));
        b.rawWriteByte((byte)(millis / 10 % 10 + 48));
        b.rawWriteByte((byte)(millis % 10 + 48));
    }

    public static boolean equalBytesAny(@NotNull BytesStore b1, @NotNull BytesStore b2, @NonNegative long readRemaining) throws BufferUnderflowException, IllegalStateException {
        long i;
        if (Math.min(b1.readRemaining(), b2.readRemaining()) < readRemaining) {
            return false;
        }
        long rp1 = b1.readPosition();
        long rp2 = b2.readPosition();
        for (i = 0L; i < readRemaining - 7L && BytesInternal.canReadBytesAt(b1, rp1 + i, 8) && BytesInternal.canReadBytesAt(b2, rp2 + i, 8); i += 8L) {
            long l2;
            long l1 = b1.readLong(rp1 + i);
            if (l1 == (l2 = b2.readLong(rp2 + i))) continue;
            return false;
        }
        while (i < readRemaining && BytesInternal.canReadBytesAt(b1, rp1 + i, 1) && BytesInternal.canReadBytesAt(b2, rp2 + i, 1)) {
            byte i2;
            byte i1 = b1.readByte(rp1 + i);
            if (i1 != (i2 = b2.readByte(rp2 + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void appendDateMillis(@NotNull ByteStringAppender b, long timeInMS) throws BufferOverflowException, IllegalStateException {
        DateCache dateCache = dateCacheTL.get();
        if (dateCache == null) {
            dateCache = new DateCache();
            dateCacheTL.set(dateCache);
        }
        long date = timeInMS / 86400000L;
        if (dateCache.lastDay != date) {
            DateCache.access$102(dateCache, dateCache.dateFormat.format(new Date(timeInMS)).getBytes(StandardCharsets.ISO_8859_1));
            dateCache.lastDay = date;
        } else assert (dateCache.lastDateStr != null);
        b.write(dateCache.lastDateStr);
    }

    @NotNull
    public static <E extends Enum<E>, S extends StreamingDataInput<S>> E readEnum(@NotNull StreamingDataInput input, @NotNull Class<E> eClass) throws BufferUnderflowException, IORuntimeException, BufferOverflowException, IllegalStateException, ArithmeticException {
        Bytes<?> bytes = BytesInternal.acquireBytes();
        input.read8bit(bytes);
        return (E)((EnumInterner)EnumInterner.ENUM_INTERNER.get(eClass)).intern(bytes);
    }

    public static void writeFully(@NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length, @NotNull StreamingDataOutput sdo) throws BufferUnderflowException, BufferOverflowException, IllegalStateException {
        long i;
        if (bytes instanceof HasUncheckedRandomDataInput) {
            if (length + offset > bytes.capacity()) {
                throw new DecoratedBufferOverflowException("Cannot read " + length + " bytes as offset is " + offset + " and capacity is " + bytes.capacity());
            }
            UncheckedRandomDataInput uBytes = ((HasUncheckedRandomDataInput)((Object)bytes)).acquireUncheckedInput();
            for (i = 0L; i < length - 7L; i += 8L) {
                sdo.rawWriteLong(uBytes.readLong(offset + i));
            }
            if (i < length - 3L) {
                sdo.rawWriteInt(uBytes.readInt(offset + i));
                i += 4L;
            }
            while (i < length) {
                sdo.rawWriteByte(uBytes.readByte(offset + i));
                ++i;
            }
        } else {
            while (i < length - 7L) {
                sdo.rawWriteLong(bytes.readLong(offset + i));
                i += 8L;
            }
            if (i < length - 3L) {
                sdo.rawWriteInt(bytes.readInt(offset + i));
                i += 4L;
            }
            while (i < length) {
                sdo.rawWriteByte(bytes.readByte(offset + i));
                ++i;
            }
        }
    }

    public static void copyMemory(long from, long to, int length) {
        UnsafeMemory.copyMemory((long)from, (long)to, (int)length);
    }

    @NotNull
    public static byte[] toByteArray(@NotNull RandomDataInput in) throws IllegalStateException {
        int len = (int)Math.min(0x7FFFFFF0L, in.readRemaining());
        ReferenceCountedUtil.throwExceptionIfReleased(in);
        @NotNull byte[] bytes = new byte[len];
        in.read(in.readPosition(), bytes, 0, bytes.length);
        return bytes;
    }

    public static void copy(@NotNull RandomDataInput input, @NotNull OutputStream output) throws IOException, IllegalStateException {
        int len;
        ObjectUtils.requireNonNull((Object)input);
        ObjectUtils.requireNonNull((Object)output);
        ReferenceCountedUtil.throwExceptionIfReleased(input);
        byte[] bytes = new byte[512];
        long start = input.readPosition();
        long i = 0L;
        while ((len = (int)input.read(start + i, bytes, 0, bytes.length)) > 0) {
            output.write(bytes, 0, len);
            i += (long)len;
        }
    }

    public static void copy(@NotNull InputStream input, @NotNull StreamingDataOutput output) throws IOException, BufferOverflowException, IllegalStateException {
        int len;
        @NotNull byte[] bytes = new byte[512];
        while ((len = input.read(bytes)) > 0) {
            output.write(bytes, 0, len);
        }
    }

    public static Boolean parseBoolean(@NotNull ByteStringParser parser, @NotNull StopCharTester tester) throws BufferUnderflowException, IllegalStateException, ArithmeticException {
        Bytes<?> sb = BytesInternal.acquireBytes();
        BytesInternal.parseUtf8((StreamingDataInput)parser, sb, tester);
        if (sb.length() == 0) {
            return null;
        }
        switch (sb.charAt(0)) {
            case 'T': 
            case 't': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore(sb, (CharSequence)"true") ? Boolean.valueOf(true) : null;
            }
            case 'Y': 
            case 'y': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore(sb, (CharSequence)"yes") ? Boolean.valueOf(true) : null;
            }
            case '0': {
                return sb.length() == 1 ? Boolean.valueOf(false) : null;
            }
            case '1': {
                return sb.length() == 1 ? Boolean.valueOf(true) : null;
            }
            case 'F': 
            case 'f': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore(sb, (CharSequence)"false") ? Boolean.valueOf(false) : null;
            }
            case 'N': 
            case 'n': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore(sb, (CharSequence)"no") ? Boolean.valueOf(false) : null;
            }
        }
        return null;
    }

    @NotNull
    public static BytesStore subBytes(RandomDataInput from, @NonNegative long start, @NonNegative long length) throws BufferUnderflowException, IllegalStateException {
        BytesStore<?, Object> ret = from.isDirectMemory() ? BytesStore.nativeStore(Math.max(0L, length)) : BytesStore.wrap(new byte[Math.toIntExact(length)]);
        ret.write(0L, from, start, length);
        return ret;
    }

    public static long findByte(@NotNull RandomDataInput bytes, byte stopByte) throws IllegalStateException {
        long start = bytes.readPosition();
        long remaining = bytes.readRemaining();
        for (long i = 0L; i < remaining; ++i) {
            if (bytes.readByte(start + i) != stopByte) continue;
            return i;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<?> fromHexString(@NotNull String s) {
        Bytes<byte[]> in = Bytes.from(s);
        try {
            Bytes<ByteBuffer> out = Bytes.elasticByteBuffer();
            block3: while (in.readRemaining() > 0L) {
                in.parseHexLong();
                for (int i = 0; i < 16; ++i) {
                    if (in.peekUnsignedByte() == 32) {
                        in.readSkip(1L);
                        if (in.peekUnsignedByte() == 32) break block3;
                    }
                    long value = in.parseHexLong();
                    out.rawWriteByte((byte)value);
                }
                if (in.readByte(in.readPosition() - 1L) <= 32) {
                    in.readSkip(-1L);
                }
                in.skipTo(StopCharTesters.CONTROL_STOP);
            }
            Bytes<ByteBuffer> bytes = out;
            return bytes;
        }
        finally {
            in.releaseLast();
        }
    }

    public static void readHistogram(@NotNull StreamingDataInput in, @NotNull Histogram histogram) throws IllegalStateException, BufferUnderflowException, ArithmeticException {
        ObjectUtils.requireNonNull((Object)histogram);
        ReferenceCountedUtil.throwExceptionIfReleased(in);
        int powersOf2 = Maths.toUInt31((long)in.readStopBit());
        int fractionBits = Maths.toUInt31((long)in.readStopBit());
        long overRange = in.readStopBit();
        long totalCount = in.readStopBit();
        long floor = in.readStopBit();
        histogram.init(powersOf2, fractionBits, overRange, totalCount, floor);
        int length = Maths.toUInt31((long)in.readStopBit());
        int[] ints = histogram.sampleCount();
        for (int i = 0; i < length; ++i) {
            ints[i] = Maths.toUInt31((long)in.readStopBit());
        }
    }

    public static void writeHistogram(@NotNull StreamingDataOutput out, @NotNull Histogram histogram) throws BufferOverflowException, IllegalStateException {
        ObjectUtils.requireNonNull((Object)histogram);
        ReferenceCountedUtil.throwExceptionIfReleased(out);
        out.writeStopBit(histogram.powersOf2());
        out.writeStopBit(histogram.fractionBits());
        out.writeStopBit(histogram.overRange());
        out.writeStopBit(histogram.totalCount());
        out.writeStopBit(histogram.floor());
        int[] ints = histogram.sampleCount();
        out.writeStopBit(ints.length);
        for (int i : ints) {
            out.writeStopBit(i);
        }
    }

    public static ByteBuffer asByteBuffer(@NotNull BytesStore bytesStore) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.asByteBuffer(BYTE_BUFFER_TL, bytesStore);
    }

    public static ByteBuffer asByteBuffer2(@NotNull BytesStore bytesStore) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.asByteBuffer(BYTE_BUFFER2_TL, bytesStore);
    }

    private static ByteBuffer asByteBuffer(@NotNull ThreadLocal<ByteBuffer> byteBufferTL, @NotNull BytesStore bytesStore) throws BufferUnderflowException, IllegalStateException {
        ByteBuffer byteBuffer = byteBufferTL.get();
        BytesInternal.assignBytesStoreToByteBuffer(bytesStore, byteBuffer);
        return byteBuffer;
    }

    public static void assignBytesStoreToByteBuffer(@NotNull BytesStore bytesStore, @NotNull ByteBuffer byteBuffer) throws BufferUnderflowException, IllegalStateException {
        long address = bytesStore.addressForRead(bytesStore.readPosition());
        long capacity = bytesStore.realReadRemaining();
        ByteBuffers.setAddressCapacity((ByteBuffer)byteBuffer, (long)address, (long)capacity);
        byteBuffer.clear();
    }

    private static boolean canReadBytesAt(BytesStore bs, long offset, int length) {
        return bs.readLimit() - offset >= (long)length;
    }

    public static String parse8bit(ByteStringParser bsp, StopCharTester stopCharTester) throws IllegalStateException {
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        BytesInternal.parse8bit((StreamingDataInput)bsp, sb, stopCharTester);
        return SI.intern(sb);
    }

    public static void copy8bit(BytesStore bs, long addressForWrite, @NonNegative long length) {
        int i;
        ReferenceCountedUtil.throwExceptionIfReleased(bs);
        int length0 = Math.toIntExact(length);
        for (i = 0; i < length0 - 7; i += 8) {
            UnsafeMemory.MEMORY.writeLong(addressForWrite + (long)i, bs.readLong(i));
        }
        while (i < length0) {
            UnsafeMemory.MEMORY.writeByte(addressForWrite + (long)i, bs.readByte(i));
            ++i;
        }
    }

    public static int digitsForExponent(int exponent) {
        return 21 + Math.abs(exponent);
    }

    public static <B extends BytesStore<B, U>, U> BytesStore<B, U> failIfBytesOnBytes(BytesStore<B, U> bytesStore) {
        if (bytesStore instanceof Bytes && !(bytesStore instanceof MappedBytes)) {
            throw new IllegalArgumentException("A BytesStore is required as backing but a Bytes has been provided: " + bytesStore.getClass().getSimpleName());
        }
        return bytesStore;
    }

    static {
        $VALUES = new BytesInternal[0];
        BYTE_BUFFER_TL = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(0));
        BYTE_BUFFER2_TL = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(0));
        HEXADECIMAL = "0123456789abcdef".toCharArray();
        MIN_VALUE_TEXT = "-9223372036854775808".getBytes(StandardCharsets.ISO_8859_1);
        SBP = new StringBuilderPool();
        BP = new BytesPool();
        INFINITY_BYTES = INFINITY.getBytes(StandardCharsets.ISO_8859_1);
        NAN_BYTES = NAN.getBytes(StandardCharsets.ISO_8859_1);
        dateCacheTL = new ThreadLocal();
        MAX_STRING_LEN = Jvm.getInteger((String)"bytes.max-string-len", (Integer)131072);
        NEG_ONE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 128 : 32768;
        try {
            SI = new StringInternerBytes(Jvm.getInteger((String)"wire.string-interner.size", (Integer)4096));
            ClassAliasPool.CLASS_ALIASES.addAlias(BytesStore.class, "!binary");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        MethodHandle vectorizedMismatchMethodHandle = null;
        try {
            if (Jvm.isJava9Plus() && !Jvm.getBoolean((String)"disable.vectorized.content_equals")) {
                Class<?> arraysSupportClass = Class.forName("jdk.internal.util.ArraysSupport");
                Method vectorizedMismatch = Jvm.getMethod(arraysSupportClass, (String)"vectorizedMismatch", (Class[])new Class[]{Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE});
                vectorizedMismatch.setAccessible(true);
                vectorizedMismatchMethodHandle = MethodHandles.lookup().unreflect(vectorizedMismatch);
            }
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                Jvm.warn().on(BytesInternal.class, "Cannot get access to vectorizedMismatch. The following command line args are required: --illegal-access=permit --add-exports java.base/jdk.internal.ref=ALL-UNNAMED --add-exports java.base/jdk.internal.util=ALL-UNNAMED. exception: " + e);
            } else {
                Jvm.warn().on(BytesInternal.class, (Throwable)e);
            }
        }
        finally {
            VECTORIZED_MISMATCH_METHOD_HANDLE = vectorizedMismatchMethodHandle;
        }
    }

    static class DateCache {
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        private long lastDay = Long.MIN_VALUE;
        private byte[] lastDateStr = null;

        DateCache() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        static /* synthetic */ byte[] access$102(DateCache x0, byte[] x1) {
            x0.lastDateStr = x1;
            return x1;
        }
    }
}

