/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.crypto.Cipher;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.algo.OptimisedBytesStoreHash;
import net.openhft.chronicle.bytes.algo.VanillaBytesStoreHash;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.HeapBytesStore;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.bytes.internal.NoBytesStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BytesStore<B extends BytesStore<B, U>, U>
extends RandomDataInput,
RandomDataOutput<B>,
ReferenceCounted,
CharSequence {
    @Override
    default public boolean compareAndSwapFloat(@NonNegative long offset, float expected, float value) throws BufferOverflowException, IllegalStateException {
        return this.compareAndSwapInt(offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(value));
    }

    @Override
    default public boolean compareAndSwapDouble(@NonNegative long offset, double expected, double value) throws BufferOverflowException, IllegalStateException {
        return this.compareAndSwapLong(offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(value));
    }

    @Override
    default public int addAndGetInt(@NonNegative long offset, int adding) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.addAndGetInt(this, offset, adding);
    }

    @Override
    default public long addAndGetLong(@NonNegative long offset, long adding) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.addAndGetLong(this, offset, adding);
    }

    @Override
    default public float addAndGetFloat(@NonNegative long offset, float adding) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.addAndGetFloat(this, offset, adding);
    }

    @Override
    default public double addAndGetDouble(@NonNegative long offset, double adding) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.addAndGetDouble(this, offset, adding);
    }

    public static BytesStore from(@NotNull CharSequence cs) throws IllegalStateException {
        if (cs.length() == 0) {
            return BytesStore.empty();
        }
        if (cs instanceof BytesStore) {
            return BytesStore.from((BytesStore)cs);
        }
        return BytesStore.from(cs.toString());
    }

    public static BytesStore from(@NotNull BytesStore cs) throws IllegalStateException {
        return cs.copy();
    }

    public static BytesStore from(@NotNull String cs) {
        return cs.length() == 0 ? BytesStore.empty() : BytesStore.wrap(cs.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static <T> BytesStore<?, T> forFields(Object o, String groupName, int padding) {
        return HeapBytesStore.forFields(o, groupName, padding);
    }

    public static BytesStore<?, byte[]> wrap(byte[] bytes) {
        return HeapBytesStore.wrap(bytes);
    }

    @NotNull
    public static BytesStore<?, ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return bb.isDirect() ? NativeBytesStore.wrap(bb) : HeapBytesStore.wrap(bb);
    }

    @NotNull
    public static BytesStore<?, ByteBuffer> follow(@NotNull ByteBuffer bb) {
        return bb.isDirect() ? NativeBytesStore.follow(bb) : HeapBytesStore.wrap(bb);
    }

    public static BytesStore<?, Void> nativeStore(@NonNegative long capacity) {
        return NativeBytesStore.nativeStore(capacity);
    }

    public static BytesStore<?, Void> nativeStoreWithFixedCapacity(@NonNegative long capacity) {
        return NativeBytesStore.nativeStoreWithFixedCapacity(capacity);
    }

    public static BytesStore<?, Void> lazyNativeBytesStoreWithFixedCapacity(@NonNegative long capacity) {
        return NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity(capacity);
    }

    public static BytesStore<?, ByteBuffer> elasticByteBuffer(@NonNegative int size, @NonNegative long maxSize) {
        return NativeBytesStore.elasticByteBuffer(size, maxSize);
    }

    public static BytesStore<?, Void> nativeStoreFrom(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return NativeBytesStore.from(bytes);
    }

    @NotNull
    public static PointerBytesStore nativePointer() {
        return new PointerBytesStore();
    }

    @NotNull
    public static PointerBytesStore wrap(long address, @NonNegative long length) {
        @NotNull PointerBytesStore pbs = BytesStore.nativePointer();
        pbs.set(address, length);
        return pbs;
    }

    public static BytesStore empty() {
        return NoBytesStore.NO_BYTES_STORE;
    }

    @Override
    public boolean isDirectMemory();

    public BytesStore<B, U> copy() throws IllegalStateException;

    @NotNull
    default public Bytes<U> bytesForRead() throws IllegalStateException {
        try {
            Bytes<U> ret = this.bytesForWrite();
            ret.readLimit(this.writeLimit());
            ret.writeLimit(this.realCapacity());
            ret.readPosition(this.start());
            return ret;
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    default public Bytes<U> bytesForWrite() throws IllegalStateException {
        try {
            return new VanillaBytes(this, this.writePosition(), this.writeLimit());
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public boolean isClear() {
        return true;
    }

    @Override
    @NonNegative
    default public long realCapacity() {
        return this.capacity();
    }

    @Override
    @NonNegative
    public long capacity();

    @Nullable
    public U underlyingObject();

    default public boolean inside(@NonNegative long offset) {
        return this.start() <= offset && offset < this.safeLimit();
    }

    default public boolean inside(@NonNegative long offset, @NonNegative long bufferSize) {
        return this.start() <= offset && offset + bufferSize <= this.safeLimit();
    }

    default public long safeLimit() {
        return this.capacity();
    }

    default public long copyTo(@NotNull BytesStore store) throws IllegalStateException {
        ObjectUtils.requireNonNull((Object)store);
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        ReferenceCountedUtil.throwExceptionIfReleased(store);
        long readPos = this.readPosition();
        long writePos = store.writePosition();
        long copy = Math.min(this.readRemaining(), store.writeRemaining());
        try {
            long i;
            for (i = 0L; i < copy - 7L; i += 8L) {
                store.writeLong(writePos + i, this.readLong(readPos + i));
            }
            while (i < copy) {
                store.writeByte(writePos + i, this.readByte(readPos + i));
                ++i;
            }
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        return copy;
    }

    default public void copyTo(@NotNull OutputStream out) throws IOException, IllegalStateException {
        BytesInternal.copy(this, out);
    }

    @Override
    @NotNull
    default public B zeroOut(@NonNegative long start, @NonNegative long end) throws IllegalStateException {
        if (end <= start) {
            return (B)this;
        }
        if (start < this.start()) {
            start = this.start();
        }
        if (end > this.capacity()) {
            end = this.capacity();
        }
        try {
            long i;
            for (i = start; i < end - 7L; i += 8L) {
                this.writeLong(i, 0L);
            }
            while (i < end) {
                this.writeByte(i, 0);
                ++i;
            }
        }
        catch (ArithmeticException | IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return (B)this;
    }

    @Override
    @NonNegative
    default public int length() {
        return (int)Math.min(Integer.MAX_VALUE, this.readRemaining());
    }

    @Override
    default public char charAt(@NonNegative int index) throws IndexOutOfBoundsException {
        try {
            return (char)this.readUnsignedByte(this.readPosition() + (long)index);
        }
        catch (BufferUnderflowException e) {
            throw new IndexOutOfBoundsException(this.readPosition() + (long)index + " >= " + this.readLimit());
        }
        catch (IllegalStateException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    @NotNull
    default public CharSequence subSequence(@NonNegative int start, @NonNegative int end) {
        if (start < 0 || end > this.length() || end < start) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", length " + this.length());
        }
        return this.subBytes(this.readPosition() + (long)start, (long)end - (long)start);
    }

    @NotNull
    default public String toDebugString() throws IllegalStateException {
        try {
            return this.toDebugString(512L);
        }
        catch (ArithmeticException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    default public String toDebugString(@NonNegative long maxLength) throws IllegalStateException, ArithmeticException {
        return BytesInternal.toDebugString(this, maxLength);
    }

    @Nullable
    default public BytesStore bytesStore() {
        return this;
    }

    default public boolean equalBytes(@NotNull BytesStore bytesStore, @NonNegative long length) throws BufferUnderflowException, IllegalStateException {
        return length == 8L && bytesStore.length() >= 8 ? this.readLong(this.readPosition()) == bytesStore.readLong(bytesStore.readPosition()) : BytesInternal.equalBytesAny(this, bytesStore, length);
    }

    default public int byteCheckSum() throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        try {
            return this.byteCheckSum(this.readPosition(), this.readLimit());
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public int byteCheckSum(@NonNegative long start, @NonNegative long end) throws BufferUnderflowException, IllegalStateException {
        int sum = 0;
        for (long i = start; i < end; ++i) {
            sum += this.readByte(i);
        }
        return sum & 0xFF;
    }

    default public boolean endsWith(char c) throws IllegalStateException {
        try {
            return this.readRemaining() > 0L && this.readUnsignedByte(this.readLimit() - 1L) == c;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public boolean startsWith(char c) throws IllegalStateException {
        try {
            return this.readRemaining() > 0L && this.readUnsignedByte(this.readPosition()) == c;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public boolean contentEquals(@Nullable BytesStore bytesStore) throws IllegalStateException {
        return BytesInternal.contentEqual(this, bytesStore);
    }

    default public boolean startsWith(@Nullable BytesStore bytesStore) throws IllegalStateException {
        return bytesStore != null && BytesInternal.startsWith(this, bytesStore);
    }

    @NotNull
    default public String to8bitString() {
        return BytesInternal.to8bitString(this);
    }

    default public int addAndGetUnsignedByteNotAtomic(@NonNegative long offset, int adding) throws BufferUnderflowException, IllegalStateException {
        try {
            int r = this.readUnsignedByte(offset) + adding & 0xFF;
            this.writeByte(offset, (byte)r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public short addAndGetShortNotAtomic(@NonNegative long offset, short adding) throws BufferUnderflowException, IllegalStateException {
        try {
            short r = (short)(this.readShort(offset) + adding);
            this.writeByte(offset, r);
            return r;
        }
        catch (ArithmeticException | IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public int addAndGetIntNotAtomic(@NonNegative long offset, int adding) throws BufferUnderflowException, IllegalStateException {
        try {
            int r = this.readInt(offset) + adding;
            this.writeInt(offset, r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public double addAndGetDoubleNotAtomic(@NonNegative long offset, double adding) throws BufferUnderflowException, IllegalStateException {
        try {
            double r = this.readDouble(offset) + adding;
            this.writeDouble(offset, r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public float addAndGetFloatNotAtomic(@NonNegative long offset, float adding) throws BufferUnderflowException, IllegalStateException {
        try {
            float r = this.readFloat(offset) + adding;
            this.writeFloat(offset, r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void move(@NonNegative long var1, @NonNegative long var3, @NonNegative long var5) throws BufferUnderflowException, IllegalStateException, ArithmeticException;

    default public void writeMaxLong(@NonNegative long offset, long atLeast) throws BufferUnderflowException, IllegalStateException {
        try {
            while (true) {
                long v;
                if ((v = this.readVolatileLong(offset)) >= atLeast) {
                    return;
                }
                if (this.compareAndSwapLong(offset, v, atLeast)) {
                    return;
                }
                Jvm.nanoPause();
            }
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public void writeMaxInt(@NonNegative long offset, int atLeast) throws BufferUnderflowException, IllegalStateException {
        try {
            while (true) {
                int v;
                if ((v = this.readVolatileInt(offset)) >= atLeast) {
                    return;
                }
                if (this.compareAndSwapInt(offset, v, atLeast)) {
                    return;
                }
                Jvm.nanoPause();
            }
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    default public boolean isEmpty() {
        return this.readRemaining() == 0L;
    }

    default public void cipher(@NotNull Cipher cipher, @NotNull Bytes<?> outBytes, @NotNull ByteBuffer using1, @NotNull ByteBuffer using2) throws IllegalStateException {
        long readPos = outBytes.readPosition();
        try {
            BytesStore<?, Void> inBytes;
            long writePos = outBytes.writePosition();
            long size = this.readRemaining();
            if (this.isDirectMemory()) {
                inBytes = this;
            } else {
                inBytes = BytesStore.nativeStore(size);
                this.copyTo(inBytes);
            }
            BytesInternal.assignBytesStoreToByteBuffer(inBytes, using1);
            int outputSize = cipher.getOutputSize(Math.toIntExact(size));
            outBytes.ensureCapacity(writePos + (long)outputSize);
            outBytes.readPositionRemaining(writePos, outputSize);
            BytesInternal.assignBytesStoreToByteBuffer(outBytes, using2);
            int len = cipher.update(using1, using2);
            if (!1.$assertionsDisabled && (len += cipher.doFinal(using1, using2)) != using2.position()) {
                throw new AssertionError();
            }
            outBytes.writePosition(writePos + (long)using2.position());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            outBytes.readPosition(readPos);
        }
    }

    default public void cipher(@NotNull Cipher cipher, @NotNull Bytes<?> outBytes) throws IllegalStateException {
        this.cipher(cipher, outBytes, BytesInternal.BYTE_BUFFER_TL.get(), BytesInternal.BYTE_BUFFER2_TL.get());
    }

    default public boolean readWrite() {
        return true;
    }

    default public long hash(long length) {
        return this.bytesStore() instanceof NativeBytesStore ? OptimisedBytesStoreHash.INSTANCE.applyAsLong(this, length) : VanillaBytesStoreHash.INSTANCE.applyAsLong(this, length);
    }

    default public boolean isEqual(@NonNegative long start, @NonNegative long length, String s) {
        if (s == null || (long)s.length() != length) {
            return false;
        }
        int length2 = (int)length;
        for (int i = 0; i < length2; ++i) {
            if (s.charAt(i) == this.readUnsignedByte(start + (long)i)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean compareAndSwapInt(long offset, int expected, int value) throws BufferOverflowException, IllegalStateException {
        return this.compareAndSwapInt(offset, expected, value);
    }

    @Override
    default public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException, IllegalStateException {
        return this.compareAndSwapLong(offset, expected, value);
    }

    @Deprecated
    default public boolean isImmutableEmptyByteStore() {
        return this.capacity() == 0L;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

