/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedBytesStoreFactory;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.internal.SingleMappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleMappedFile
extends MappedFile {
    static final boolean RETAIN = Jvm.getBoolean((String)"mappedFile.retain");
    @NotNull
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final MappedBytesStore store;
    private final long capacity;

    public SingleMappedFile(@NotNull File file, @NotNull RandomAccessFile raf, @NonNegative long capacity, boolean readOnly) throws IORuntimeException {
        super(file, readOnly);
        this.raf = raf;
        this.fileChannel = raf.getChannel();
        this.capacity = capacity;
        FileChannel.MapMode mode = this.readOnly() ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        long beginNs = System.nanoTime();
        boolean ok = false;
        try {
            Jvm.doNotCloseOnInterrupt(((Object)((Object)this)).getClass(), (FileChannel)this.fileChannel);
            this.resizeRafIfTooSmall(capacity);
            long address = OS.map((FileChannel)this.fileChannel, (FileChannel.MapMode)mode, (long)0L, (long)capacity);
            MappedBytesStore mbs2 = MappedBytesStore.MAPPED_BYTES_STORE_FACTORY.create((ReferenceOwner)this, this, 0L, address, capacity, capacity);
            long elapsedNs = System.nanoTime() - beginNs;
            if (this.newChunkListener != null) {
                this.newChunkListener.onNewChunk(this.file().getPath(), 0, elapsedNs / 1000L);
            }
            if (elapsedNs >= 2000000L) {
                Jvm.perf().on(((Object)((Object)this)).getClass(), "Took " + elapsedNs / 1000000L + " ms to add mapping for " + this.file());
            }
            this.store = mbs2;
            ok = true;
        }
        catch (IOException ioe) {
            throw new IORuntimeException((Throwable)ioe);
        }
        finally {
            if (!ok) {
                this.close();
            }
        }
    }

    @Override
    @NotNull
    public MappedBytesStore acquireByteStore(ReferenceOwner owner, @NonNegative long position, BytesStore oldByteStore, @NotNull MappedBytesStoreFactory mappedBytesStoreFactory) throws IllegalArgumentException {
        if (position != 0L) {
            throw new IllegalArgumentException();
        }
        this.store.reserve(owner);
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeRafIfTooSmall(@NonNegative long minSize) throws IOException {
        Jvm.safepoint();
        long size = this.fileChannel.size();
        Jvm.safepoint();
        if (size >= minSize || this.readOnly()) {
            return;
        }
        try {
            String string = this.internalizedToken();
            synchronized (string) {
                size = this.fileChannel.size();
                if (size < minSize) {
                    long beginNs = System.nanoTime();
                    try (FileLock ignore = this.fileChannel.lock();){
                        size = this.fileChannel.size();
                        if (size < minSize) {
                            Jvm.safepoint();
                            this.raf.setLength(minSize);
                            Jvm.safepoint();
                        }
                    }
                    long elapsedNs = System.nanoTime() - beginNs;
                    if (elapsedNs >= 1000000L) {
                        Jvm.perf().on(((Object)((Object)this)).getClass(), "Took " + elapsedNs / 1000L + " us to grow file " + this.file());
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IOException("Failed to resize to " + minSize, ioe);
        }
    }

    protected void performRelease() {
        try {
            MappedBytesStore mbs = this.store;
            if (mbs != null && RETAIN) {
                try {
                    mbs.release((ReferenceOwner)this);
                }
                catch (IllegalStateException e) {
                    Jvm.debug().on(((Object)((Object)this)).getClass(), (Throwable)e);
                }
            }
        }
        finally {
            Closeable.closeQuietly((Object)this.raf);
            this.setClosed();
        }
    }

    @Override
    @NotNull
    public String referenceCounts() {
        @NotNull StringBuilder sb = new StringBuilder();
        sb.append("refCount: ").append(this.refCount());
        @Nullable MappedBytesStore mbs = this.store;
        long count = 0L;
        if (mbs != null) {
            count = mbs.refCount();
        }
        sb.append(", ").append(count);
        return sb.toString();
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long chunkSize() {
        return this.capacity;
    }

    @Override
    public long overlapSize() {
        return 0L;
    }

    @Override
    public NewChunkListener getNewChunkListener() {
        return this.newChunkListener;
    }

    @Override
    public void setNewChunkListener(NewChunkListener listener) {
        this.newChunkListener = listener;
    }

    @Override
    public long actualSize() throws IORuntimeException, IllegalStateException {
        boolean interrupted = Thread.interrupted();
        try {
            long l = this.fileChannelSize();
            return l;
        }
        catch (ArrayIndexOutOfBoundsException aiooe) {
            long l = this.actualSize();
            return l;
        }
        catch (ClosedByInterruptException cbie) {
            this.close();
            interrupted = true;
            throw new IllegalStateException(cbie);
        }
        catch (IOException e) {
            boolean open = this.fileChannel.isOpen();
            if (open) {
                throw new IORuntimeException((Throwable)e);
            }
            this.close();
            throw new IllegalStateException(e);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private long fileChannelSize() throws IOException, ArrayIndexOutOfBoundsException {
        return this.fileChannel.size();
    }

    @Override
    @NotNull
    public RandomAccessFile raf() {
        return this.raf;
    }

    @Override
    protected void finalize() throws Throwable {
        this.warnAndReleaseIfNotReleased();
        super.finalize();
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }

    @Override
    public FileLock lock(@NonNegative long position, @NonNegative long size, boolean shared) throws IOException {
        return this.fileChannel.lock(position, size, shared);
    }

    @Override
    public FileLock tryLock(@NonNegative long position, @NonNegative long size, boolean shared) throws IOException {
        return this.fileChannel.tryLock(position, size, shared);
    }

    @Override
    public long chunkCount() {
        return 1L;
    }

    @Override
    public void chunkCount(long[] chunkCount) {
        chunkCount[0] = 1L;
    }

    @Override
    public MappedBytes createBytesFor() {
        return new SingleMappedBytes(this);
    }
}

