/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.StreamingOutputStream;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DontChain
public interface StreamingDataOutput<S extends StreamingDataOutput<S>>
extends StreamingCommon<S> {
    public static final int JAVA9_STRING_CODER_LATIN = 0;
    public static final int JAVA9_STRING_CODER_UTF16 = 1;

    @NotNull
    public S writePosition(@NonNegative long var1) throws BufferOverflowException;

    @NotNull
    public S writeLimit(@NonNegative long var1) throws BufferOverflowException;

    @NotNull
    public S writeSkip(long var1) throws BufferOverflowException, IllegalStateException;

    default public long writePositionForHeader(boolean skipPadding) {
        long position = this.writePosition();
        if (skipPadding) {
            return this.writeSkip(BytesUtil.padOffset(position)).writePosition();
        }
        return position;
    }

    @NotNull
    default public OutputStream outputStream() {
        return new StreamingOutputStream(this);
    }

    @NotNull
    default public S writeStopBit(long x) throws BufferOverflowException, IllegalStateException {
        BytesInternal.writeStopBit(this, x);
        return (S)this;
    }

    @NotNull
    default public S writeStopBit(char x) throws BufferOverflowException, IllegalStateException {
        BytesInternal.writeStopBit(this, x);
        return (S)this;
    }

    @NotNull
    default public S writeStopBit(double d) throws BufferOverflowException, IllegalStateException {
        BytesInternal.writeStopBit(this, d);
        return (S)this;
    }

    @NotNull
    default public S writeStopBitDecimal(double d) throws BufferOverflowException, IllegalStateException {
        long value;
        boolean negative = d < 0.0;
        double ad = Math.abs(d);
        if ((double)((long)ad) == ad) {
            value = (long)ad * 10L;
        } else {
            double v;
            int scale;
            double factor = 1.0;
            for (scale = 0; scale < 9 && !((v = ad * factor) >= 1.0E14) && (double)((long)v) != v; ++scale) {
                factor *= 10.0;
            }
            value = Math.round(ad * factor);
            while (scale > 0 && value % 10L == 0L) {
                value /= 10L;
                --scale;
            }
            value = value * 10L + (long)scale;
        }
        if (negative) {
            value = -value;
        }
        BytesInternal.writeStopBit(this, value);
        return (S)this;
    }

    @NotNull
    default public S writeUtf8(@Nullable CharSequence text) throws BufferOverflowException, IllegalStateException, IllegalArgumentException, BufferUnderflowException {
        BytesInternal.writeUtf8(this, text);
        return (S)this;
    }

    @NotNull
    default public S writeUtf8(@Nullable String text) throws BufferOverflowException, IllegalStateException, BufferUnderflowException, IllegalArgumentException {
        BytesInternal.writeUtf8(this, text);
        return (S)this;
    }

    @NotNull
    default public S write8bit(@Nullable CharSequence text) throws BufferOverflowException, ArithmeticException, IllegalStateException, BufferUnderflowException {
        if (text == null) {
            BytesInternal.writeStopBitNeg1(this);
            return (S)this;
        }
        if (text instanceof BytesStore) {
            long offset = ((BytesStore)text).readPosition();
            long readRemaining = Math.min(this.writeRemaining(), ((BytesStore)text).readLimit() - offset);
            this.writeStopBit(readRemaining);
            try {
                this.write((BytesStore)text, offset, readRemaining);
            }
            catch (IllegalArgumentException | BufferUnderflowException e) {
                throw new AssertionError((Object)e);
            }
            return (S)this;
        }
        if (text instanceof String) {
            return this.write8bit((String)text);
        }
        return this.write8bit(text, 0, text.length());
    }

    @NotNull
    default public S write8bit(@NotNull CharSequence text, @NonNegative int start, @NonNegative int length) throws BufferOverflowException, IndexOutOfBoundsException, ArithmeticException, IllegalStateException, BufferUnderflowException {
        ObjectUtils.requireNonNull((Object)text);
        if (text instanceof String) {
            return this.write8bit((String)text, start, length);
        }
        this.writeStopBit(length);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i + start);
            this.rawWriteByte((byte)Maths.toUInt8((long)c));
        }
        return (S)this;
    }

    @NotNull
    public S write8bit(@NotNull String var1, @NonNegative int var2, @NonNegative int var3);

    @NotNull
    default public S write(@NotNull CharSequence text) throws BufferOverflowException, IndexOutOfBoundsException, IllegalStateException {
        ObjectUtils.requireNonNull((Object)text);
        if (text instanceof BytesStore) {
            return this.write((BytesStore)text);
        }
        return this.write(text, 0, text.length());
    }

    @NotNull
    default public S write(@NotNull CharSequence text, @NonNegative int startText, @NonNegative int length) throws BufferOverflowException, IndexOutOfBoundsException, IllegalStateException {
        ObjectUtils.requireNonNull((Object)text);
        Ints.requireNonNegative((int)startText);
        Ints.requireNonNegative((int)length);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i + startText);
            this.appendUtf8(c);
        }
        return (S)this;
    }

    @NotNull
    default public S write8bit(@Nullable String s) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        try {
            if (s == null) {
                BytesInternal.writeStopBitNeg1(this);
            } else {
                long rem = this.writeRemaining();
                if (rem < 0L) {
                    throw new IllegalStateException("rem: " + rem);
                }
                this.write8bit(s, 0, s.length());
            }
            return (S)this;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public S writeByte(byte var1) throws BufferOverflowException, IllegalStateException;

    default public S rawWriteByte(byte i8) throws BufferOverflowException, IllegalStateException {
        return this.writeByte(i8);
    }

    @NotNull
    default public S writeUnsignedByte(int i) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        return this.writeByte((byte)Maths.toUInt8((long)i));
    }

    @NotNull
    default public S writeChar(char ch) throws BufferOverflowException, IllegalStateException {
        return this.writeStopBit(ch);
    }

    @NotNull
    public S writeShort(short var1) throws BufferOverflowException, IllegalStateException;

    @NotNull
    default public S writeUnsignedShort(int u16) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        return this.writeShort((short)Maths.toUInt16((long)u16));
    }

    @NotNull
    default public S writeInt24(int i) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        this.writeShort((short)i);
        return this.writeByte(Maths.toInt8((long)(i >> 16)));
    }

    @NotNull
    default public S writeUnsignedInt24(int i) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        this.writeShort((short)i);
        return this.writeUnsignedByte(i >>> 16);
    }

    @NotNull
    public S writeInt(int var1) throws BufferOverflowException, IllegalStateException;

    default public S rawWriteInt(int i) throws BufferOverflowException, IllegalStateException {
        return this.writeInt(i);
    }

    @NotNull
    public S writeIntAdv(int var1, @NonNegative int var2) throws BufferOverflowException, IllegalStateException;

    @NotNull
    default public S writeUnsignedInt(long i) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        return this.writeInt((int)Maths.toUInt32((long)i));
    }

    @NotNull
    public S writeLong(long var1) throws BufferOverflowException, IllegalStateException;

    default public S rawWriteLong(long i) throws BufferOverflowException, IllegalStateException {
        return this.writeLong(i);
    }

    @NotNull
    public S writeLongAdv(long var1, @NonNegative int var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public S writeFloat(float var1) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public S writeDouble(double var1) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public S writeDoubleAndInt(double var1, int var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    default public S write(@NotNull RandomDataInput bytes) throws BufferOverflowException, IllegalStateException {
        if (!1.$assertionsDisabled && bytes == this) {
            throw new AssertionError((Object)"you should not write to yourself !");
        }
        ObjectUtils.requireNonNull((Object)bytes);
        if (bytes.readRemaining() > this.writeRemaining()) {
            throw new BufferOverflowException();
        }
        try {
            return this.write(bytes, bytes.readPosition(), bytes.readRemaining());
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public S write(@NotNull BytesStore<?, ?> bytes) throws BufferOverflowException, IllegalStateException {
        if (!1.$assertionsDisabled && bytes == this) {
            throw new AssertionError((Object)"you should not write to yourself !");
        }
        ObjectUtils.requireNonNull(bytes);
        if (bytes.readRemaining() > this.writeRemaining()) {
            throw new BufferOverflowException();
        }
        try {
            return this.write(bytes, bytes.readPosition(), bytes.readRemaining());
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NonNegative
    public long realCapacity();

    default public boolean canWriteDirect(long count) {
        return false;
    }

    @Deprecated
    @NotNull
    default public S writeSome(@NotNull Bytes<?> bytes) throws IllegalStateException {
        try {
            long length = Math.min(bytes.readRemaining(), this.writeRemaining());
            if (length + this.writePosition() >= 0x100000L) {
                length = Math.min(bytes.readRemaining(), this.realCapacity() - this.writePosition());
            }
            this.write(bytes, bytes.readPosition(), length);
            if (length == bytes.readRemaining()) {
                bytes.clear();
            } else {
                bytes.readSkip(length);
                if (bytes.writePosition() > bytes.realCapacity() / 2L) {
                    bytes.compact();
                }
            }
            return (S)this;
        }
        catch (IllegalArgumentException | BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    default public S write(@NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException, IllegalArgumentException {
        BytesInternal.writeFully(bytes, readOffset, length, this);
        return (S)this;
    }

    @NotNull
    default public S write(@NotNull BytesStore<?, ?> bytes, @NonNegative long readOffset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException, IllegalArgumentException {
        ObjectUtils.requireNonNull(bytes);
        Longs.requireNonNegative((long)readOffset);
        Longs.requireNonNegative((long)length);
        if (length + this.writePosition() > this.capacity()) {
            throw new DecoratedBufferOverflowException("Cannot write " + length + " bytes as position is " + this.writePosition() + " and capacity is " + this.capacity());
        }
        BytesInternal.writeFully(bytes, readOffset, length, this);
        return (S)this;
    }

    @NotNull
    default public S write(byte[] byteArray) throws BufferOverflowException, IllegalStateException {
        ObjectUtils.requireNonNull((Object)byteArray);
        try {
            this.write(byteArray, 0, byteArray.length);
            return (S)this;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public S write(byte[] var1, @NonNegative int var2, @NonNegative int var3) throws BufferOverflowException, IllegalStateException, IllegalArgumentException, ArrayIndexOutOfBoundsException;

    default public S unsafeWriteObject(Object o, @NonNegative int length) throws BufferOverflowException, IllegalStateException {
        return this.unsafeWriteObject(o, (o.getClass().isArray() ? 4 : 0) + Jvm.objectHeaderSize(), length);
    }

    default public S unsafeWriteObject(Object o, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IllegalStateException {
        int i;
        if (this.isDirectMemory()) {
            this.writeSkip(length);
            long dest = this.addressForWrite(this.writePosition() - (long)length);
            UnsafeMemory.MEMORY.copyMemory(o, (long)offset, dest, length);
            return (S)this;
        }
        for (i = 0; i < length - 7; i += 8) {
            this.writeLong(UnsafeMemory.unsafeGetLong((Object)o, (long)((long)offset + (long)i)));
        }
        while (i < length) {
            this.writeByte(UnsafeMemory.unsafeGetByte((Object)o, (long)((long)offset + (long)i)));
            ++i;
        }
        return (S)this;
    }

    default public S unsafeWrite(long address, @NonNegative int length) {
        if (this.isDirectMemory()) {
            this.writeSkip(length);
            long destAddress = this.addressForWrite(this.writePosition() - (long)length);
            UnsafeMemory.copyMemory((long)address, (long)destAddress, (int)length);
        } else {
            int i;
            for (i = 0; i < length - 7; i += 8) {
                this.writeLong(UnsafeMemory.unsafeGetLong((long)(address + (long)i)));
            }
            while (i < length) {
                this.writeByte(UnsafeMemory.unsafeGetByte((long)(address + (long)i)));
                ++i;
            }
        }
        return (S)this;
    }

    @NotNull
    public S writeSome(@NotNull ByteBuffer var1) throws BufferOverflowException, IllegalStateException, BufferUnderflowException;

    @NotNull
    default public S writeBoolean(boolean flag) throws BufferOverflowException, IllegalStateException {
        return this.writeByte(flag ? (byte)89 : 78);
    }

    @NotNull
    public S writeOrderedInt(int var1) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public S writeOrderedLong(long var1) throws BufferOverflowException, IllegalStateException;

    default public <E extends Enum<E>> S writeEnum(@NotNull E e) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        return this.write8bit(e.name());
    }

    @NotNull
    default public S appendUtf8(@NotNull CharSequence cs) throws BufferOverflowException, IllegalStateException, BufferUnderflowException {
        return this.appendUtf8(cs, 0, cs.length());
    }

    @NotNull
    default public S appendUtf8(int codepoint) throws BufferOverflowException, IllegalStateException {
        BytesInternal.appendUtf8Char(this, codepoint);
        return (S)this;
    }

    @NotNull
    default public S appendUtf8(char[] chars, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IllegalStateException, BufferUnderflowException, IllegalArgumentException {
        char c;
        int i;
        block3: {
            for (i = 0; i < length; ++i) {
                c = chars[offset + i];
                if (c <= '\u007f') {
                    this.writeByte((byte)c);
                    continue;
                }
                break block3;
            }
            return (S)this;
        }
        while (i < length) {
            c = chars[offset + i];
            BytesInternal.appendUtf8Char(this, c);
            ++i;
        }
        return (S)this;
    }

    @NotNull
    default public S appendUtf8(@NotNull CharSequence cs, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IndexOutOfBoundsException, IllegalStateException, BufferUnderflowException {
        BytesInternal.appendUtf8(this, cs, offset, length);
        return (S)this;
    }

    @NotNull
    default public S appendUtf8(byte[] bytes, @NonNegative int offset, @NonNegative int length, byte coder) throws BufferOverflowException, IllegalStateException {
        if (coder == 0) {
            for (int i = 0; i < length; ++i) {
                byte b = bytes[offset + i];
                int b2 = b & 0xFF;
                BytesInternal.appendUtf8Char(this, b2);
            }
        } else {
            if (!1.$assertionsDisabled && coder != 1) {
                throw new AssertionError();
            }
            for (int i = 0; i < 2 * length; i += 2) {
                byte b1 = bytes[2 * offset + i];
                byte b2 = bytes[2 * offset + i + 1];
                int uBE = (b2 & 0xFF) << 8 | b1 & 0xFF;
                BytesInternal.appendUtf8Char(this, uBE);
            }
        }
        return (S)this;
    }

    @NotNull
    default public S appendUtf8(byte[] bytes, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IllegalStateException {
        for (int i = 0; i < length; ++i) {
            int b3;
            int b2;
            int b = bytes[offset + i] & 0xFF;
            if (b >= 240) {
                b2 = bytes[offset + i + 1] & 0xFF;
                b3 = bytes[offset + i + 2] & 0xFF;
                int b4 = bytes[offset + i + 3] & 0xFF;
                this.writeByte((byte)b4);
                this.writeByte((byte)b3);
                this.writeByte((byte)b2);
                this.writeByte((byte)b);
                i += 3;
                continue;
            }
            if (b >= 224) {
                b2 = bytes[offset + i + 1] & 0xFF;
                b3 = bytes[offset + i + 2] & 0xFF;
                this.writeByte((byte)b3);
                this.writeByte((byte)b2);
                this.writeByte((byte)b);
                i += 2;
                continue;
            }
            if (b >= 192) {
                b2 = bytes[offset + i + 1] & 0xFF;
                this.writeByte((byte)b2);
                this.writeByte((byte)b);
                ++i;
                continue;
            }
            this.writeByte((byte)b);
        }
        return (S)this;
    }

    default public void copyFrom(@NotNull InputStream input) throws IOException, BufferOverflowException, IllegalStateException {
        BytesInternal.copy(input, this);
    }

    default public void writePositionRemaining(@NonNegative long position, @NonNegative long length) throws BufferOverflowException {
        Longs.requireNonNegative((long)position);
        Longs.requireNonNegative((long)length);
        this.writeLimit(position + length);
        this.writePosition(position);
    }

    default public void writeHistogram(@NotNull Histogram histogram) throws BufferOverflowException, IllegalStateException {
        BytesInternal.writeHistogram(this, histogram);
    }

    default public void writeBigDecimal(@NotNull BigDecimal bd) throws BufferOverflowException, IllegalStateException, IllegalArgumentException {
        this.writeBigInteger(bd.unscaledValue());
        this.writeStopBit(bd.scale());
    }

    default public void writeBigInteger(@NotNull BigInteger bi) throws BufferOverflowException, IllegalStateException, IllegalArgumentException {
        byte[] bytes = bi.toByteArray();
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        this.writeStopBit(bytes.length);
        this.write(bytes);
    }

    default public void writeWithLength(@NotNull RandomDataInput bytes) throws BufferOverflowException, IllegalStateException {
        this.writeStopBit(bytes.readRemaining());
        this.write(bytes);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

