/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;

public final class CanonicalPathUtil {
    private static final String PREFIX = CanonicalPathUtil.class.getName() + Math.abs(new SecureRandom().nextInt(0x40000000)) + "::";

    private CanonicalPathUtil() {
    }

    public static String of(@NotNull File file) {
        try {
            return (PREFIX + file.getCanonicalPath()).intern();
        }
        catch (IOException ioe) {
            throw new IORuntimeException("Unable to obtain the canonical path for " + file.getAbsolutePath(), (Throwable)ioe);
        }
    }
}

