/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.internal.ChunkedMappedBytes;
import net.openhft.chronicle.bytes.internal.SingleMappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ManagedCloseable;
import org.jetbrains.annotations.NotNull;

public abstract class MappedBytes
extends AbstractBytes<Void>
implements Closeable,
ManagedCloseable {
    protected static final boolean TRACE = Jvm.getBoolean((String)"trace.mapped.bytes");

    protected MappedBytes() throws IllegalStateException {
        this("");
    }

    protected MappedBytes(String name) throws IllegalStateException {
        super(NoBytesStore.noBytesStore(), NoBytesStore.noBytesStore().writePosition(), NoBytesStore.noBytesStore().writeLimit(), name);
    }

    @NotNull
    public static MappedBytes singleMappedBytes(@NotNull String filename, long capacity) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.singleMappedBytes(new File(filename), capacity);
    }

    @NotNull
    public static MappedBytes singleMappedBytes(@NotNull File file, long capacity) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.singleMappedBytes(file, capacity, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes singleMappedBytes(@NotNull File file, long capacity, boolean readOnly) throws FileNotFoundException, IllegalStateException {
        @NotNull MappedFile rw = MappedFile.ofSingle(file, capacity, false);
        try {
            SingleMappedBytes singleMappedBytes = new SingleMappedBytes(rw);
            return singleMappedBytes;
        }
        finally {
            rw.release(INIT);
        }
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull String filename, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(new File(filename), chunkSize);
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(file, chunkSize, OS.pageSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize, long overlapSize) throws FileNotFoundException, IllegalStateException {
        @NotNull MappedFile rw = MappedFile.of(file, chunkSize, overlapSize, false);
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(rw);
            return mappedBytes;
        }
        finally {
            rw.release(INIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize, long overlapSize, boolean readOnly) throws FileNotFoundException, IllegalStateException {
        @NotNull MappedFile rw = MappedFile.of(file, chunkSize, overlapSize, readOnly);
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(rw);
            return mappedBytes;
        }
        finally {
            rw.release(INIT);
        }
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull MappedFile rw) throws IllegalStateException {
        return rw.createBytesFor();
    }

    @NotNull
    public static MappedBytes readOnly(@NotNull File file) throws FileNotFoundException {
        ChunkedMappedBytes chunkedMappedBytes;
        MappedFile mappedFile = MappedFile.readOnly(file);
        try {
            chunkedMappedBytes = new ChunkedMappedBytes(mappedFile);
        }
        catch (Throwable throwable) {
            try {
                mappedFile.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw new AssertionError((Object)e);
            }
        }
        mappedFile.release(INIT);
        return chunkedMappedBytes;
    }

    public abstract boolean isBackingFileReadOnly();

    @Override
    public boolean sharedMemory() {
        return true;
    }

    public abstract MappedBytes disableThreadSafetyCheck(boolean var1);

    public abstract void chunkCount(long[] var1);

    public abstract MappedFile mappedFile();
}

