/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;

public abstract class AbstractBytesStore<B extends BytesStore<B, U>, U>
extends AbstractReferenceCounted
implements BytesStore<B, U> {
    protected AbstractBytesStore() {
    }

    protected AbstractBytesStore(boolean monitored) {
        super(monitored);
    }

    @Override
    public int peekUnsignedByte(long offset) throws BufferUnderflowException, IllegalStateException {
        return offset >= this.readLimit() ? -1 : this.readUnsignedByte(offset);
    }

    public int hashCode() {
        return BytesStoreHash.hash32(this);
    }

    @Override
    public long readPosition() {
        return 0L;
    }

    @Override
    public long readRemaining() {
        return this.readLimit() - this.readPosition();
    }

    @Override
    public long writeRemaining() {
        return this.writeLimit() - this.writePosition();
    }

    @Override
    public long start() {
        return 0L;
    }

    protected boolean canReleaseInBackground() {
        return this.isDirectMemory();
    }
}

