/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BinaryWireCode;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;

public class GuardedNativeBytes<Underlying>
extends NativeBytes<Underlying> {
    static final byte BYTE_T = -92;
    static final byte SHORT_T = -91;
    static final byte INT_T = -90;
    static final byte LONG_T = -89;
    static final byte STOP_T = -82;
    static final byte FLOAT_T = -112;
    static final byte DOUBLE_T = -111;
    private static final String[] STRING_FOR_CODE = BinaryWireCode._stringForCode(GuardedNativeBytes.class);

    public GuardedNativeBytes(@NotNull BytesStore<?, ?> store, long capacity) throws IllegalStateException, IllegalArgumentException {
        super(store, capacity);
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeByte(byte i8) throws BufferOverflowException, IllegalStateException {
        super.writeByte((byte)-92);
        return super.writeByte(i8);
    }

    @Override
    public Bytes<Underlying> rawWriteByte(byte i8) throws BufferOverflowException, IllegalStateException {
        return super.writeByte(i8);
    }

    @Override
    public Bytes<Underlying> rawWriteInt(int i) throws BufferOverflowException, IllegalStateException {
        return super.writeInt(i);
    }

    @Override
    public byte readByte() throws IllegalStateException {
        this.expectByte((byte)-92);
        return super.readByte();
    }

    @Override
    public byte rawReadByte() throws IllegalStateException {
        return super.readByte();
    }

    @Override
    public int rawReadInt() throws IllegalStateException, BufferUnderflowException {
        return super.readInt();
    }

    @Override
    public int readUnsignedByte() throws IllegalStateException {
        this.expectByte((byte)-92);
        return super.readUnsignedByte();
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeShort(short i16) throws BufferOverflowException, IllegalStateException {
        super.writeByte((byte)-91);
        return super.writeShort(i16);
    }

    @Override
    public short readShort() throws BufferUnderflowException, IllegalStateException {
        this.expectByte((byte)-91);
        return super.readShort();
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeStopBit(char x) throws BufferOverflowException, IllegalStateException {
        super.writeByte((byte)-82);
        return (Bytes)super.writeStopBit(x);
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeStopBit(long x) throws BufferOverflowException, IllegalStateException {
        super.writeByte((byte)-82);
        return (Bytes)super.writeStopBit(x);
    }

    @Override
    public long readStopBit() throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        this.expectByte((byte)-82, (byte)-91);
        return super.readStopBit();
    }

    @Override
    public char readStopBitChar() throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        this.expectByte((byte)-82);
        return super.readStopBitChar();
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeInt(int i) throws BufferOverflowException, IllegalStateException {
        super.writeByte((byte)-90);
        return super.writeInt(i);
    }

    @Override
    public int readInt() throws BufferUnderflowException, IllegalStateException {
        this.expectByte((byte)-90);
        return super.readInt();
    }

    @Override
    @NotNull
    public Bytes writeLong(long i64) throws BufferOverflowException, IllegalStateException {
        super.writeByte((byte)-89);
        return super.writeLong(i64);
    }

    @Override
    public long readLong() throws BufferUnderflowException, IllegalStateException {
        this.expectByte((byte)-89);
        return super.readLong();
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeFloat(float f) throws BufferOverflowException, IllegalStateException {
        super.writeByte((byte)-112);
        return super.writeFloat(f);
    }

    @Override
    public float readFloat() throws BufferUnderflowException, IllegalStateException {
        this.expectByte((byte)-112);
        return super.readFloat();
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeDouble(double d) throws BufferOverflowException, IllegalStateException {
        super.writeByte((byte)-111);
        return super.writeDouble(d);
    }

    @Override
    public double readDouble() throws BufferUnderflowException, IllegalStateException {
        this.expectByte((byte)-111);
        return super.readDouble();
    }

    private void expectByte(byte expected) throws IllegalStateException {
        byte type = super.readByte();
        if (type != expected) {
            throw new IllegalStateException("Expected " + STRING_FOR_CODE[expected & 0xFF] + " but was " + STRING_FOR_CODE[type & 0xFF]);
        }
    }

    private void expectByte(byte expected, byte expected2) throws IllegalStateException {
        byte type = super.readByte();
        if (type != expected && type != expected2) {
            throw new IllegalStateException("Expected " + STRING_FOR_CODE[expected & 0xFF] + " but was " + STRING_FOR_CODE[type & 0xFF]);
        }
    }
}

