/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.AbstractBytesStore;
import net.openhft.chronicle.bytes.internal.BytesFieldInfo;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import org.jetbrains.annotations.NotNull;

public class HeapBytesStore<Underlying>
extends AbstractBytesStore<HeapBytesStore<Underlying>, Underlying> {
    @NotNull
    private final Object realUnderlyingObject;
    private final int dataOffset;
    private final long capacity;
    @NotNull
    private final Underlying underlyingObject;
    private UnsafeMemory memory = UnsafeMemory.MEMORY;

    private HeapBytesStore(@NotNull ByteBuffer byteBuffer) {
        super(false);
        this.underlyingObject = byteBuffer;
        this.realUnderlyingObject = byteBuffer.array();
        this.dataOffset = Jvm.arrayByteBaseOffset() + byteBuffer.arrayOffset();
        this.capacity = byteBuffer.capacity();
    }

    private HeapBytesStore(@NotNull @NotNull byte @NotNull [] byteArray) {
        super(false);
        this.underlyingObject = (Underlying)byteArray;
        this.realUnderlyingObject = byteArray;
        this.dataOffset = Jvm.arrayByteBaseOffset();
        this.capacity = byteArray.length;
    }

    private HeapBytesStore(Object object, long start, long length) {
        super(false);
        this.underlyingObject = object;
        this.realUnderlyingObject = object;
        this.dataOffset = Math.toIntExact(start);
        this.capacity = length;
    }

    public static <T> HeapBytesStore<T> forFields(Object o, String groupName, int padding) {
        BytesFieldInfo lookup = BytesFieldInfo.lookup(o.getClass());
        long start = lookup.startOf(groupName);
        long length = lookup.lengthOf(groupName);
        return new HeapBytesStore(o, start + (long)padding, length - (long)padding);
    }

    @NotNull
    public static HeapBytesStore<byte[]> wrap(@NotNull byte[] byteArray) {
        return new HeapBytesStore<byte[]>(byteArray);
    }

    @NotNull
    public static HeapBytesStore<ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return new HeapBytesStore<ByteBuffer>(bb);
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @Override
    public void move(long from, long to, long length) throws BufferUnderflowException, ArithmeticException {
        if (from < 0L || to < 0L) {
            throw new BufferUnderflowException();
        }
        this.throwExceptionIfReleased();
        try {
            this.memory.copyMemory(this.realUnderlyingObject, (long)this.dataOffset + from, this.realUnderlyingObject, (long)this.dataOffset + to, Maths.toUInt31((long)length));
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public String toString() {
        return BytesInternal.toString(this);
    }

    @Override
    @NotNull
    public BytesStore<HeapBytesStore<Underlying>, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    protected void performRelease() {
        this.memory = null;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public Underlying underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        try {
            return this.memory.compareAndSwapInt(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public void testAndSetInt(long offset, int expected, int value) throws IllegalStateException {
        try {
            this.memory.testAndSetInt(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        try {
            return this.memory.compareAndSwapLong(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public byte readByte(long offset) throws BufferUnderflowException {
        try {
            return this.memory.readByte(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public short readShort(long offset) throws BufferUnderflowException {
        try {
            return this.memory.readShort(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public int readInt(long offset) throws BufferUnderflowException {
        try {
            return this.memory.readInt(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public long readLong(long offset) throws BufferUnderflowException {
        try {
            return this.memory.readLong(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public float readFloat(long offset) throws BufferUnderflowException {
        try {
            return this.memory.readFloat(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public double readDouble(long offset) throws BufferUnderflowException {
        try {
            return this.memory.readDouble(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        try {
            return this.memory.readVolatileByte(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        try {
            return this.memory.readVolatileShort(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        try {
            this.throwExceptionIfReleased();
            return this.memory.readVolatileInt(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        try {
            this.throwExceptionIfReleased();
            return this.memory.readVolatileLong(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public long write8bit(long position, BytesStore bs) {
        int i;
        int length0 = Math.toIntExact(bs.readRemaining());
        position = BytesUtil.writeStopBit(this, position, length0);
        for (i = 0; i < length0 - 7; i += 8) {
            this.writeLong(position + (long)i, bs.readLong(i));
        }
        while (i < length0) {
            this.writeByte(position + (long)i, bs.readByte(i));
            ++i;
        }
        return position + (long)length0;
    }

    @Override
    public long write8bit(long position, String s, int start, int length) {
        try {
            this.throwExceptionIfReleased();
            position = BytesInternal.writeStopBit(this, position, length);
            this.memory.write8bit(s, start, this.realUnderlyingObject, (long)this.dataOffset + position, length);
            return position + (long)length;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeByte(long offset, byte b) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeByte(this.realUnderlyingObject, (long)this.dataOffset + offset, b);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeShort(long offset, short i16) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeShort(this.realUnderlyingObject, (long)this.dataOffset + offset, i16);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeInt(long offset, int i32) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeOrderedInt(long offset, int i32) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeOrderedInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeLong(long offset, long i64) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i64);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeOrderedLong(long offset, long i) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeOrderedLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeFloat(long offset, float f) throws BufferOverflowException {
        try {
            this.memory.writeFloat(this.realUnderlyingObject, (long)this.dataOffset + offset, f);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeDouble(long offset, double d) throws BufferOverflowException {
        try {
            this.memory.writeDouble(this.realUnderlyingObject, (long)this.dataOffset + offset, d);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileByte(long offset, byte i8) throws BufferOverflowException {
        try {
            this.memory.writeVolatileByte(this.realUnderlyingObject, (long)this.dataOffset + offset, i8);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileShort(long offset, short i16) throws BufferOverflowException {
        try {
            this.memory.writeVolatileShort(this.realUnderlyingObject, (long)this.dataOffset + offset, i16);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileInt(long offset, int i32) throws BufferOverflowException {
        try {
            this.memory.writeVolatileInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileLong(long offset, long i64) throws BufferOverflowException {
        try {
            this.memory.writeVolatileLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i64);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException {
        try {
            this.memory.copyMemory(bytes, offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public void write(long offsetInRDO, @NotNull ByteBuffer bytes, int offset, int length) throws BufferOverflowException {
        try {
            assert (this.realUnderlyingObject == null || this.dataOffset >= (Jvm.is64bit() ? 12 : 8));
            if (bytes.isDirect()) {
                this.memory.copyMemory(Jvm.address((ByteBuffer)bytes), this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
            } else {
                this.memory.copyMemory(bytes.array(), offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
            }
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> write(long writeOffset, @NotNull RandomDataInput bytes, long readOffset, long length) throws IllegalStateException, BufferUnderflowException, BufferOverflowException {
        if (length == (long)((int)length)) {
            int i;
            int length0 = (int)length;
            for (i = 0; i < length0 - 7; i += 8) {
                long x = bytes.readLong(readOffset + (long)i);
                this.writeLong(writeOffset + (long)i, x);
            }
            while (i < length0) {
                byte x = bytes.readByte(readOffset + (long)i);
                this.writeByte(writeOffset + (long)i, x);
                ++i;
            }
        } else {
            this.writeLongLength(writeOffset, bytes, readOffset, length);
        }
        return this;
    }

    private void writeLongLength(long writeOffset, @NotNull RandomDataInput bytes, long readOffset, long length) throws IllegalStateException, BufferUnderflowException, BufferOverflowException {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            long x = bytes.readLong(readOffset + i);
            this.writeLong(writeOffset + i, x);
        }
        while (i < length) {
            byte x = bytes.readByte(readOffset + i);
            this.writeByte(writeOffset + i, x);
            ++i;
        }
    }

    @Override
    public long addressForRead(long offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWrite(long offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nativeRead(long position, long address, long size) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        throw new UnsupportedOperationException("todo");
    }

    public boolean equals(Object obj) {
        try {
            return obj instanceof BytesStore && BytesInternal.contentEqual(this, (BytesStore)obj);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }
}

