/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.UncheckedBytes;
import net.openhft.chronicle.bytes.UncheckedNativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.EnbeddedBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Bytes<Underlying>
extends BytesStore<Bytes<Underlying>, Underlying>,
BytesIn<Underlying>,
BytesOut<Underlying> {
    public static final long MAX_CAPACITY = 0x7FFFFFFFFFFFFFF0L;
    public static final int MAX_HEAP_CAPACITY = 0x7FFFFFF0;
    public static final int DEFAULT_BYTE_BUFFER_CAPACITY = 256;

    @NotNull
    public static Bytes<ByteBuffer> elasticByteBuffer() {
        return Bytes.elasticByteBuffer(256);
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticByteBuffer(int initialCapacity) {
        return Bytes.elasticByteBuffer(initialCapacity, 0x7FFFFFF0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<ByteBuffer> elasticByteBuffer(int initialCapacity, int maxCapacity) {
        Bytes<ByteBuffer> bytes;
        @NotNull BytesStore<?, ByteBuffer> bs = BytesStore.elasticByteBuffer(initialCapacity, maxCapacity);
        try {
            bytes = bs.bytesForWrite();
        }
        catch (Throwable throwable) {
            try {
                bs.release(ReferenceOwner.INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(ReferenceOwner.INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticHeapByteBuffer(int initialCapacity) {
        @NotNull BytesStore<?, ByteBuffer> bs = BytesStore.wrap(ByteBuffer.allocate(initialCapacity));
        try {
            NativeBytes<ByteBuffer> nativeBytes = NativeBytes.wrapWithNativeBytes(bs, 0x7FFFFFF0L);
            return nativeBytes;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            try {
                bs.release(INIT);
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticHeapByteBuffer() {
        return Bytes.elasticHeapByteBuffer(128);
    }

    public static <T> Bytes<T> forFieldGroup(T t, String groupName) {
        @NotNull BytesStore<?, T> bs = BytesStore.forFields(t, groupName, 1);
        try {
            EnbeddedBytes bytes = EnbeddedBytes.wrap(bs);
            StreamingDataOutput streamingDataOutput = bytes.writeLimit(bs.writeLimit());
            return streamingDataOutput;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            try {
                bs.release(INIT);
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<ByteBuffer> wrapForRead(@NotNull ByteBuffer byteBuffer) {
        Bytes<ByteBuffer> bytes;
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bbb = bs.bytesForRead();
            bbb.readLimit(byteBuffer.limit());
            bbb.readPosition(byteBuffer.position());
            bytes = bbb;
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException | BufferUnderflowException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<ByteBuffer> wrapForWrite(@NotNull ByteBuffer byteBuffer) {
        Bytes<ByteBuffer> bytes;
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bbb = bs.bytesForWrite();
            bbb.writePosition(byteBuffer.position());
            bbb.writeLimit(byteBuffer.limit());
            bytes = bbb;
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException | BufferOverflowException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<byte[]> wrapForRead(@NotNull byte[] byteArray) {
        Bytes<byte[]> bytes;
        @NotNull BytesStore<?, byte[]> bs = BytesStore.wrap(byteArray);
        try {
            bytes = bs.bytesForRead();
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<byte[]> wrapForWrite(@NotNull byte[] byteArray) {
        Bytes<byte[]> bytes;
        @NotNull BytesStore<?, byte[]> bs = BytesStore.wrap(byteArray);
        try {
            bytes = bs.bytesForWrite();
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<byte[]> from(@NotNull CharSequence text) {
        return Bytes.from(text.toString());
    }

    public static Bytes<Void> fromDirect(@NotNull CharSequence text) {
        return (Bytes)NativeBytes.nativeBytes(text.length()).append(text);
    }

    @NotNull
    public static Bytes<?> directFrom(@NotNull String text) {
        Bytes bytes;
        BytesStore from = BytesStore.from(text);
        try {
            bytes = from.bytesForRead();
        }
        catch (Throwable throwable) {
            try {
                from.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        from.release(INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<byte[]> from(@NotNull String text) {
        return Bytes.wrapForRead(text.getBytes(StandardCharsets.ISO_8859_1));
    }

    @UsedViaReflection
    public static Bytes<byte[]> valueOf(String text) {
        return Bytes.from(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VanillaBytes<Void> allocateDirect(long capacity) throws IllegalArgumentException {
        NativeBytes<Void> nativeBytes;
        @NotNull BytesStore<?, Void> bs = BytesStore.nativeStoreWithFixedCapacity(capacity);
        try {
            nativeBytes = new NativeBytes<Void>(bs);
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return nativeBytes;
    }

    @NotNull
    public static NativeBytes<Void> allocateElasticDirect() {
        return NativeBytes.nativeBytes();
    }

    @NotNull
    public static NativeBytes<Void> allocateElasticDirect(long initialCapacity) throws IllegalArgumentException {
        return NativeBytes.nativeBytes(initialCapacity);
    }

    @NotNull
    public static OnHeapBytes allocateElasticOnHeap() {
        return Bytes.allocateElasticOnHeap(32);
    }

    @NotNull
    public static OnHeapBytes allocateElasticOnHeap(int initialCapacity) {
        OnHeapBytes onHeapBytes;
        BytesStore<?, byte[]> wrap = BytesStore.wrap(new byte[initialCapacity]);
        try {
            onHeapBytes = new OnHeapBytes(wrap, true);
        }
        catch (Throwable throwable) {
            try {
                wrap.release(INIT);
                throw throwable;
            }
            catch (IllegalArgumentException | IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        wrap.release(INIT);
        return onHeapBytes;
    }

    @NotNull
    public static String toString(@NotNull Bytes<?> buffer) throws BufferUnderflowException, IllegalStateException, IllegalArgumentException {
        return Bytes.toString(buffer, 0x7FFFFFF0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String toString(@NotNull Bytes<?> buffer, long maxLen) throws BufferUnderflowException, IllegalStateException, IllegalArgumentException {
        if (buffer.refCount() < 1) {
            return "<unknown>";
        }
        ReferenceOwner toString = ReferenceOwner.temporary((String)"toString");
        buffer.reserve(toString);
        try {
            if (buffer.readRemaining() == 0L) {
                String string = "";
                return string;
            }
            long length = Math.min(maxLen + 1L, buffer.readRemaining());
            @NotNull StringBuilder builder = new StringBuilder();
            try {
                buffer.readWithLength(length, b -> {
                    while (buffer.readRemaining() > 0L) {
                        if ((long)builder.length() >= maxLen) {
                            builder.append("...");
                            break;
                        }
                        builder.append((char)buffer.readByte());
                    }
                });
            }
            catch (Exception e) {
                builder.append(' ').append(e);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.release(toString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String toString(@NotNull Bytes buffer, long position, long len) {
        String string;
        long pos = buffer.readPosition();
        long limit = buffer.readLimit();
        buffer.readPositionRemaining(position, len);
        try {
            @NotNull StringBuilder builder = new StringBuilder();
            while (buffer.readRemaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                buffer.readLimit(limit);
                buffer.readPosition(pos);
                throw throwable;
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        buffer.readLimit(limit);
        buffer.readPosition(pos);
        return string;
    }

    @NotNull
    public static VanillaBytes allocateDirect(@NotNull byte[] bytes) throws IllegalArgumentException {
        VanillaBytes<Void> result = Bytes.allocateDirect(bytes.length);
        try {
            result.write(bytes);
        }
        catch (IllegalStateException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return result;
    }

    @NotNull
    public static Bytes fromHexString(@NotNull String s) {
        return BytesInternal.fromHexString(s);
    }

    public static int indexOf(@NotNull BytesStore source, @NotNull BytesStore target, int fromIndex) throws IllegalStateException {
        long sourceOffset = source.readPosition();
        long targetOffset = target.readPosition();
        long sourceCount = source.readRemaining();
        long targetCount = target.readRemaining();
        if ((long)fromIndex >= sourceCount) {
            return Math.toIntExact(targetCount == 0L ? sourceCount : -1L);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0L) {
            return fromIndex;
        }
        try {
            byte firstByte = target.readByte(targetOffset);
            long max = sourceOffset + (sourceCount - targetCount);
            for (long i = sourceOffset + (long)fromIndex; i <= max; ++i) {
                if (source.readByte(i) != firstByte) {
                    while (++i <= max && source.readByte(i) != firstByte) {
                    }
                }
                if (i > max) continue;
                long j = i + 1L;
                long end = j + targetCount - 1L;
                long k = targetOffset + 1L;
                while (j < end && source.readByte(j) == target.readByte(k)) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return Math.toIntExact(i - sourceOffset);
            }
            return -1;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    default public Bytes<Underlying> unchecked(boolean unchecked) throws IllegalStateException {
        if (unchecked) {
            if (this.isElastic()) {
                BytesUtil.WarnUncheckedElasticBytes.warn();
            }
            UncheckedBytes underlyingBytes = this.start() == 0L && this.bytesStore().isDirectMemory() ? new UncheckedNativeBytes(this) : new UncheckedBytes(this);
            this.release(INIT);
            return underlyingBytes;
        }
        return this;
    }

    default public boolean unchecked() {
        return false;
    }

    @Override
    default public long safeLimit() {
        return this.bytesStore().safeLimit();
    }

    @Override
    default public boolean isClear() {
        return this.start() == this.readPosition() && this.writeLimit() == this.capacity();
    }

    @Override
    default public long realCapacity() {
        return BytesStore.super.realCapacity();
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy() throws IllegalStateException;

    @NotNull
    default public String toHexString() {
        return this.toHexString(1024L);
    }

    @NotNull
    default public String toHexString(long maxLength) {
        return this.toHexString(this.readPosition(), maxLength);
    }

    @NotNull
    default public String toHexString(long offset, long maxLength) {
        long maxLength2 = Math.min(maxLength, this.readLimit() - offset);
        try {
            @NotNull String ret = BytesInternal.toHexString(this, offset, maxLength2);
            return maxLength2 < this.readLimit() - offset ? ret + "... truncated" : ret;
        }
        catch (IllegalStateException | BufferUnderflowException e) {
            return e.toString();
        }
    }

    public boolean isElastic();

    default public void ensureCapacity(long desiredCapacity) throws IllegalArgumentException, IllegalStateException {
        if (desiredCapacity > this.capacity()) {
            throw new IllegalArgumentException(this.isElastic() ? "todo" : "not elastic");
        }
    }

    @Override
    @NotNull
    default public Bytes<Underlying> bytesForRead() throws IllegalStateException {
        try {
            return this.isClear() ? BytesStore.super.bytesForRead() : new SubBytes((BytesStore)this, this.readPosition(), this.readLimit() + this.start());
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @Nullable
    public BytesStore bytesStore();

    default public boolean isEqual(String s) throws IllegalStateException {
        return StringUtils.isEqual((CharSequence)this, (CharSequence)s);
    }

    @NotNull
    public Bytes<Underlying> compact() throws IllegalStateException;

    @Override
    default public long copyTo(@NotNull BytesStore store) throws IllegalStateException {
        return BytesStore.super.copyTo(store);
    }

    @Override
    default public void copyTo(@NotNull OutputStream out) throws IOException, IllegalStateException {
        BytesStore.super.copyTo(out);
    }

    @Override
    default public boolean sharedMemory() {
        return this.bytesStore().sharedMemory();
    }

    default public void unwrite(long fromOffset, int count) throws BufferUnderflowException, BufferOverflowException, IllegalStateException {
        long wp = this.writePosition();
        if (wp < fromOffset) {
            return;
        }
        this.write(fromOffset, this, fromOffset + (long)count, wp - fromOffset - (long)count);
        this.writePosition(wp - (long)count);
    }

    @NotNull
    default public BigDecimal readBigDecimal() throws ArithmeticException, BufferUnderflowException, IllegalStateException {
        return new BigDecimal(this.readBigInteger(), Maths.toUInt31((long)this.readStopBit()));
    }

    @NotNull
    default public BigInteger readBigInteger() throws ArithmeticException, BufferUnderflowException, IllegalStateException {
        int length = Maths.toUInt31((long)this.readStopBit());
        if (length == 0) {
            if (this.lenient()) {
                return BigInteger.ZERO;
            }
            throw new BufferUnderflowException();
        }
        byte[] bytes = new byte[length];
        this.read(bytes);
        return new BigInteger(bytes);
    }

    default public long indexOf(@NotNull Bytes source) throws IllegalStateException {
        return Bytes.indexOf(this, source, 0);
    }

    default public int indexOf(@NotNull BytesStore source, int fromIndex) throws IllegalStateException {
        return Bytes.indexOf(this, source, fromIndex);
    }

    @Override
    @NotNull
    public Bytes<Underlying> clear() throws IllegalStateException;

    @Override
    default public boolean readWrite() {
        return this.bytesStore().readWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void readWithLength(long length, @NotNull BytesOut<Underlying> bytesOut) throws BufferUnderflowException, IORuntimeException, BufferOverflowException, IllegalStateException {
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        boolean lenient = this.lenient();
        try {
            this.lenient(true);
            this.readLimit(limit);
            bytesOut.write(this);
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
            this.lenient(lenient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public <T extends ReadBytesMarshallable> T readMarshallableLength16(Class<T> tClass, T object) throws BufferUnderflowException, IllegalStateException {
        if (object == null) {
            object = (ReadBytesMarshallable)ObjectUtils.newInstance(tClass);
        }
        int length = this.readUnsignedShort();
        long limit = this.readLimit();
        long end = this.readPosition() + (long)length;
        boolean lenient = this.lenient();
        try {
            this.lenient(true);
            this.readLimit(end);
            object.readMarshallable(this);
        }
        finally {
            this.readPosition(end);
            this.readLimit(limit);
            this.lenient(lenient);
        }
        return (T)object;
    }

    @Override
    default public void writeMarshallableLength16(WriteBytesMarshallable marshallable) throws IllegalArgumentException, BufferOverflowException, IllegalStateException, BufferUnderflowException {
        long position = this.writePosition();
        try {
            this.writeUnsignedShort(0);
            marshallable.writeMarshallable(this);
            long length = this.writePosition() - position - 2L;
            if (length >= 65536L) {
                throw new IllegalStateException("Marshallable " + marshallable.getClass() + " too long was " + length);
            }
            this.writeUnsignedShort(position, (int)length);
        }
        catch (ArithmeticException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public Bytes write(InputStream inputStream) throws IOException, BufferOverflowException, IllegalStateException {
        int read;
        while ((read = inputStream.read()) != -1) {
            this.writeByte((byte)read);
        }
        return this;
    }
}

