/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.GuardedNativeBytes;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeBytes<U>
extends VanillaBytes<U> {
    private static final boolean BYTES_GUARDED;
    private static boolean newGuarded;
    private long capacity;

    public NativeBytes(@NotNull BytesStore store, long capacity) throws IllegalStateException, IllegalArgumentException {
        super(store, 0L, capacity);
        this.capacity = capacity;
    }

    public NativeBytes(@NotNull BytesStore store) throws IllegalStateException, IllegalArgumentException {
        super(store, 0L, store.capacity());
        this.capacity = store.capacity();
    }

    public static boolean areNewGuarded() {
        return newGuarded;
    }

    public static boolean setNewGuarded(boolean guarded) {
        newGuarded = guarded;
        return true;
    }

    public static void resetNewGuarded() {
        newGuarded = BYTES_GUARDED;
    }

    @NotNull
    public static NativeBytes<Void> nativeBytes() {
        try {
            return NativeBytes.wrapWithNativeBytes(NoBytesStore.noBytesStore(), 0x7FFFFFFFFFFFFFF0L);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NativeBytes<Void> nativeBytes(long initialCapacity) throws IllegalArgumentException {
        NativeBytes<Void> nativeBytes;
        @NotNull BytesStore<?, Void> store = BytesStore.nativeStoreWithFixedCapacity(initialCapacity);
        try {
            nativeBytes = NativeBytes.wrapWithNativeBytes(store, 0x7FFFFFFFFFFFFFF0L);
        }
        catch (Throwable throwable) {
            try {
                store.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw new AssertionError((Object)e);
            }
        }
        store.release(INIT);
        return nativeBytes;
    }

    public static BytesStore<Bytes<Void>, Void> copyOf(@NotNull Bytes bytes) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        long remaining = bytes.readRemaining();
        long position = bytes.readPosition();
        try {
            NativeBytes<Void> bytes2 = Bytes.allocateElasticDirect(remaining);
            bytes2.write(bytes, position, remaining);
            return bytes2;
        }
        catch (IllegalArgumentException | BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static long alignToPageSize(long size) {
        long mask = (long)OS.pageSize() - 1L;
        return size + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @NotNull
    public static <T> NativeBytes<T> wrapWithNativeBytes(@NotNull BytesStore<?, T> bs, long capacity) throws IllegalStateException, IllegalArgumentException {
        ObjectUtils.requireNonNull(bs);
        return newGuarded ? new GuardedNativeBytes(bs, capacity) : new NativeBytes(bs, capacity);
    }

    protected static <T> long maxCapacityFor(@NotNull BytesStore<?, T> bs) {
        return bs.underlyingObject() instanceof ByteBuffer || bs.underlyingObject() instanceof byte[] ? 0x7FFFFFF0L : 0x7FFFFFFFFFFFFFF0L;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException, IllegalStateException {
        long writeEnd;
        if (offset >= this.bytesStore.start() && offset + adding >= this.bytesStore.start()) {
            writeEnd = offset + adding;
            if (writeEnd <= this.bytesStore.safeLimit()) {
                return;
            }
            if (writeEnd >= this.capacity) {
                throw new BufferOverflowException();
            }
        } else {
            throw new BufferOverflowException();
        }
        this.checkResize(writeEnd);
    }

    @Override
    void prewriteCheckOffset(long offset, long subtracting) throws BufferOverflowException, IllegalStateException {
        if (offset - subtracting >= this.bytesStore.start()) {
            if (offset <= this.bytesStore.safeLimit()) {
                return;
            }
            if (offset >= this.capacity) {
                throw new BufferOverflowException();
            }
        } else {
            throw new BufferOverflowException();
        }
        this.checkResize(offset);
    }

    @Override
    public void ensureCapacity(long desiredCapacity) throws IllegalArgumentException, IllegalStateException {
        try {
            assert (desiredCapacity >= 0L);
            this.writeCheckOffset(desiredCapacity, 0L);
        }
        catch (BufferOverflowException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Bytes cannot be resized to " + desiredCapacity + " limit: " + this.capacity(), e);
            Jvm.error().on(NativeBytes.class, (Throwable)iae);
            throw iae;
        }
    }

    private void checkResize(long endOfBuffer) throws BufferOverflowException, IllegalStateException {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(endOfBuffer);
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    @Override
    public boolean isEqual(long start, long length, String s) {
        return this.bytesStore.isEqual(start, length, s);
    }

    private void resize(long endOfBuffer) throws BufferOverflowException, IllegalStateException {
        BytesStore store;
        this.throwExceptionIfReleased();
        if (endOfBuffer < 0L) {
            throw new DecoratedBufferOverflowException(endOfBuffer + "< 0");
        }
        if (endOfBuffer > this.capacity()) {
            throw new DecoratedBufferOverflowException(endOfBuffer + ">" + this.capacity());
        }
        long realCapacity = this.realCapacity();
        if (endOfBuffer <= realCapacity) {
            return;
        }
        long size = Math.max(endOfBuffer + 7L, realCapacity * 3L / 2L + 32L);
        size = this.isDirectMemory() || size > 0x7FFFFFF0L ? NativeBytes.alignToPageSize(size) : (size &= 0xFFFFFFFFFFFFFFF8L);
        size = Math.min(size, this.capacity());
        boolean isByteBufferBacked = this.bytesStore.underlyingObject() instanceof ByteBuffer;
        if (isByteBufferBacked && size > 0x7FFFFFF0L) {
            StackTrace stackTrace = new StackTrace();
            String stack = BytesUtil.asString("Calling stack is", (Throwable)stackTrace);
            Jvm.warn().on(this.getClass(), "Going to try to replace ByteBuffer-backed BytesStore with raw NativeBytesStore to grow to " + size / 1024L + " KB. If later it is assumed that this bytes' underlyingObject() is ByteBuffer, NullPointerException is likely to be thrown. " + stack);
        }
        if (endOfBuffer >= 131072L) {
            Jvm.perf().on(this.getClass(), "Resizing buffer was " + realCapacity / 1024L + " KB, needs " + (endOfBuffer - realCapacity) + " bytes more, new-size " + size / 1024L + " KB");
        }
        int position = 0;
        try {
            if (isByteBufferBacked && size <= 0x7FFFFFF0L) {
                position = ((ByteBuffer)this.bytesStore.underlyingObject()).position();
                try {
                    store = this.allocateNewByteBufferBackedStore(Maths.toInt32((long)size));
                }
                catch (ArithmeticException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                store = BytesStore.lazyNativeBytesStoreWithFixedCapacity(size);
                if (this.referenceCounted.unmonitored()) {
                    AbstractReferenceCounted.unmonitor(store);
                }
            }
            store.reserveTransfer(INIT, (ReferenceOwner)this);
        }
        catch (IllegalArgumentException e) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.initCause(e);
            throw boe;
        }
        this.throwExceptionIfReleased();
        @Nullable BytesStore tempStore = this.bytesStore;
        this.bytesStore.copyTo(store);
        this.bytesStore(store);
        try {
            tempStore.release((ReferenceOwner)this);
        }
        catch (IllegalStateException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        if (this.bytesStore.underlyingObject() instanceof ByteBuffer) {
            @Nullable ByteBuffer byteBuffer = (ByteBuffer)this.bytesStore.underlyingObject();
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            byteBuffer.position(position);
        }
    }

    @Override
    protected void bytesStore(@NotNull BytesStore<Bytes<U>, U> bytesStore) {
        if (this.capacity < bytesStore.capacity()) {
            this.capacity = bytesStore.capacity();
        }
        super.bytesStore(bytesStore);
    }

    @Override
    public void bytesStore(@NotNull BytesStore<Bytes<U>, U> byteStore, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferUnderflowException {
        ObjectUtils.requireNonNull(byteStore);
        if (this.capacity < offset + length) {
            this.capacity = offset + length;
        }
        super.bytesStore(byteStore, offset, length);
    }

    @NotNull
    private BytesStore allocateNewByteBufferBackedStore(int size) {
        if (this.isDirectMemory()) {
            return BytesStore.elasticByteBuffer(size, this.capacity());
        }
        return BytesStore.wrap(ByteBuffer.allocate(size));
    }

    @Override
    @NotNull
    public NativeBytes writeSome(@NotNull Bytes bytes) throws IllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        AbstractBytes.ReportUnoptimised.reportOnce();
        try {
            long length = Math.min(bytes.readRemaining(), this.writeRemaining());
            if (length + this.writePosition() >= 0x100000L) {
                length = Math.min(bytes.readRemaining(), this.realCapacity() - this.writePosition());
            }
            long offset = bytes.readPosition();
            this.ensureCapacity(this.writePosition() + length);
            this.optimisedWrite(bytes, offset, length);
            if (length == bytes.readRemaining()) {
                bytes.clear();
            } else {
                bytes.readSkip(length);
                if (bytes.writePosition() > bytes.realCapacity() / 2L) {
                    bytes.compact();
                }
            }
            return this;
        }
        catch (IllegalArgumentException | BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected long writeOffsetPositionMoved(long adding, long advance) throws BufferOverflowException, IllegalStateException {
        long oldPosition = this.writePosition();
        if (this.writePosition < this.bytesStore.start()) {
            throw new BufferOverflowException();
        }
        long writeEnd = this.writePosition() + adding;
        if (writeEnd > this.writeLimit) {
            this.throwBeyondWriteLimit(advance, writeEnd);
        } else if (writeEnd > this.bytesStore.safeLimit()) {
            this.checkResize(writeEnd);
        }
        this.uncheckedWritePosition(this.writePosition() + advance);
        return oldPosition;
    }

    private void throwBeyondWriteLimit(long advance, long writeEnd) throws DecoratedBufferOverflowException {
        throw new DecoratedBufferOverflowException("attempt to write " + advance + " bytes to " + writeEnd + " limit: " + this.writeLimit);
    }

    @Override
    @NotNull
    public Bytes<U> writeByte(byte i8) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLong(long i64) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    public long readRemaining() {
        return this.writePosition() - this.readPosition;
    }

    static {
        newGuarded = BYTES_GUARDED = Jvm.getBoolean((String)"bytes.guarded");
    }

    @Deprecated
    public static final class NativeSubBytes
    extends SubBytes {
        private final NativeBytesStore nativeBytesStore;

        public NativeSubBytes(@NotNull BytesStore bytesStore, long start, long capacity) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            super(bytesStore, start, capacity);
            this.nativeBytesStore = (NativeBytesStore)this.bytesStore;
        }

        @Override
        public long read(long offsetInRDI, @NotNull byte[] bytes, int offset, int length) {
            int i;
            int len = (int)Math.min((long)length, this.readLimit() - offsetInRDI);
            long address = this.nativeBytesStore.address + this.nativeBytesStore.translate(offsetInRDI);
            for (i = 0; i < len - 7; i += 8) {
                UnsafeMemory.unsafePutLong((byte[])bytes, (int)i, (long)this.nativeBytesStore.memory.readLong(address + (long)i));
            }
            if (i < len - 3) {
                UnsafeMemory.unsafePutInt((byte[])bytes, (int)i, (int)this.nativeBytesStore.memory.readInt(address + (long)i));
                i += 4;
            }
            while (i < len) {
                UnsafeMemory.unsafePutByte((byte[])bytes, (int)i, (byte)this.nativeBytesStore.memory.readByte(address + (long)i));
                ++i;
            }
            return len;
        }
    }
}

