/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesMethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.MethodEncoder;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;

public class BinaryBytesMethodWriterInvocationHandler
extends AbstractInvocationHandler
implements BytesMethodWriterInvocationHandler {
    private final Function<Method, MethodEncoder> methodToId;
    private final BytesOut out;
    private final Map<Method, MethodEncoder> methodToIdMap = new LinkedHashMap<Method, MethodEncoder>();

    public BinaryBytesMethodWriterInvocationHandler(Function<Method, MethodEncoder> methodToId, BytesOut out) {
        super(HashMap::new);
        this.methodToId = methodToId;
        this.out = out;
    }

    protected Object doInvoke(Object proxy, Method method, Object[] args) throws IllegalStateException, BufferOverflowException, BufferUnderflowException, IllegalArgumentException, ArithmeticException {
        MethodEncoder info = this.methodToIdMap.computeIfAbsent(method, this.methodToId);
        if (info == null) {
            Jvm.warn().on(this.getClass(), "Unknown method " + method + " ignored");
        } else {
            this.out.comment(method.getName());
            this.out.writeStopBit(info.messageId());
            info.encode(args, this.out);
        }
        return null;
    }
}

