/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.channels.FileLock;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractReference
extends AbstractCloseable
implements Byteable,
Closeable {
    @Nullable
    protected BytesStore<?, ?> bytes;
    protected long offset;

    protected AbstractReference() {
        this.disableThreadSafetyCheck(true);
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        bytes.readInt(offset);
        BytesStore bytesStore = bytes.bytesStore();
        this.acceptNewBytesStore(bytesStore);
        this.offset = offset;
    }

    @Nullable
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    protected void acceptNewBytesStore(@NotNull BytesStore bytes) throws IllegalStateException {
        if (this.bytes != null) {
            this.bytes.release((ReferenceOwner)this);
        }
        bytes.readInt(this.offset);
        this.bytes = bytes.bytesStore();
        this.bytes.reserve((ReferenceOwner)this);
    }

    protected void performClose() throws IllegalStateException {
        if (this.bytes != null) {
            this.bytes.release((ReferenceOwner)this);
            this.bytes = null;
        }
    }

    @Override
    public long address() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytesStore().addressForRead(this.offset);
    }

    @Override
    public FileLock lock(boolean shared) throws IOException {
        if (this.bytesStore() instanceof MappedBytesStore) {
            MappedBytesStore mbs = (MappedBytesStore)this.bytesStore();
            return mbs.lock(this.offset, this.maxSize(), shared);
        }
        return Byteable.super.lock(shared);
    }

    @Override
    public FileLock tryLock(boolean shared) throws IOException {
        if (this.bytesStore() instanceof MappedBytesStore) {
            MappedBytesStore mbs = (MappedBytesStore)this.bytesStore();
            return mbs.tryLock(this.offset, this.maxSize(), shared);
        }
        return Byteable.super.tryLock(shared);
    }
}

