/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.HeapBytesStore;
import org.jetbrains.annotations.NotNull;

public class EnbeddedBytes<Underlying>
extends VanillaBytes<Underlying> {
    private EnbeddedBytes(@NotNull BytesStore bytesStore, long writePosition, long writeLimit) throws IllegalStateException, IllegalArgumentException {
        super(bytesStore, writePosition, writeLimit);
    }

    public static <U> EnbeddedBytes<U> wrap(BytesStore bytesStore) {
        return EnbeddedBytes.wrap((HeapBytesStore)bytesStore);
    }

    public static <U> EnbeddedBytes<U> wrap(HeapBytesStore bytesStore) {
        long wp = bytesStore.start();
        int length = bytesStore.readUnsignedByte(wp - 1L);
        return new EnbeddedBytes(bytesStore, wp, wp + (long)length);
    }

    @Override
    protected void uncheckedWritePosition(long writePosition) {
        super.uncheckedWritePosition(writePosition);
        this.bytesStore.writeUnsignedByte(this.bytesStore.start() - 1L, (int)writePosition);
    }

    @Override
    public long writePosition() {
        return this.bytesStore.readUnsignedByte(this.bytesStore.start() - 1L);
    }
}

