/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import sun.misc.Unsafe;

public class BytesFieldInfo {
    private static final ClassLocal<BytesFieldInfo> CACHE = ClassLocal.withInitial(BytesFieldInfo::init);
    static final Pattern nameDigits = Pattern.compile("^(\\w*\\D)\\d+$");
    static final Field $END$;
    private final Map<String, BFIEntry> groups = new LinkedHashMap<String, BFIEntry>();
    private final Class<?> aClass;

    BytesFieldInfo(Class<?> aClass) {
        this.aClass = aClass;
        List fields = Stream.of(aClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).sorted(Comparator.comparingLong(arg_0 -> ((UnsafeMemory)UnsafeMemory.MEMORY).getFieldOffset(arg_0))).collect(Collectors.toList());
        String prefix0 = "";
        BFIEntry entry = null;
        for (int i = 0; i <= fields.size(); ++i) {
            Matcher matcher;
            Field field = i == fields.size() ? $END$ : (Field)fields.get(i);
            boolean matches = false;
            String prefix = "";
            long position = 0L;
            int size = 0;
            if (field.getType().isPrimitive() && (matcher = nameDigits.matcher(field.getName())).matches()) {
                position = UnsafeMemory.MEMORY.getFieldOffset(field);
                size = BytesFieldInfo.sizeOf(field.getType());
                prefix = matcher.group(1);
                matches = prefix.equals(prefix0);
            }
            if (matches) {
                entry.end = position + (long)size;
                continue;
            }
            if (prefix.isEmpty()) continue;
            if (this.groups.containsKey(prefix)) {
                Jvm.warn().on(aClass, "Disjoined fields starting with " + prefix);
                prefix0 = "";
                continue;
            }
            entry = new BFIEntry();
            entry.start = position;
            entry.end = position + (long)size;
            this.groups.put(prefix, entry);
            prefix0 = prefix;
        }
    }

    private static int sizeOf(Class<?> type) {
        return type == Boolean.TYPE || type == Byte.TYPE ? 1 : (type == Short.TYPE || type == Character.TYPE ? 2 : (type == Integer.TYPE || type == Float.TYPE ? 4 : (type == Long.TYPE || type == Double.TYPE ? 8 : Unsafe.ARRAY_OBJECT_INDEX_SCALE)));
    }

    private static BytesFieldInfo init(Class<?> aClass) {
        return new BytesFieldInfo(aClass);
    }

    public static BytesFieldInfo lookup(Class<?> aClass) {
        return (BytesFieldInfo)CACHE.get(aClass);
    }

    public Set<String> groups() {
        return this.groups.keySet();
    }

    public long startOf(String groupName) {
        BFIEntry bfiEntry = this.groups.get(groupName);
        if (bfiEntry == null) {
            throw new IllegalArgumentException("No groupName " + groupName + " found in " + this.aClass);
        }
        return bfiEntry.start;
    }

    public long lengthOf(String groupName) {
        BFIEntry bfiEntry = this.groups.get(groupName);
        if (bfiEntry == null) {
            throw new IllegalArgumentException("No groupName " + groupName + " found in " + this.aClass);
        }
        return bfiEntry.end - bfiEntry.start;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder().append("type: ").append(this.getClass().getSimpleName()).append(", groups: { ");
        sb.append(this.groups.entrySet().stream().map(e -> (String)e.getKey() + ": " + ((BFIEntry)e.getValue()).start + " to " + ((BFIEntry)e.getValue()).end).collect(Collectors.joining(", ")));
        return sb.append(" }").toString();
    }

    static {
        try {
            $END$ = BytesFieldInfo.class.getDeclaredField("$END$");
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class BFIEntry {
        long start;
        long end;

        BFIEntry() {
        }
    }
}

