/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.IOException;
import java.io.Writer;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public class ByteStringWriter
extends Writer {
    private final ByteStringAppender out;

    ByteStringWriter(ByteStringAppender out) {
        this.out = out;
    }

    @Override
    public void write(int c) throws IOException {
        try {
            this.out.append((char)c);
        }
        catch (IllegalStateException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(@NotNull String str) throws IOException {
        this.out.append(str);
    }

    @Override
    public void write(@NotNull String str, int off, int len) throws IOException {
        this.out.append(str, off, off + len);
    }

    @Override
    @NotNull
    public Writer append(@NotNull CharSequence csq) throws IOException {
        this.out.append(csq);
        return this;
    }

    @Override
    @NotNull
    public Writer append(@NotNull CharSequence csq, int start, int end) {
        this.out.append(csq, start, end);
        return this;
    }

    @Override
    @NotNull
    public Writer append(char c) {
        try {
            this.out.append(c);
        }
        catch (IllegalStateException e) {
            throw Jvm.rethrow((Throwable)e);
        }
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            for (int i = 0; i < len; ++i) {
                this.out.append(cbuf[i + off]);
            }
        }
        catch (IllegalStateException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }
}

