/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UncheckedBytes<Underlying>
extends AbstractBytes<Underlying> {
    Bytes underlyingBytes;

    public UncheckedBytes(@NotNull Bytes underlyingBytes) throws IllegalStateException {
        super(underlyingBytes.bytesStore(), underlyingBytes.writePosition(), underlyingBytes.writeLimit());
        this.underlyingBytes = underlyingBytes;
        this.readPosition(underlyingBytes.readPosition());
    }

    public void setBytes(@NotNull Bytes bytes) throws IllegalStateException {
        BytesStore underlyingBytes = bytes.bytesStore();
        if (this.bytesStore != underlyingBytes) {
            this.bytesStore.release((ReferenceOwner)this);
            this.bytesStore(underlyingBytes);
            this.bytesStore.reserve((ReferenceOwner)this);
        }
        this.readPosition(bytes.readPosition());
        this.uncheckedWritePosition(bytes.writePosition());
        this.writeLimit = bytes.writeLimit();
        this.underlyingBytes = bytes;
    }

    @Override
    public void ensureCapacity(long size) throws IllegalArgumentException {
        if (size > this.realCapacity()) {
            this.underlyingBytes.ensureCapacity(size);
            this.bytesStore(this.underlyingBytes.bytesStore());
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> unchecked(boolean unchecked) {
        return this;
    }

    @Override
    public boolean unchecked() {
        return true;
    }

    @Override
    void writeCheckOffset(long offset, long adding) {
    }

    @Override
    void readCheckOffset(long offset, long adding, boolean given) {
    }

    @Override
    void prewriteCheckOffset(long offset, long subtracting) {
    }

    @Override
    @NotNull
    public Bytes<Underlying> readPosition(long position) {
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readLimit(long limit) {
        this.uncheckedWritePosition(limit);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writePosition(long position) {
        this.uncheckedWritePosition(position);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readSkip(long bytesToSkip) {
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeSkip(long bytesToSkip) {
        this.uncheckedWritePosition(this.writePosition() + bytesToSkip);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLimit(long limit) {
        this.writeLimit = limit;
        return this;
    }

    @Override
    @NotNull
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    protected long readOffsetPositionMoved(long adding) {
        long offset = this.readPosition;
        this.readPosition += adding;
        return offset;
    }

    @Override
    protected long writeOffsetPositionMoved(long adding, long advance) {
        long oldPosition = this.writePosition();
        this.uncheckedWritePosition(this.writePosition() + advance);
        return oldPosition;
    }

    @Override
    protected long prewriteOffsetPositionMoved(long subtracting) throws BufferOverflowException {
        return this.readPosition -= subtracting;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull RandomDataInput bytes, long offset, long length) throws BufferOverflowException, IllegalArgumentException {
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, IllegalArgumentException {
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.underlyingObject() == null && this.bytesStore.isDirectMemory() && length >= 32L) {
            this.rawCopy(bytes, offset, length);
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException {
        if (cs instanceof RandomDataInput) {
            return this.write((RandomDataInput)((Object)cs));
        }
        int length = cs.length();
        long offset = this.writeOffsetPositionMoved(length);
        for (int i = 0; i < length; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte(offset, (byte)c);
        }
        return this;
    }

    long rawCopy(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, IllegalArgumentException {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.capacity() - offset, length));
        if (len > 0L) {
            this.writeCheckOffset(this.writePosition(), len);
            OS.memory().copyMemory(bytes.addressForRead(offset), this.addressForWritePosition(), len);
            this.writeSkip(len);
        }
        return len;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeByte(byte i8) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(1L, 1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeUtf8(String s) throws BufferOverflowException {
        if (s == null) {
            this.writeStopBit(-1L);
            return this;
        }
        try {
            if (Jvm.isJava9Plus()) {
                byte[] strBytes = StringUtils.extractBytes((String)s);
                byte coder = StringUtils.getStringCoder((String)s);
                long utfLength = AppendableUtil.findUtf8Length(strBytes, coder);
                this.writeStopBit(utfLength);
                this.appendUtf8(strBytes, 0, s.length(), coder);
            } else {
                char[] chars = StringUtils.extractChars((String)s);
                long utfLength = AppendableUtil.findUtf8Length(chars);
                this.writeStopBit(utfLength);
                if (utfLength == (long)chars.length) {
                    this.append8bit(chars);
                } else {
                    this.appendUtf8(chars, 0, chars.length);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    void append8bit(char[] chars) throws BufferOverflowException, IllegalArgumentException {
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            this.bytesStore.writeByte(this.writePosition++, (byte)c);
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> appendUtf8(char[] chars, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        char c;
        int i;
        block3: {
            for (i = 0; i < length; ++i) {
                c = chars[offset + i];
                if (c <= '\u007f') {
                    this.bytesStore.writeByte(this.writePosition++, (byte)c);
                    continue;
                }
                break block3;
            }
            return this;
        }
        while (i < length) {
            c = chars[offset + i];
            BytesInternal.appendUtf8Char(this, c);
            ++i;
        }
        return this;
    }
}

