/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;

public class OnHeapBytes
extends VanillaBytes<byte[]> {
    public static final int MAX_CAPACITY = 0x7FFFFFF8;
    private final boolean elastic;
    private final long capacity;

    public OnHeapBytes(@NotNull BytesStore bytesStore, boolean elastic) throws IllegalStateException {
        super(bytesStore);
        this.elastic = elastic;
        this.capacity = elastic ? 0x7FFFFFF8L : bytesStore.capacity();
        this.writePosition(0L);
        this.writeLimit(this.capacity());
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public boolean isElastic() {
        return this.elastic;
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException {
        long writeEnd;
        if (offset >= this.bytesStore.start()) {
            writeEnd = offset + adding;
            if (writeEnd <= this.bytesStore.safeLimit()) {
                return;
            }
        } else {
            throw new BufferOverflowException();
        }
        this.checkResize(writeEnd);
    }

    private void checkResize(long endOfBuffer) throws BufferOverflowException {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(endOfBuffer);
    }

    private void resize(long endOfBuffer) throws BufferOverflowException {
        HeapBytesStore<byte[]> store;
        if (endOfBuffer < 0L) {
            throw new BufferOverflowException();
        }
        if (endOfBuffer > this.capacity()) {
            throw new BufferOverflowException();
        }
        long realCapacity = this.realCapacity();
        if (endOfBuffer <= realCapacity) {
            return;
        }
        long size0 = Math.max(endOfBuffer, realCapacity * 3L / 2L);
        int size = (int)Math.min(size0, this.capacity());
        if (endOfBuffer > 0x100000L) {
            Jvm.warn().on(this.getClass(), "Resizing buffer was " + realCapacity / 1024L + " KB, needs " + (endOfBuffer - realCapacity) + " bytes more, new-size " + size / 1024 + " KB");
        }
        try {
            store = HeapBytesStore.wrap(new byte[size]);
            store.reserveTransfer(INIT, (ReferenceOwner)this);
        }
        catch (IllegalArgumentException e) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.initCause(e);
            throw boe;
        }
        BytesStore tempStore = this.bytesStore;
        this.bytesStore.copyTo(store);
        this.bytesStore(store);
        try {
            tempStore.release((ReferenceOwner)this);
        }
        catch (IllegalStateException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
    }
}

