/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.ByteableLongArrayValues;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.values.LongValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryLongArrayReference
extends AbstractReference
implements ByteableLongArrayValues,
BytesMarshallable {
    private static final long CAPACITY = 0L;
    private static final long USED = 8L;
    private static final long VALUES = 16L;
    private static final int MAX_TO_STRING = 1024;
    @Nullable
    private static Set<WeakReference<BinaryLongArrayReference>> binaryLongArrayReferences = null;
    @Nullable
    private long length = 16L;

    public static void startCollecting() {
        binaryLongArrayReferences = Collections.newSetFromMap(new IdentityHashMap());
    }

    public static void forceAllToNotCompleteState() {
        binaryLongArrayReferences.forEach(x -> {
            @Nullable BinaryLongArrayReference binaryLongReference = (BinaryLongArrayReference)x.get();
            if (binaryLongReference != null) {
                binaryLongReference.setValueAt(0L, -1L);
            }
        });
        binaryLongArrayReferences = null;
    }

    public static void write(@NotNull Bytes bytes, long capacity) throws BufferOverflowException, IllegalArgumentException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        long start = bytes.writePosition();
        bytes.zeroOut(start, start + (capacity << 3));
        bytes.writeSkip(capacity << 3);
    }

    public static void lazyWrite(@NotNull Bytes bytes, long capacity) throws BufferOverflowException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        bytes.writeSkip(capacity << 3);
    }

    public static long peakLength(@NotNull BytesStore bytes, long offset) throws BufferUnderflowException {
        long capacity = bytes.readLong(offset + 0L);
        assert (capacity > 0L) : "capacity too small " + capacity;
        return (capacity << 3) + 16L;
    }

    public long getCapacity() {
        return this.length - 16L >>> 3;
    }

    public long getUsed() {
        return this.bytes.readVolatileLong(this.offset + 8L);
    }

    public void setMaxUsed(long usedAtLeast) {
        this.bytes.writeMaxLong(this.offset + 8L, usedAtLeast);
    }

    public long getValueAt(long index) throws BufferUnderflowException {
        return this.bytes.readLong(16L + this.offset + (index << 3));
    }

    public void setValueAt(long index, long value) throws IllegalArgumentException, BufferOverflowException {
        this.bytes.writeLong(16L + this.offset + (index << 3), value);
    }

    public long getVolatileValueAt(long index) throws BufferUnderflowException {
        return this.bytes.readVolatileLong(16L + this.offset + (index << 3));
    }

    public void bindValueAt(int index, @NotNull LongValue value) {
        ((BinaryLongReference)value).bytesStore(this.bytes, 16L + this.offset + (long)(index << 3), 8L);
    }

    public void setOrderedValueAt(long index, long value) throws IllegalArgumentException, BufferOverflowException {
        this.bytes.writeOrderedLong(16L + this.offset + (index << 3), value);
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws BufferUnderflowException, IllegalArgumentException {
        if (length != BinaryLongArrayReference.peakLength(bytes, offset)) {
            throw new IllegalArgumentException(length + " != " + BinaryLongArrayReference.peakLength(bytes, offset));
        }
        assert ((offset & 7L) == 0L) : "offset=" + offset;
        super.bytesStore(bytes, offset + 7L & 0xFFFFFFFFFFFFFFF8L, length);
        this.length = length;
    }

    @Override
    public void readMarshallable(BytesIn bytes) throws IORuntimeException {
        long position = bytes.readPosition();
        long capacity = bytes.readLong();
        long used = bytes.readLong();
        if (capacity < 0L || capacity > bytes.readRemaining() >> 3) {
            throw new IORuntimeException("Corrupt used capacity");
        }
        if (used < 0L || used > capacity) {
            throw new IORuntimeException("Corrupt used value");
        }
        bytes.readSkip(capacity * 8L);
        long length = bytes.readPosition() - position;
        this.bytesStore(((Bytes)bytes).bytesStore(), position, length);
    }

    @Override
    public void writeMarshallable(BytesOut bytes) {
        BytesStore bytesStore = this.bytesStore();
        if (bytesStore == null) {
            long capacity = this.getCapacity();
            bytes.writeLong(capacity);
            bytes.writeLong(0L);
            bytes.writeSkip(capacity * 8L);
        } else {
            bytes.write(bytesStore, this.offset, 16L + this.length * 8L);
        }
    }

    public boolean isNull() {
        return this.bytes == null;
    }

    public void reset() {
        this.bytes = null;
        this.offset = 0L;
        this.length = 0L;
    }

    @Override
    @Nullable
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return this.length;
    }

    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "not set";
        }
        @NotNull StringBuilder sb = new StringBuilder();
        sb.append("used: ");
        long used = this.getUsed();
        sb.append(used);
        sb.append(", value: ");
        @NotNull String sep = "";
        try {
            int i;
            int max = (int)Math.min(used, Math.min(this.getCapacity(), 1024L));
            for (i = 0; i < max; ++i) {
                long valueAt = this.getValueAt(i);
                sb.append(sep).append(valueAt);
                sep = ", ";
            }
            if ((long)i < this.getCapacity()) {
                sb.append(" ...");
            }
        }
        catch (BufferUnderflowException e) {
            sb.append(" ").append(e);
        }
        return sb.toString();
    }

    @Override
    public long sizeInBytes(long capacity) {
        return (capacity << 3) + 16L;
    }

    @Override
    public ByteableLongArrayValues capacity(long arrayLength) {
        BytesStore bytesStore = this.bytesStore();
        long length = this.sizeInBytes(arrayLength);
        if (bytesStore == null) {
            this.length = length;
        } else assert (this.length == length);
        return this;
    }

    public boolean compareAndSet(long index, long expected, long value) throws IllegalArgumentException, BufferOverflowException {
        if (value == -1L && binaryLongArrayReferences != null) {
            binaryLongArrayReferences.add(new WeakReference<BinaryLongArrayReference>(this));
        }
        return this.bytes.compareAndSwapLong(16L + this.offset + (index << 3), expected, value);
    }
}

