/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.ClassMetrics;
import org.jetbrains.annotations.Nullable;

public class ClassUtils {
    public static void updateClass(Class aClass, long find, long replace, String domain, @Nullable UpdateConsumer consumer) throws IOException {
        boolean wasUpdated = false;
        String file = ClassUtils.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        String dir = file.replaceAll("target/.*", "target");
        for (File jar : new File(dir).listFiles()) {
            if (!jar.getName().endsWith(".jar") || jar.getName().contains("guarded")) continue;
            ClassUtils.updateClass(aClass, find, replace, jar, domain, consumer);
            wasUpdated = true;
        }
        if (!wasUpdated) {
            throw new IllegalStateException("failed to update any class");
        }
    }

    private static void updateClass(Class aClass, long find, long replace, File jar, String domain, @Nullable UpdateConsumer consumer) throws IOException {
        String classPath = aClass.getName().replace('.', '/').concat(".class");
        String file = aClass.getClassLoader().getResource(classPath).getFile();
        Bytes bytes = BytesUtil.readFile(file);
        long find2 = Long.reverseBytes(find);
        long replace2 = Long.reverseBytes(replace);
        int i = 0;
        while ((long)i < bytes.readRemaining() - 7L) {
            long l = bytes.readLong(i);
            if (l == find2 || l == replace2) {
                bytes.writeLong(i, replace2);
                BytesUtil.writeFile(file + ".tmp", bytes);
                ClassMetrics.updateJar((String)jar.getAbsolutePath(), (String)(file + ".tmp"), (String)classPath);
                if (consumer != null) {
                    consumer.accept(jar, replace, domain, file);
                }
                return;
            }
            ++i;
        }
        throw new AssertionError((Object)("Unable to find magic in " + file));
    }

    public static interface UpdateConsumer {
        public void accept(File var1, long var2, String var4, String var5);
    }
}

