/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class UncheckedLongReference
implements LongReference {
    private long address;
    private Unsafe unsafe;

    @NotNull
    public static LongReference create(BytesStore bytesStore, long offset, int size) {
        LongReference ref = Jvm.isDebug() ? new BinaryLongReference() : new UncheckedLongReference();
        ref.bytesStore(bytesStore, offset, size);
        return ref;
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        this.address = bytes.addressForRead(offset);
        bytes.reserve();
        this.unsafe = UnsafeMemory.UNSAFE;
    }

    @NotNull
    public BytesStore bytesStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long offset() {
        return this.address;
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return this.address == 0L ? "addressForRead is 0" : "value: " + this.getValue();
    }

    public long getValue() {
        return this.unsafe.getLong(this.address);
    }

    public void setValue(long value) {
        this.unsafe.putLong(this.address, value);
    }

    public long getVolatileValue() {
        return this.unsafe.getLong(this.address);
    }

    public void setOrderedValue(long value) {
        this.unsafe.putOrderedLong(null, this.address, value);
    }

    public long addValue(long delta) {
        return this.unsafe.getAndAddLong(null, this.address, delta) + delta;
    }

    public long addAtomicValue(long delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) {
        return this.unsafe.compareAndSwapLong(null, this.address, expected, value);
    }
}

