/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.MethodWriterListener;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface MethodWriterInterceptor {
    public static MethodWriterInterceptor of(@Nullable MethodWriterListener methodWriterListener, @Nullable MethodWriterInterceptor interceptor) {
        if (methodWriterListener == null && interceptor == null) {
            throw new IllegalArgumentException("both methodWriterListener and interceptor are NULL");
        }
        if (methodWriterListener == null) {
            return interceptor::intercept;
        }
        if (interceptor == null) {
            return (method, args, invoker) -> {
                methodWriterListener.onWrite(method.getName(), args);
                invoker.accept(method, args);
            };
        }
        return (method, args, invoker) -> {
            interceptor.intercept(method, args, invoker);
            methodWriterListener.onWrite(method.getName(), args);
        };
    }

    public void intercept(Method var1, Object[] var2, BiConsumer<Method, Object[]> var3);
}

