/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryLongReference
extends AbstractReference
implements LongReference {
    public static final long LONG_NOT_COMPLETE = -1L;
    @Nullable
    private static Set<WeakReference<BinaryLongReference>> binaryLongReferences;

    public static void startCollecting() {
        binaryLongReferences = new CopyOnWriteArraySet<WeakReference<BinaryLongReference>>();
    }

    public static void forceAllToNotCompleteState() {
        binaryLongReferences.forEach(x -> {
            BinaryLongReference binaryLongReference = (BinaryLongReference)x.get();
            if (binaryLongReference != null) {
                binaryLongReference.setValue(-1L);
            }
        });
        binaryLongReferences = null;
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException, BufferUnderflowException {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        super.bytesStore(bytes, offset, length);
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return this.bytes == null ? "bytes is null" : "value: " + this.getValue();
    }

    public long getValue() {
        return this.bytes == null ? 0L : this.bytes.readLong(this.offset);
    }

    public void setValue(long value) {
        this.bytes.writeLong(this.offset, value);
    }

    public long getVolatileValue() {
        return this.bytes.readVolatileLong(this.offset);
    }

    public void setOrderedValue(long value) {
        this.bytes.writeOrderedLong(this.offset, value);
    }

    public long addValue(long delta) {
        return this.bytes.addAndGetLong(this.offset, delta);
    }

    public long addAtomicValue(long delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) {
        if (value == -1L && binaryLongReferences != null) {
            binaryLongReferences.add(new WeakReference<BinaryLongReference>(this));
        }
        return this.bytes.compareAndSwapLong(this.offset, expected, value);
    }
}

