/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class NativeBytes<Underlying>
extends VanillaBytes<Underlying> {
    private final long capacity;

    public NativeBytes(@NotNull BytesStore store, long capacity) throws IllegalStateException {
        super(store, 0L, capacity);
        this.capacity = capacity;
    }

    public NativeBytes(@NotNull BytesStore store) throws IllegalStateException {
        super(store, 0L, Long.MAX_VALUE);
        this.capacity = Long.MAX_VALUE;
    }

    @NotNull
    public static NativeBytes<Void> nativeBytes() {
        try {
            return new NativeBytes<Void>(NoBytesStore.noBytesStore());
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NativeBytes<Void> nativeBytes(long initialCapacity) throws IllegalArgumentException {
        NativeBytes<Void> nativeBytes;
        NativeBytesStore<Void> store = NativeBytesStore.nativeStoreWithFixedCapacity(initialCapacity);
        try {
            nativeBytes = new NativeBytes<Void>(store);
        }
        catch (Throwable throwable) {
            try {
                store.release();
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw new AssertionError((Object)e);
            }
        }
        store.release();
        return nativeBytes;
    }

    public static BytesStore<Bytes<Void>, Void> copyOf(@NotNull Bytes bytes) {
        long remaining = bytes.readRemaining();
        try {
            NativeBytes<Void> bytes2 = Bytes.allocateElasticDirect(remaining);
            bytes2.write(bytes, 0L, remaining);
            return bytes2;
        }
        catch (IllegalArgumentException | BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static long alignToPageSize(long size) {
        long mask = OS.pageSize() - 1;
        return size + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException {
        long writeEnd;
        if (offset >= this.bytesStore.start()) {
            writeEnd = offset + adding;
            if (writeEnd <= this.bytesStore.safeLimit()) {
                return;
            }
        } else {
            throw new BufferOverflowException();
        }
        this.checkResize(writeEnd);
    }

    @Override
    public void ensureCapacity(long size) throws IllegalArgumentException {
        try {
            assert (size >= 0L);
            this.writeCheckOffset(size, 0L);
        }
        catch (BufferOverflowException e) {
            throw new IllegalArgumentException("Bytes cannot be resized to " + size + " limit: " + this.capacity());
        }
    }

    private void checkResize(long endOfBuffer) throws BufferOverflowException {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(endOfBuffer);
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    private void resize(long endOfBuffer) throws BufferOverflowException {
        BytesStore store;
        boolean isByteBufferBacked;
        if (endOfBuffer < 0L) {
            throw new BufferOverflowException();
        }
        if (endOfBuffer > this.capacity()) {
            throw new BufferOverflowException();
        }
        long realCapacity = this.realCapacity();
        if (endOfBuffer <= realCapacity) {
            return;
        }
        long size = Math.max(endOfBuffer, realCapacity * 3L / 2L);
        size = Math.min(size, this.capacity());
        if (this.isDirectMemory() || size > (long)MAX_BYTE_BUFFER_CAPACITY) {
            size = NativeBytes.alignToPageSize(size);
            size = Math.min(size, this.capacity());
        }
        if ((isByteBufferBacked = this.bytesStore.underlyingObject() instanceof ByteBuffer) && size > (long)MAX_BYTE_BUFFER_CAPACITY) {
            Jvm.warn().on(this.getClass(), "Going to try to replace ByteBuffer-backed BytesStore with raw NativeBytesStore to grow to " + size / 1024L + " KB. If later it is assumed that this bytes' underlyingObject() is ByteBuffer, NullPointerException is likely to be thrown");
        }
        if (endOfBuffer > 0x100000L) {
            Jvm.warn().on(this.getClass(), "Resizing buffer was " + realCapacity / 1024L + " KB, needs " + (endOfBuffer - realCapacity) + " bytes more, new-size " + size / 1024L + " KB");
        }
        int position = 0;
        try {
            if (isByteBufferBacked && size <= (long)MAX_BYTE_BUFFER_CAPACITY) {
                position = ((ByteBuffer)this.bytesStore.underlyingObject()).position();
                store = this.allocateNewByteBufferBackedStore(Maths.toInt32((long)size));
            } else {
                store = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity(size);
            }
        }
        catch (IllegalArgumentException e) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.initCause(e);
            throw boe;
        }
        BytesStore tempStore = this.bytesStore;
        this.bytesStore.copyTo(store);
        this.bytesStore = store;
        try {
            tempStore.release();
        }
        catch (IllegalStateException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        if (this.bytesStore.underlyingObject() instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)this.bytesStore.underlyingObject();
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            byteBuffer.position(position);
        }
    }

    @NotNull
    private BytesStore allocateNewByteBufferBackedStore(int size) {
        if (this.isDirectMemory()) {
            return NativeBytesStore.elasticByteBuffer(size, this.capacity());
        }
        return HeapBytesStore.wrap(ByteBuffer.allocate(size));
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        if ((long)length > this.writeRemaining()) {
            throw new BufferOverflowException();
        }
        long position = this.writePosition();
        this.ensureCapacity(position + (long)length);
        super.write(bytes, offset, length);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(BytesStore bytes, long offset, long length) throws BufferOverflowException, IllegalArgumentException, BufferUnderflowException {
        long position = this.writePosition();
        this.ensureCapacity(position + length);
        super.write(bytes, offset, length);
        return this;
    }

    @Override
    @NotNull
    public NativeBytes writeSome(@NotNull Bytes bytes) {
        try {
            long length = Math.min(bytes.readRemaining(), this.writeRemaining());
            if (length + this.writePosition() >= 0x100000L) {
                length = Math.min(bytes.readRemaining(), this.realCapacity() - this.writePosition());
            }
            long offset = bytes.readPosition();
            long position = this.writePosition();
            this.ensureCapacity(position + length);
            this.optimisedWrite(bytes, offset, length);
            if (length == bytes.readRemaining()) {
                bytes.clear();
            } else {
                bytes.readSkip(length);
                if (bytes.writePosition() > bytes.realCapacity() / 2L) {
                    bytes.compact();
                }
            }
            return this;
        }
        catch (IllegalArgumentException | BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected long writeOffsetPositionMoved(long adding, long advance) throws BufferOverflowException {
        long oldPosition = this.writePosition;
        if (this.writePosition < this.bytesStore.start()) {
            throw new BufferOverflowException();
        }
        long writeEnd = this.writePosition + adding;
        if (writeEnd > this.bytesStore.safeLimit()) {
            this.checkResize(writeEnd);
        }
        this.writePosition += advance;
        return oldPosition;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeByte(byte i8) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(1L, 1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write8bit(@Nullable BytesStore bs) throws BufferOverflowException {
        if (bs == null) {
            this.writeStopBit(-1L);
        } else {
            long offset = bs.readPosition();
            long readRemaining = Math.min(this.writeRemaining(), bs.readLimit() - offset);
            this.writeStopBit(readRemaining);
            this.write(bs, offset, readRemaining);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLong(long i64) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(8L, 8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    public long readRemaining() {
        return this.writePosition - this.readPosition;
    }

    public static class NativeSubBytes
    extends SubBytes {
        private NativeBytesStore nativeBytesStore;

        public NativeSubBytes(@NotNull BytesStore bytesStore, long start, long capacity) throws IllegalStateException {
            super(bytesStore, start, capacity);
            this.nativeBytesStore = (NativeBytesStore)this.bytesStore;
        }

        @Override
        public long read(long offsetInRDI, byte[] bytes, int offset, int length) {
            int i;
            int len = (int)Math.min((long)length, this.readLimit() - offsetInRDI);
            long offset2 = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
            long address = this.nativeBytesStore.address + this.nativeBytesStore.translate(offsetInRDI);
            for (i = 0; i < len - 7; i += 8) {
                UnsafeMemory.UNSAFE.putLong(bytes, offset2 + (long)i, this.nativeBytesStore.memory.readLong(address + (long)i));
            }
            if (i < len - 3) {
                UnsafeMemory.UNSAFE.putInt(bytes, offset2 + (long)i, this.nativeBytesStore.memory.readInt(address + (long)i));
                i += 4;
            }
            while (i < len) {
                UnsafeMemory.UNSAFE.putByte(bytes, offset2 + (long)i, this.nativeBytesStore.memory.readByte(address + (long)i));
                ++i;
            }
            return len;
        }
    }
}

