/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.pool;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import org.jetbrains.annotations.NotNull;

public class BytesPool {
    final ThreadLocal<Bytes> bytesTL = new ThreadLocal();

    public Bytes acquireBytes() {
        Bytes bytes = this.bytesTL.get();
        if (bytes == null) {
            bytes = this.createBytes();
            this.bytesTL.set(bytes);
        } else {
            bytes.clear();
        }
        return bytes;
    }

    @NotNull
    protected Bytes createBytes() {
        NativeBytes<Void> bytes = Bytes.allocateElasticDirect(256L);
        assert (BytesUtil.unregister(bytes));
        return bytes;
    }
}

